/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.codec.binary.Base64;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpHost;
import org.frameworkset.spi.remote.http.proxy.ExceptionWare;
import org.frameworkset.spi.remote.http.proxy.HealthCheck;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.HttpHostDiscover;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHostsConfig;
import org.frameworkset.spi.remote.http.proxy.NoHttpServerException;
import org.frameworkset.spi.remote.http.proxy.RoundRobinList;
import org.frameworkset.spi.remote.http.proxy.route.RoutingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceHosts {
    private static final Logger logger = LoggerFactory.getLogger(HttpServiceHosts.class);
    private final HttpServiceHostsConfig httpServiceHostsConfig;
    private ExceptionWare exceptionWare;
    private HttpHostDiscover hostDiscover;
    protected RoundRobinList serversList;
    protected List<HttpAddress> addressList;
    private HealthCheck healthCheck;
    private Map<String, HttpAddress> addressMap;
    private String routing;
    private RoutingFilter routingFilter;
    private final ReadWriteLock routingFilterLock = new ReentrantReadWriteLock();
    private final Lock routingFilterReadLock = this.routingFilterLock.readLock();
    private final Lock routingFilterWriteLock = this.routingFilterLock.writeLock();
    private ClientConfiguration clientConfiguration;
    private boolean healthCheckStarted;
    private boolean failAllContinue = true;
    private boolean hasRouting = false;
    private boolean closed = false;

    public HttpServiceHostsConfig getHttpServiceHostsConfig() {
        return this.httpServiceHostsConfig;
    }

    public HttpServiceHosts() {
        this.httpServiceHostsConfig = new HttpServiceHostsConfig();
    }

    public boolean isFailAllContinue() {
        return this.failAllContinue;
    }

    public void setFailAllContinue(boolean failAllContinue) {
        this.failAllContinue = failAllContinue;
    }

    public boolean healthCheckStarted() {
        return this.healthCheckStarted;
    }

    public HttpAddress getHttpAddress() {
        HttpAddress httpAddress = null;
        if (!this.hasRouting) {
            httpAddress = this.serversList.get();
            if (httpAddress == null && (this.failAllContinue || !this.healthCheckStarted)) {
                httpAddress = this.serversList.getOkOrFailed();
            }
            if (httpAddress == null) {
                String message = "All Http Server " + this.serversList.toString() + " can't been connected.";
                throw new NoHttpServerException(message);
            }
        } else {
            this.routingFilterReadLock.lock();
            try {
                httpAddress = this.routingFilter.get();
                if (httpAddress == null && !this.healthCheckStarted) {
                    httpAddress = this.routingFilter.getOkOrFailed();
                }
                if (httpAddress == null) {
                    String message = "All Http Server " + this.routingFilter.toString() + " can't been connected.";
                    throw new NoHttpServerException(message);
                }
            }
            finally {
                this.routingFilterReadLock.unlock();
            }
        }
        return httpAddress;
    }

    public boolean reachEnd(int tryCount) {
        if (!this.hasRouting) {
            return tryCount >= this.serversList.size() - 1;
        }
        this.routingFilterReadLock.lock();
        try {
            boolean bl = tryCount >= this.routingFilter.size() - 1;
            return bl;
        }
        finally {
            this.routingFilterReadLock.unlock();
        }
    }

    public static String getHeader(String user, String password) {
        String auth = user + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("US-ASCII")));
        return "Basic " + new String(encodedAuth);
    }

    public void after(String httpPoolName, GetProperties context) {
        this.addressList = new ArrayList<HttpAddress>();
        this.addressMap = new HashMap<String, HttpAddress>();
        if (this.httpServiceHostsConfig.getHosts() != null && !this.httpServiceHostsConfig.getHosts().trim().equals("")) {
            String[] hostNames;
            for (String host : hostNames = this.httpServiceHostsConfig.getHosts().split(",")) {
                HttpAddress esAddress = new HttpAddress(host.trim(), this.httpServiceHostsConfig.getHealth());
                this.addressList.add(esAddress);
                this.addressMap.put(esAddress.getAddress(), esAddress);
            }
            this.routingGroup(false, null);
        }
        this.serversList = new RoundRobinList(this, this.addressList);
        if (this.httpServiceHostsConfig.getExceptionWare() != null) {
            try {
                Class<?> exceptionWareClass = Class.forName(this.httpServiceHostsConfig.getExceptionWare().trim());
                ExceptionWare exceptionWare_ = (ExceptionWare)exceptionWareClass.newInstance();
                exceptionWare_.setHttpServiceHosts(this);
                this.exceptionWare = exceptionWare_;
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error(" Http pool[" + this.getClientConfiguration().getBeanName() + "]" + "  ExceptionWare init failed:", (Throwable)e);
                }
            }
        } else if (this.exceptionWare != null) {
            this.exceptionWare.setHttpServiceHosts(this);
        }
        this.clientConfiguration.afterStart();
        if (this.httpServiceHostsConfig.getHealthCheckInterval() > 0L && this.httpServiceHostsConfig.getHealth() != null && !this.httpServiceHostsConfig.getHealth().equals("")) {
            if (logger.isInfoEnabled()) {
                logger.info("Start Http pool[" + this.getClientConfiguration().getBeanName() + "]" + " HttpProxy server healthCheck thread,you can set http.healthCheckInterval=-1 in config file to disable healthCheck.");
            }
            this.healthCheck = new HealthCheck(httpPoolName, this.addressList, this.httpServiceHostsConfig.getHealthCheckInterval());
            this.healthCheck.run();
            this.healthCheckStarted = true;
        } else if (logger.isInfoEnabled()) {
            logger.info("HttpProxy server Http pool[" + this.getClientConfiguration().getBeanName() + "]" + " healthCheck is disabled,you can set HttpProxy http.healthCheckInterval (>0) and http.health in configfile to enabled healthCheck.");
        }
        if (this.httpServiceHostsConfig.getDiscoverService() != null && !this.httpServiceHostsConfig.getDiscoverService().equals("")) {
            logger.info("Start Http pool[" + this.getClientConfiguration().getBeanName() + "]" + " discoverHost thread,to distabled set http.discoverService to null in configfile.");
            try {
                Class<?> httpHostDiscoverClass = Class.forName(this.httpServiceHostsConfig.getDiscoverService());
                HttpHostDiscover hostDiscover = (HttpHostDiscover)httpHostDiscoverClass.newInstance();
                hostDiscover.setHttpServiceHosts(this);
                hostDiscover.start();
                this.hostDiscover = hostDiscover;
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Start Http pool[" + this.getClientConfiguration().getBeanName() + "]" + " discovery service failed:", (Throwable)e);
                }
            }
        } else if (this.hostDiscover == null) {
            logger.info("Discover Http pool[" + this.getClientConfiguration().getBeanName() + "]" + " is disabled,to enabled set http.discoverService in configfile.");
        } else {
            this.hostDiscover.setHttpServiceHosts(this);
            this.hostDiscover.start();
        }
    }

    public void setHealth(String health) {
        this.httpServiceHostsConfig.setHealth(health);
    }

    public void setDiscoverService(String discoverService) {
        this.httpServiceHostsConfig.setDiscoverService(discoverService);
    }

    public void toString(StringBuilder log) {
        this.httpServiceHostsConfig.toString(log, this.exceptionWare, this.hostDiscover);
    }

    public void setHosts(String hosts) {
        this.httpServiceHostsConfig.setHosts(hosts);
    }

    public void addAddresses(List<HttpAddress> address) {
        this.serversList.addAddresses(address);
        if (this.healthCheck != null) {
            this.healthCheck.checkNewAddresses(address);
        }
        for (HttpAddress host : address) {
            this.addressMap.put(host.getAddress(), host);
        }
        if (logger.isInfoEnabled()) {
            StringBuilder info = new StringBuilder();
            info.append("Http pool[").append(this.getClientConfiguration().getBeanName()).append("]").append(" All live Http Servers:");
            Iterator<Map.Entry<String, HttpAddress>> iterator = this.addressMap.entrySet().iterator();
            boolean firsted = true;
            while (iterator.hasNext()) {
                Map.Entry<String, HttpAddress> esAddressEntry = iterator.next();
                String host = esAddressEntry.getValue().getOriginAddress();
                if (firsted) {
                    info.append(host);
                    firsted = false;
                    continue;
                }
                info.append(",").append(host);
            }
            logger.info(info.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void routingGroup(boolean changed, String newCurrentRounte) {
        if (this.routing == null || this.routing.equals("")) {
            return;
        }
        if (!changed) {
            if (newCurrentRounte == null) {
                this.routingFilter = new RoutingFilter(this, this.addressList, this.routing);
            } else {
                RoutingFilter routingFilter = new RoutingFilter(this, this.addressList, newCurrentRounte);
                this.routingFilterWriteLock.lock();
                try {
                    this.routing = newCurrentRounte;
                    this.routingFilter = routingFilter;
                }
                finally {
                    this.routingFilterWriteLock.unlock();
                }
            }
        } else {
            RoutingFilter temp = new RoutingFilter(this, this.addressList, newCurrentRounte == null ? this.routing : newCurrentRounte);
            this.routingFilterWriteLock.lock();
            try {
                this.routingFilter = temp;
                if (newCurrentRounte != null) {
                    this.routing = newCurrentRounte;
                }
            }
            finally {
                this.routingFilterWriteLock.unlock();
            }
        }
    }

    public void handleRemoved(List<HttpHost> hosts) {
        boolean hasHosts = true;
        if (hosts == null || hosts.size() == 0) {
            hasHosts = false;
        }
        for (Map.Entry<String, HttpAddress> esAddressEntry : this.addressMap.entrySet()) {
            String host = esAddressEntry.getKey();
            HttpAddress address = esAddressEntry.getValue();
            if (hasHosts) {
                boolean exist = false;
                for (HttpHost httpHost : hosts) {
                    if (!httpHost.getHostAddress().equals(host)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                address.setStatus(2);
                if (!logger.isInfoEnabled()) continue;
                logger.info("Http pool[" + this.getClientConfiguration().getBeanName() + "]" + " Http Node[" + address.toString() + "] is down and removed.");
                continue;
            }
            address.setStatus(2);
            if (!logger.isInfoEnabled()) continue;
            logger.info("Http pool[" + this.getClientConfiguration().getBeanName() + "]" + " Http Node[" + address.toString() + "] is down and removed.");
        }
    }

    private boolean compareAndSetRouting(HttpAddress address, HttpHost httpHost) {
        String old = address.getRouting();
        String routing = httpHost.getRouting();
        address.setOriginAddress(httpHost.getOrigineAddress());
        address.setRouting(routing);
        if (old == null || old.equals("")) {
            return routing != null && !routing.equals("");
        }
        if (routing == null || routing.equals("")) {
            return true;
        }
        return !old.equals(routing);
    }

    public boolean recoverRemovedNodes(List<HttpHost> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return false;
        }
        boolean result = false;
        for (HttpHost httpHost : hosts) {
            HttpAddress address = this.addressMap.get(httpHost.getHostAddress());
            if (address == null) continue;
            address.setAttributes(httpHost.getAttributes());
            if (!result) {
                result = this.compareAndSetRouting(address, httpHost);
            } else {
                this.compareAndSetRouting(address, httpHost);
            }
            if (address.getStatus() != 2) continue;
            address.onlySetStatus(0);
            if (!logger.isInfoEnabled()) continue;
            logger.info("Recover Removed Node [" + address.toString() + "] to Http pool[" + this.getClientConfiguration().getBeanName() + "] clusters addresses list.");
        }
        return result;
    }

    public boolean containAddress(HttpAddress address) {
        return this.addressMap.containsKey(address.getAddress());
    }

    public void setHealthCheckInterval(long healthCheckInterval) {
        this.httpServiceHostsConfig.setHealthCheckInterval(healthCheckInterval);
    }

    public long getDiscoverServiceInterval() {
        return this.httpServiceHostsConfig.getDiscoverServiceInterval();
    }

    public void setDiscoverServiceInterval(long discoverServiceInterval) {
        this.httpServiceHostsConfig.setDiscoverServiceInterval(discoverServiceInterval);
    }

    public Boolean getHandleNullOrEmptyHostsByDiscovery() {
        return this.httpServiceHostsConfig.getHandleNullOrEmptyHostsByDiscovery();
    }

    public void setHandleNullOrEmptyHostsByDiscovery(Boolean handleNullOrEmptyHostsByDiscovery) {
        this.httpServiceHostsConfig.setHandleNullOrEmptyHostsByDiscovery(handleNullOrEmptyHostsByDiscovery);
    }

    public void setExceptionWare(String exceptionWare) {
        this.httpServiceHostsConfig.setExceptionWare(exceptionWare);
    }

    public ExceptionWare getExceptionWare() {
        return this.exceptionWare;
    }

    public void setExceptionWareBean(ExceptionWare exceptionWareBean) {
        this.exceptionWare = exceptionWareBean;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public HttpHostDiscover getHostDiscover() {
        return this.hostDiscover;
    }

    public void setHostDiscover(HttpHostDiscover hostDiscover) {
        this.hostDiscover = hostDiscover;
    }

    public String getRouting() {
        return this.routing;
    }

    public void setRouting(String routing) {
        this.routing = routing;
        this.hasRouting = this.routing != null && !this.routing.equals("");
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.hostDiscover != null) {
            this.hostDiscover.stopCheck();
            this.hostDiscover = null;
        }
        if (this.healthCheck != null) {
            this.healthCheck.stopCheck();
            this.healthCheck = null;
        }
    }
}

