/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.ConfigParser;
import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.ValueObjectUtil;
import com.frameworkset.velocity.BBossVelocityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.frameworkset.soa.BBossStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class PoolManConfiguration {
    private static Logger log = LoggerFactory.getLogger(PoolManConfiguration.class);
    private String configFile;
    private ConfigParser handler;
    private ArrayList datasources;
    private ArrayList genericObjects;
    private static String sqlMappingDir;
    private boolean useJMX;
    public static boolean needtableinfo;
    public static String jndi_principal;
    public static String jndi_credentials;
    private String[] filterdbname;
    private String dbnamespace;
    public static String pooltemplates;
    public Map<String, String> adaptors;
    private static Object lock;

    public static String getSqlMappingDir() {
        return sqlMappingDir;
    }

    public static void setSqlMappingDir(String sqlMappingDir) {
        PoolManConfiguration.sqlMappingDir = sqlMappingDir;
    }

    public PoolManConfiguration(String configFile, String dbname) {
        String[] stringArray;
        if (dbname == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = dbname;
        }
        this(configFile, null, stringArray);
    }

    public PoolManConfiguration(String configFile, String dbnamespace, String[] dbnames) {
        this.useJMX = false;
        this.filterdbname = null;
        this.adaptors = new HashMap<String, String>();
        this.configFile = configFile;
        this.datasources = new ArrayList();
        this.genericObjects = new ArrayList();
        this.filterdbname = dbnames;
        this.dbnamespace = dbnamespace;
    }

    public PoolManConfiguration(String configFile) {
        this(configFile, null);
    }

    public boolean isUsingJMX() {
        return this.handler.isManagementJMX();
    }

    public void loadConfiguration(Map context) throws Exception {
        try {
            this.parseXML(context);
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            System.out.println("\n** ERROR: Unable to find XML file " + this.configFile + ": " + ne);
        }
        catch (Exception e) {
            System.out.println("\n** ERROR: Unable to parse XML file " + this.configFile + ": " + e);
        }
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            BBossStringWriter writer = new BBossStringWriter(builder);
            writer.write("adaptors:\r\n");
            SimpleStringUtil.object2json(this.adaptors, (Writer)writer);
            writer.write("\r\ndatasources:\r\n");
            SimpleStringUtil.object2json((Object)this.datasources, (Writer)writer);
            writer.write("\r\nenericObjects:\r\n");
            SimpleStringUtil.object2json((Object)this.genericObjects, (Writer)writer);
            writer.flush();
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public ArrayList getDataSources() {
        return this.datasources;
    }

    public ArrayList getGenericPools() {
        return this.genericObjects;
    }

    public Properties getAdminProperties() {
        return this.handler.getAdminProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initpooltemplates() {
        if (pooltemplates == null) {
            Object object = lock;
            synchronized (object) {
                if (pooltemplates == null) {
                    InputStream reader = null;
                    ByteArrayOutputStream swriter = null;
                    OutputStream temp = null;
                    try {
                        reader = ValueObjectUtil.getInputStreamFromFile((String)"poolman_template.xml");
                        swriter = new ByteArrayOutputStream();
                        temp = new BufferedOutputStream(swriter);
                        int len = 0;
                        byte[] buffer = new byte[1024];
                        while ((len = reader.read(buffer)) > 0) {
                            temp.write(buffer, 0, len);
                        }
                        temp.flush();
                        pooltemplates = swriter.toString("UTF-8");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (swriter != null) {
                            try {
                                swriter.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (temp != null) {
                            try {
                                temp.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXML(Map context) throws Exception {
        if (!this.configFile.equals("poolman_template.xml")) {
            URL confURL = PoolManConfiguration.class.getClassLoader().getResource(this.configFile);
            if (confURL == null) {
                PoolManConfiguration.class.getClassLoader().getResource("/" + this.configFile);
            }
            if (confURL == null) {
                PoolManConfiguration.getTCL().getResource(this.configFile);
            }
            if (confURL == null) {
                PoolManConfiguration.getTCL().getResource("/" + this.configFile);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource(this.configFile);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource("/" + this.configFile);
            }
            String url = "";
            if (confURL == null) {
                url = System.getProperty("user.dir");
                url = url + "/" + this.configFile;
                log.debug("Pool Config file:" + System.getProperty("user.dir") + "/" + this.configFile);
            } else {
                url = confURL.toString();
            }
            this.handler = new ConfigParser(url, this.dbnamespace, this.filterdbname);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(url, (DefaultHandler)this.handler);
            this.adaptors = this.handler.getAdaptors();
            if (this.handler.getSqlMappingDir() != null) {
                sqlMappingDir = this.handler.getSqlMappingDir();
            }
            this.datasources = this.handler.getDataSourceProperties();
            this.genericObjects = this.handler.getGenericProperties();
        } else {
            PoolManConfiguration.initpooltemplates();
            String poolconfig = BBossVelocityUtil.evaluate((Map)context, (String)"", (String)pooltemplates);
            InputStream in = null;
            ByteArrayInputStream sr = null;
            try {
                this.handler = new ConfigParser("poolman_template.xml", this.dbnamespace, this.filterdbname);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                sr = new ByteArrayInputStream(poolconfig.getBytes());
                in = new BufferedInputStream(sr);
                parser.parse(in, (DefaultHandler)this.handler);
                this.adaptors = this.handler.getAdaptors();
                if (this.handler.getSqlMappingDir() != null) {
                    sqlMappingDir = this.handler.getSqlMappingDir();
                }
                this.datasources = this.handler.getDataSourceProperties();
                this.genericObjects = this.handler.getGenericProperties();
            }
            finally {
                if (sr != null) {
                    try {
                        sr.close();
                    }
                    catch (Exception exception) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
    }

    private ArrayList parseProperties(String propsfilename) throws Exception {
        HashMap<String, Properties> datasources = new HashMap<String, Properties>();
        this.getClass().getClassLoader().getParent();
        ClassLoader.getSystemClassLoader().getResource(null);
        InputStream is = null;
        Properties p = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsfilename);
            p = new Properties();
            p.load(is);
        }
        catch (Exception e) {
            if (propsfilename.equals("poolman.props")) {
                try {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream("pool.props");
                    p = new Properties();
                    p.load(is);
                }
                catch (Exception e2) {
                    throw new Exception("Unable to find and read a valid poolman.xml config file. Please ensure that 'poolman.xml' is in a directory that is in your CLASSPATH.\n");
                }
                System.out.println("\nPLEASE NOTE: You should replace the pool.props file with a valid poolman.xml file\n");
            }
            throw new Exception("ERROR: Unable to find and read a valid PoolMan properties file.\nPlease ensure that poolman.xml or at least " + propsfilename + " is in a directory that is in your CLASSPATH.\n");
        }
        Properties theseProps = null;
        String entrySetNumber = null;
        Enumeration<Object> enum_ = p.keys();
        while (enum_.hasMoreElements()) {
            String key;
            String adjustedKey = key = (String)enum_.nextElement();
            if (key.indexOf("_") != -1) {
                StringBuilder sb = new StringBuilder(key.substring(0, key.indexOf("_")));
                sb.append(key.substring(key.indexOf("_") + 1, key.length()));
                adjustedKey = sb.toString();
                if (!adjustedKey.toLowerCase().equals("dbname") && adjustedKey.startsWith("db")) {
                    adjustedKey = adjustedKey.substring(2, adjustedKey.length());
                }
            }
            if (adjustedKey.toLowerCase().startsWith("cacherefresh")) {
                adjustedKey = "cacherefreshinterval" + adjustedKey.substring(12, adjustedKey.length());
            }
            try {
                entrySetNumber = key.substring(key.indexOf(46) + 1, key.length());
            }
            catch (StringIndexOutOfBoundsException sbe) {
                throw new Exception("Unnumbered property in poolman.props: " + key);
            }
            theseProps = datasources.containsKey(entrySetNumber) ? (Properties)datasources.get(entrySetNumber) : new Properties();
            theseProps.setProperty(adjustedKey.substring(0, adjustedKey.indexOf(46)), p.getProperty(key));
            datasources.put(entrySetNumber, theseProps);
        }
        ArrayList<Properties> finalDataSourceList = new ArrayList<Properties>();
        Iterator iter = datasources.keySet().iterator();
        while (iter.hasNext()) {
            Properties testp = (Properties)datasources.get(iter.next());
            finalDataSourceList.add(testp);
        }
        return finalDataSourceList;
    }

    public Map<String, String> getAdaptors() {
        return this.adaptors;
    }

    public void setAdaptors(Map<String, String> adaptors) {
        this.adaptors = adaptors;
    }

    public boolean isNeedtableinfo() {
        return needtableinfo;
    }

    public void setNeedtableinfo(boolean needtableinfo) {
        PoolManConfiguration.needtableinfo = needtableinfo;
    }

    static {
        needtableinfo = false;
        jndi_principal = null;
        jndi_credentials = null;
        lock = new Object();
    }
}

