/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.util;

import bboss.org.apache.velocity.runtime.resource.Resource;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.util.VariableHandler;
import com.frameworkset.velocity.BBossVelocityUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.cache.EdenConcurrentCache;
import org.frameworkset.cache.MissingStaticCache;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLTemplate;
import org.frameworkset.persitent.util.SQLUtil;
import org.frameworkset.spi.BaseApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GloableSQLUtil
extends SQLUtil {
    private static final Logger logger = LoggerFactory.getLogger(GloableSQLUtil.class);
    protected EdenConcurrentCache<String, SQLInfo> tplEdenConcurrentCache;
    protected MissingStaticCache<String, SQLInfo> tplMissingStaticCache;
    protected int maxGloableTemplateCacheSize;
    private Lock tplCacheLock = new ReentrantLock();

    GloableSQLUtil(int gloableResultMetaCacheSize, int maxGloableTemplateCacheSize, int globalKeySqlStructionCacheSize, boolean alwaysCache) {
        super(gloableResultMetaCacheSize, globalKeySqlStructionCacheSize, alwaysCache);
        this.maxGloableTemplateCacheSize = maxGloableTemplateCacheSize;
        if (alwaysCache) {
            this.tplEdenConcurrentCache = new EdenConcurrentCache(maxGloableTemplateCacheSize);
        } else {
            this.tplMissingStaticCache = new MissingStaticCache(maxGloableTemplateCacheSize);
        }
    }

    @Override
    public VariableHandler.SQLStruction getSQLStruction(SQLInfo sqlinfo, String newsql) {
        return super.getSQLStruction(sqlinfo, newsql);
    }

    @Override
    public VariableHandler.SQLStruction getTotalsizeSQLStruction(SQLInfo totalsizesqlinfo, String totalsizesql) {
        return super.getTotalsizeSQLStruction(totalsizesqlinfo, totalsizesql);
    }

    @Override
    public SQLInfo getSQLInfo(String dbname, String sql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSQL(String dbname, String sql) {
        return sql;
    }

    @Override
    public String getSQL(String dbname, String sql, Map variablevalues) {
        throw new UnsupportedOperationException();
    }

    public String getSQL(String sql, boolean istpl, boolean multiparser, Map variablevalues) {
        SQLInfo sqlinfo = this.getSQLInfo(sql, istpl, multiparser);
        String newsql = null;
        newsql = GloableSQLUtil._getSQL(sqlinfo, variablevalues);
        return newsql;
    }

    @Override
    public String[] getPropertyKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLInfo getSQLInfo(String sql) {
        return this.getSQLInfo(sql, false, false);
    }

    public SQLInfo getSQLInfo(String sql, boolean istpl, boolean multiparser) {
        if (!istpl) {
            SQLInfo sqlinfo = new SQLInfo(sql, sql, istpl, multiparser, true);
            sqlinfo.setSqlutil(this);
            return sqlinfo;
        }
        if (this.alwaysCache) {
            return this.getAwaysCacheSQLInfo(sql, istpl, multiparser);
        }
        return this.getMissingCacheSQLInfo(sql, istpl, multiparser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLInfo getAwaysCacheSQLInfo(String sql, boolean istpl, boolean multiparser) {
        boolean outOfSize = false;
        SQLInfo sqlinfo = (SQLInfo)this.tplEdenConcurrentCache.get((Object)sql);
        if (sqlinfo == null) {
            try {
                this.tplCacheLock.lock();
                sqlinfo = (SQLInfo)this.tplEdenConcurrentCache.get((Object)sql);
                if (sqlinfo != null) {
                    SQLInfo sQLInfo = sqlinfo;
                    return sQLInfo;
                }
                sqlinfo = this.buildSQLInfo(sql, istpl, multiparser);
                outOfSize = this.tplEdenConcurrentCache.put((Object)sql, (Object)sqlinfo);
            }
            finally {
                this.tplCacheLock.unlock();
            }
            if (outOfSize && logger.isWarnEnabled()) {
                this.logWarn(sql, this.tplEdenConcurrentCache.getMaxSize());
            }
        }
        return sqlinfo;
    }

    private SQLInfo buildSQLInfo(String sql, boolean istpl, boolean multiparser) {
        SQLInfo sqlinfo = new SQLInfo(sql, sql, istpl, multiparser, true);
        sqlinfo.setSqlutil(this);
        SQLTemplate sqltpl = new SQLTemplate(sqlinfo);
        sqlinfo.setSqltpl(sqltpl);
        BBossVelocityUtil.initDBTemplate((Resource)sqltpl);
        sqltpl.process();
        return sqlinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLInfo getMissingCacheSQLInfo(String sql, boolean istpl, boolean multiparser) {
        if (this.tplMissingStaticCache.stopCache()) {
            this.logWarn(sql, this.tplMissingStaticCache.getMissesMax());
            return this.buildSQLInfo(sql, istpl, multiparser);
        }
        SQLInfo sqlinfo = (SQLInfo)this.tplMissingStaticCache.get((Object)sql);
        if (sqlinfo == null) {
            try {
                this.tplCacheLock.lock();
                sqlinfo = (SQLInfo)this.tplMissingStaticCache.get((Object)sql);
                if (sqlinfo != null) {
                    SQLInfo sQLInfo = sqlinfo;
                    return sQLInfo;
                }
                this.tplMissingStaticCache.increamentMissing();
                sqlinfo = this.buildSQLInfo(sql, istpl, multiparser);
                if (!this.tplMissingStaticCache.stopCache()) {
                    this.tplMissingStaticCache.put((Object)sql, (Object)sqlinfo);
                } else if (logger.isWarnEnabled()) {
                    this.logWarn(sql, this.tplMissingStaticCache.getMissesMax());
                }
            }
            finally {
                this.tplCacheLock.unlock();
            }
        }
        return sqlinfo;
    }

    private void logWarn(String sql, int maxSize) {
        StringBuilder info = new StringBuilder();
        info.append("\r\n**********************************************************************\r\n").append("*********************************\u8b66\u544a*********************************\r\n").append("**********************************************************************\r\n").append("\u8c03\u7528GloableSQLUtil getSQLInfo \u65b9\u6cd5\u4ecetplEdenConcurrentCache\u83b7\u53d6\u4ee3\u7801\u4e2d\u786c\u7f16\u7801\u7684[").append(sql).append("] \u6a21\u677f\u4fe1\u606f\u65f6\uff0c\u68c0\u6d4b\u5230\u7f13\u51b2\u533a\u8bb0\u5f55\u6570\u8d85\u51facache\u5141\u8bb8\u7684\u6700\u5927cache size:").append(maxSize).append(",\r\n\u5bfc\u81f4\u544a\u8b66\u539f\u56e0\u5206\u6790:\r\n\u672c\u6761sql\u6216\u8005\u5176\u4ed6sql\u8bed\u53e5\u76f4\u63a5\u786c\u7f16\u7801\u5728\u4ee3\u7801\u4e2d;").append("\r\n\u672c\u6761sql\u6216\u8005\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570;").append("\r\n\u672c\u6761sql\u6216\u8005\u5176\u4ed6sql\u8bed\u53e5\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u5e76\u4e14$var\u7684\u503c\u4e0d\u65ad\u53d8\u5316;").append("\r\n\u4f18\u5316\u5efa\u8bae\uff1a\r\n\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u4e0d\u65ad\u53d8\u5316\u7684\u503c\u53c2\u6570\u8f6c\u5316\u4e3a\u7ed1\u5b9a\u53d8\u91cf\u6216\u8005#[variable]\u53d8\u91cf\uff0c\u6216\u5c06sql\u4e2d\u53ef\u80fd\u5b58\u5728\u7684$var\u6a21\u5f0f\u7684\u53d8\u91cf\u8f6c\u6362\u4e3a#[varibale]\u6a21\u5f0f\u7684\u53d8\u91cf\uff0c\u5e76\u91c7\u7528\u914d\u7f6e\u6587\u4ef6\u6765\u7ba1\u7406sql\u8bed\u53e5\uff0c\u4ee5\u63d0\u5347\u7cfb\u7edf\u6027\u80fd!").append("\n\r**********************************************************************").append("\n\r**********************************************************************");
        logger.warn(info.toString());
    }

    @Override
    public String getSQL(String sql) {
        return sql;
    }

    @Override
    public PoolManResultSetMetaData getPoolManResultSetMetaData(DB db, String dbname, String sqlkey, ResultSetMetaData rsmetadata) throws SQLException {
        return super.getPoolManResultSetMetaData(db, dbname, sqlkey, rsmetadata);
    }

    @Override
    public String getSQLFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String evaluateSQL(String name, String sql, Map variablevalues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDBName(String sqlname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map getMapSQLs(String sqlname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map getMapSQLs(String dbname, String sqlname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getListSQLs(String sqlname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getListSQLs(String dbname, String sqlname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set getSetSQLs(String sqlname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set getSetSQLs(String dbname, String sqlname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BaseApplicationContext getSqlcontext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getRefresh_interval() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _destroy() {
        if (this.alwaysCache) {
            this.tplEdenConcurrentCache.clear();
            this.tplEdenConcurrentCache = null;
        } else {
            this.tplMissingStaticCache.clear();
            this.tplMissingStaticCache = null;
        }
        this.alwaysCache = false;
        super._destroy();
    }

    @Override
    protected void reinit() {
        super.reinit();
        if (this.alwaysCache) {
            this.tplEdenConcurrentCache = new EdenConcurrentCache(this.maxGloableTemplateCacheSize);
        } else {
            this.tplMissingStaticCache = new MissingStaticCache(this.maxGloableTemplateCacheSize);
        }
    }

    @Override
    public Map<String, SQLUtil.SQLRef> getSQLRefers() {
        return null;
    }

    @Override
    public boolean hasrefs() {
        return false;
    }

    @Override
    public String getPlainSQL(String dbname, String sqlname) {
        return sqlname;
    }

    @Override
    public String getSQL(String sqlname, Map variablevalues) {
        return GloableSQLUtil._getSQL(this.getSQLInfo(sqlname, true, false), variablevalues);
    }

    @Override
    public boolean fromConfig() {
        return false;
    }
}

