/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.management.LocalPoolDeployer;
import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.common.poolman.sql.PoolMan;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.adapter.DBFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManBootstrap {
    private static Logger log = LoggerFactory.getLogger(PoolManBootstrap.class);
    private String configFile = "poolman.xml";
    private static Map<String, Boolean> startedFile = new HashMap<String, Boolean>();

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            PoolManBootstrap inc = new PoolManBootstrap();
            inc.start();
        } else if (args.length == 1) {
            new PoolManBootstrap(args[0]).start();
        } else {
            System.out.println("SYNTAX: java -Djava.security.policy=[your policy file] com.frameworkset.common.poolman.management.PoolManBootstrap [optional: config file name]");
            System.exit(1);
        }
    }

    public PoolManBootstrap() {
        log.debug("construct poolmanbootstrap");
    }

    public PoolManBootstrap(String configFile) {
        this.configFile = configFile;
    }

    public void reStart(String configFile) throws Exception {
    }

    public void start() {
        try {
            this.start(this.configFile);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void startFromTemplte(Map<String, Object> values) {
        LocalPoolDeployer deployer;
        PoolManConfiguration config;
        block9: {
            if (log.isDebugEnabled()) {
                log.debug("PoolManBootstrap(configFile): {}", (Object)"poolman_template.xml");
            }
            config = new PoolManConfiguration("poolman_template.xml", null);
            try {
                config.loadConfiguration(values);
            }
            catch (Exception ex) {
                log.error("Start(configFile) loadConfiguration error: " + ex.getMessage(), (Throwable)ex);
            }
            deployer = null;
            DBFactory.addDBAdaptors(config.getAdaptors());
            deployer = new LocalPoolDeployer();
            try {
                deployer.deployConfiguration(config, (Map<String, String>)null);
            }
            catch (Exception ex2) {
                if (!log.isErrorEnabled()) break block9;
                log.error("LocalPoolDeployer deployConfiguration error: {},config: \r\n{}", new Object[]{ex2.getMessage(), config.toString(), ex2});
            }
        }
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    BaseTableManager.initTableInfo((String)values.get("dbname"));
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
            }
        }
        PoolMan.STARTED = true;
    }

    public void start(String configFile) {
        log.debug("PoolManBootstrap(configFile): " + configFile);
        PoolManConfiguration config = new PoolManConfiguration(configFile, null);
        try {
            config.loadConfiguration(null);
        }
        catch (Exception ex) {
            log.error("Start(configFile) loadConfiguration error: {},config: \r\n{}", new Object[]{ex.getMessage(), config.toString(), ex});
        }
        LocalPoolDeployer deployer = null;
        DBFactory.addDBAdaptors(config.getAdaptors());
        deployer = new LocalPoolDeployer();
        try {
            deployer.deployConfiguration(config);
        }
        catch (Exception ex2) {
            log.error("LocalPoolDeployer deployConfiguration error: {},config: \r\n{}", new Object[]{ex2.getMessage(), config.toString(), ex2});
        }
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    ((BaseTableManager)deployer).initTableInfo();
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
            }
        }
        PoolMan.STARTED = true;
    }

    public static void startDBSFromConf(String configFile, String dbnamespace, String[] startdbnames) {
        log.debug("PoolManBootstrap(configFile): " + configFile);
        PoolManConfiguration config = new PoolManConfiguration(configFile, dbnamespace, startdbnames);
        try {
            config.loadConfiguration(null);
        }
        catch (Exception ex) {
            log.error("Start(configFile) loadConfiguration error: {},config: \r\n{}", new Object[]{ex.getMessage(), config.toString(), ex});
        }
        LocalPoolDeployer deployer = null;
        DBFactory.addDBAdaptors(config.getAdaptors());
        deployer = new LocalPoolDeployer();
        try {
            deployer.deployConfiguration(config);
        }
        catch (Exception ex2) {
            log.error("LocalPoolDeployer deployConfiguration error: {},config: \r\n{}", new Object[]{ex2.getMessage(), config.toString(), ex2});
        }
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    ((BaseTableManager)deployer).initTableInfo();
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
            }
        }
        PoolMan.STARTED = true;
    }

    public void startDB(String dbname) throws Exception {
        log.debug("PoolManBootstrap(configFile): " + this.configFile);
        if (dbname == null || dbname.equals("")) {
            dbname = SQLUtil.getSQLManager().getDefaultDBName();
        }
        PoolManConfiguration config = new PoolManConfiguration(this.configFile, dbname);
        config.loadConfiguration(null);
        LocalPoolDeployer deployer = new LocalPoolDeployer();
        try {
            deployer.deployConfiguration(config, dbname);
        }
        catch (Exception ex2) {
            log.error("LocalPoolDeployer deployConfiguration error: {},config: \r\n{}", new Object[]{ex2.getMessage(), config.toString(), ex2});
            throw ex2;
        }
        if (deployer != null) {
            try {
                if (config.isNeedtableinfo()) {
                    BaseTableManager.initTableInfo(dbname);
                }
            }
            catch (Exception e) {
                log.error("InitTableInfo: " + e.getMessage(), (Throwable)e);
                log.debug("Initial tableinfo failed!");
                throw e;
            }
        }
    }

    public void stop() {
    }
}

