/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.sql;

import com.frameworkset.common.poolman.sql.PrimaryKeyCacheManager;
import com.frameworkset.common.poolman.util.DatasourceUtil;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.orm.transaction.TXDataSource;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManDataSource
implements DataSource,
ConnectionPoolDataSource,
Referenceable,
ObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(PoolManDataSource.class);
    private String poolName;
    private String jndiName;
    private PrintWriter logger;
    private int loginTimeout;
    private DataSource datasource;

    public PoolManDataSource() {
    }

    public PoolManDataSource(String poolName, String jndiName) {
        this();
        this.poolName = poolName;
        this.jndiName = jndiName;
    }

    public PoolManDataSource(DataSource datasource, String poolName, String jndiName) {
        this();
        this.poolName = poolName;
        this.jndiName = jndiName;
        this.datasource = datasource;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public DataSource getInnerDataSource() {
        DataSource datasource_;
        block5: {
            datasource_ = this.datasource;
            if (datasource_ == null) {
                return null;
            }
            while (true) {
                DataSource temp_;
                if (datasource_ instanceof PoolManDataSource) {
                    temp_ = (PoolManDataSource)datasource_;
                    if (((PoolManDataSource)temp_).getInnerDataSource() == null) {
                        return datasource_;
                    }
                    datasource_ = ((PoolManDataSource)temp_).getInnerDataSource();
                    if (datasource_ != temp_) continue;
                    return datasource_;
                }
                if (!(datasource_ instanceof TXDataSource)) break block5;
                temp_ = (TXDataSource)datasource_;
                if (((TXDataSource)temp_).getSRCDataSource() == null) {
                    return datasource_;
                }
                datasource_ = ((TXDataSource)temp_).getSRCDataSource();
                if (datasource_ == temp_) break;
            }
            return datasource_;
        }
        return datasource_;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.datasource == null) {
            return SQLManager.getInstance().requestConnection(this.poolName);
        }
        return this.datasource.getConnection();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        SQLManager.getInstance().checkCredentials(this.poolName, user, password);
        return this.getConnection();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return (PooledConnection)((Object)this.getConnection(user, password));
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logger = out;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public String toString() {
        return "PoolManDataSource:[JNDIName:" + this.jndiName + ",PoolName:" + this.poolName + "]";
    }

    @Override
    public Reference getReference() {
        Reference ref = new Reference("com.frameworkset.common.poolman.sql.PoolManDataSource", "com.frameworkset.common.poolman.sql.PoolManDataSource", null);
        ref.add(new StringRefAddr("dbname", this.poolName));
        ref.add(new StringRefAddr("jndiname", this.jndiName));
        return ref;
    }

    public Serializable getPrimaryKey(String tableName) throws SQLException {
        return this.getPrimaryKey(tableName, null);
    }

    public Serializable getPrimaryKey(String tableName, Connection con) throws SQLException {
        return PrimaryKeyCacheManager.getInstance().getPrimaryKeyCache(this.poolName).getIDTable(tableName.toLowerCase()).generateObjectKey(con).getPrimaryKey();
    }

    public void close() {
        DatasourceUtil.closeDS(this.datasource);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Object getObjectInstance(Object RefObj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        PoolManDataSource result = null;
        Reference ref = (Reference)RefObj;
        if (ref.getClassName().equals("com.frameworkset.common.poolman.sql.PoolManDataSource")) {
            PoolManDataSource pds;
            String poolname = (String)ref.get("dbname").getContent();
            String jndiname = (String)ref.get("jndiname").getContent();
            result = pds = new PoolManDataSource(poolname, jndiname);
        }
        return result;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.datasource.getParentLogger();
    }
}

