/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.platform;

import com.frameworkset.orm.engine.model.Domain;
import com.frameworkset.orm.engine.model.SchemaType;
import com.frameworkset.orm.platform.Platform;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class PlatformDefaultImpl
implements Platform {
    private Map schemaDomainMap;

    public PlatformDefaultImpl() {
        this.initialize();
    }

    private void initialize() {
        this.schemaDomainMap = new Hashtable(30);
        Iterator iter = SchemaType.iterator();
        while (iter.hasNext()) {
            SchemaType type = (SchemaType)iter.next();
            this.schemaDomainMap.put(type, new Domain(type));
        }
        this.schemaDomainMap.put(SchemaType.BOOLEANCHAR, new Domain(SchemaType.BOOLEANCHAR, "CHAR"));
        this.schemaDomainMap.put(SchemaType.BOOLEANINT, new Domain(SchemaType.BOOLEANINT, "INTEGER"));
    }

    protected void setSchemaDomainMapping(Domain domain) {
        this.schemaDomainMap.put(domain.getType(), domain);
    }

    @Override
    public int getMaxColumnNameLength() {
        return 64;
    }

    @Override
    public String getNativeIdMethod() {
        return "identity";
    }

    @Override
    public Domain getDomainForSchemaType(SchemaType jdbcType) {
        return (Domain)this.schemaDomainMap.get(jdbcType);
    }

    @Override
    public String getNullString(boolean notNull) {
        return notNull ? "NOT NULL" : "";
    }

    @Override
    public SchemaType getSchemaTypeFromSqlType(int sqltype, String typeName) {
        switch (sqltype) {
            case -7: {
                return SchemaType.BIT;
            }
            case -6: {
                return SchemaType.TINYINT;
            }
            case 5: {
                return SchemaType.SMALLINT;
            }
            case 4: {
                return SchemaType.INTEGER;
            }
            case -5: {
                return SchemaType.BIGINT;
            }
            case 6: {
                return SchemaType.FLOAT;
            }
            case 7: {
                return SchemaType.REAL;
            }
            case 8: {
                return SchemaType.DOUBLE;
            }
            case 2: {
                return SchemaType.NUMERIC;
            }
            case 3: {
                return SchemaType.DECIMAL;
            }
            case 1: {
                return SchemaType.CHAR;
            }
            case 12: {
                return SchemaType.VARCHAR;
            }
            case -1: {
                return SchemaType.LONGVARCHAR;
            }
            case 91: {
                return SchemaType.DATE;
            }
            case 92: {
                return SchemaType.TIME;
            }
            case 93: {
                return SchemaType.TIMESTAMP;
            }
            case -2: {
                return SchemaType.BINARY;
            }
            case -3: {
                return SchemaType.VARBINARY;
            }
            case -4: {
                return SchemaType.LONGVARBINARY;
            }
            case 0: {
                return SchemaType.NULL;
            }
            case 1111: {
                if (typeName != null) {
                    if (typeName.equals("NVARCHAR2")) {
                        return SchemaType.VARCHAR;
                    }
                    if (typeName.startsWith("TIMESTAMP")) {
                        return SchemaType.TIMESTAMP;
                    }
                }
                return SchemaType.OTHER;
            }
            case 2000: {
                return SchemaType.JAVA_OBJECT;
            }
            case 2001: {
                return SchemaType.DISTINCT;
            }
            case 2002: {
                return SchemaType.STRUCT;
            }
            case 2003: {
                return SchemaType.ARRAY;
            }
            case 2004: {
                return SchemaType.BLOB;
            }
            case 2005: {
                return SchemaType.CLOB;
            }
            case 2006: {
                return SchemaType.REF;
            }
            case 70: {
                return SchemaType.DATALINK;
            }
            case 16: {
                return SchemaType.BOOLEANCHAR;
            }
        }
        return SchemaType.DEFAULT;
    }

    @Override
    public String getAutoIncrement() {
        return "IDENTITY";
    }

    @Override
    public boolean hasScale(String sqlType) {
        return true;
    }

    @Override
    public boolean hasSize(String sqlType) {
        return true;
    }

    @Override
    public Domain getDomainForSchemaType(int jdbcType, String typeName) {
        return this.getDomainForSchemaType(this.getSchemaTypeFromSqlType(jdbcType, typeName));
    }

    @Override
    public boolean hasSize(int sqlType) {
        return false;
    }

    @Override
    public boolean hasScale(int sqlType) {
        return false;
    }

    @Override
    public String getDBTYPE() {
        return "";
    }
}

