/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.GetCUDResult;
import com.frameworkset.common.poolman.ListSQLParams;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.PagineOrderby;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.SQLInfoDBUtil;
import com.frameworkset.common.poolman.SQLParams;
import com.frameworkset.common.poolman.SetSQLParamException;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.FieldRowHandler;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.util.DBOptions;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.util.ListInfo;
import com.frameworkset.util.ValueObjectUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.frameworkset.persitent.util.SQLInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLInfoExecutor {
    private static Logger log = LoggerFactory.getLogger(SQLInfoExecutor.class);
    public static int DEFAULT_BATCHSIZE = -1;

    public static void addSQLParam(SQLParams sqlparams, String name, Object value, String type, String dataformat) throws SetSQLParamException {
        sqlparams.addSQLParam(name, value, type, dataformat);
    }

    public static void init(SQLParams sqlparams, SQLInfo statement, String pretoken, String endtoken, String action) {
        sqlparams.setOldsql(statement);
        if (action != null) {
            if (action.equals("insert")) {
                sqlparams.setAction(0);
            } else if (action.equals("delete")) {
                sqlparams.setAction(2);
            } else if (action.equals("update")) {
                sqlparams.setAction(1);
            }
        }
        sqlparams.setPretoken(pretoken);
        sqlparams.setEndtoken(endtoken);
    }

    public static void insertBeans(DBOptions dbOptions, String dbname, SQLInfo sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, 0, null);
    }

    public static void insertBeans(DBOptions dbOptions, String dbname, SQLInfo sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, 0, getCUDResult);
    }

    public static void execute(DBOptions dbOptions, String dbname, SQLInfo sql, List beans, boolean isBatchOptimize, int action) throws SQLException {
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, isBatchOptimize, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DBOptions dbOptions, String dbname, SQLInfo sql, List beans, boolean isBatchOptimize, int action, GetCUDResult getCUDResult) throws SQLException {
        block16: {
            Connection con = null;
            if (beans == null || beans.size() == 0) {
                return;
            }
            try {
                con = DBUtil.getConection(dbname);
                if (beans.size() < DEFAULT_BATCHSIZE || DEFAULT_BATCHSIZE == -1) {
                    List<SQLParams> batchsqlparams = SQLParams.convertBeansToSqlParams(beans, sql, dbname, action, con);
                    if (batchsqlparams == null) {
                        return;
                    }
                    PreparedDBUtil dbutil = new PreparedDBUtil();
                    dbutil.setBatchOptimize(isBatchOptimize);
                    dbutil.setPrepareDBName(dbname);
                    dbutil.addPreparedBatch(new ListSQLParams(batchsqlparams, sql));
                    dbutil.executePreparedBatch(dbOptions, con, getCUDResult);
                    break block16;
                }
                int start = 0;
                int totalsize = beans.size();
                int left = totalsize - start;
                int end = 0;
                int step = 0;
                do {
                    List<SQLParams> batchsqlparams;
                    if ((batchsqlparams = SQLParams.convertBeansToSqlParams(beans, sql, dbname, action, con, start, end = left >= DEFAULT_BATCHSIZE ? start + DEFAULT_BATCHSIZE : totalsize, step = left >= DEFAULT_BATCHSIZE ? DEFAULT_BATCHSIZE : left)) == null) {
                        break;
                    }
                    PreparedDBUtil dbutil = new PreparedDBUtil();
                    dbutil.setBatchOptimize(isBatchOptimize);
                    dbutil.setPrepareDBName(dbname);
                    dbutil.addPreparedBatch(new ListSQLParams(batchsqlparams, sql));
                    dbutil.executePreparedBatch(dbOptions, con, getCUDResult);
                } while ((left = totalsize - (start += DEFAULT_BATCHSIZE)) > 0);
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Object CUDexecute(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean, int action) throws SQLException {
        return SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, action, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object CUDexecute(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean, int action, boolean getCUDResult) throws SQLException {
        Connection con = null;
        try {
            SQLParams batchsqlparams;
            if (action == 0) {
                con = DBUtil.getConection(dbname);
            }
            if ((batchsqlparams = SQLParams.convertBeanToSqlParams(bean, sql, dbname, action, con)) == null) {
                Object var8_8 = null;
                return var8_8;
            }
            SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
            if (action == 0) {
                dbutil.preparedInsert(batchsqlparams, dbname, sql);
                Object object = dbutil.executePrepared(dbOptions, con, getCUDResult);
                return object;
            }
            if (action == 1) {
                dbutil.preparedUpdate(batchsqlparams, dbname, sql);
                Object object = dbutil.executePrepared(dbOptions, con, getCUDResult);
                return object;
            }
            if (action != 2) throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u64cd\u4f5c\uff1a" + action);
            dbutil.preparedDelete(batchsqlparams, dbname, sql);
            Object object = dbutil.executePrepared(dbOptions, con, getCUDResult);
            return object;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static <T> void executeBatch(DBOptions dbOptions, String dbname, SQLInfo sql, List<T> datas, int batchsize, BatchHandler<T> batchHandler) throws SQLException {
        if (datas == null || datas.size() == 0) {
            return;
        }
        StatementInfo stmtInfo = null;
        PreparedStatement statement = null;
        Object resources = null;
        Connection con_ = null;
        try {
            con_ = DBUtil.getConection(dbname);
            stmtInfo = new StatementInfo(dbname, null, false, con_, false);
            stmtInfo.init();
            JDBCPool pool = SQLManager.getInstance().getPool(dbname);
            boolean showsql = pool.getJDBCPoolMetadata().isShowsql();
            if (showsql && log.isInfoEnabled()) {
                log.info("Execute JDBC prepared batch statement:" + sql.getSql());
            }
            statement = stmtInfo.prepareStatement(sql.getSql());
            if (batchsize <= 1) {
                for (int i = 0; i < datas.size(); ++i) {
                    T param = datas.get(i);
                    batchHandler.handler(statement, param, i);
                    statement.addBatch();
                }
                statement.executeBatch();
            } else {
                int point = batchsize - 1;
                int count = 0;
                for (int i = 0; i < datas.size(); ++i) {
                    T param = datas.get(i);
                    batchHandler.handler(statement, param, i);
                    statement.addBatch();
                    if (count > 0 && count % point == 0) {
                        statement.executeBatch();
                        statement.clearBatch();
                        count = 0;
                        continue;
                    }
                    ++count;
                }
                if (count > 0) {
                    statement.executeBatch();
                }
            }
        }
        catch (BatchUpdateException error) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle(error);
            }
            throw error;
        }
        catch (Exception e) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new NestedSQLException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmtInfo != null) {
                    stmtInfo.dofinally();
                    stmtInfo = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (con_ != null) {
                    con_.close();
                    con_ = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void execute(DBOptions dbOptions, String dbname, SQLInfo sql, List beans, int action) throws SQLException {
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, false, action, null);
    }

    public static void execute(DBOptions dbOptions, String dbname, SQLInfo sql, List beans, int action, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, false, action, getCUDResult);
    }

    protected static Object execute(DBOptions dbOptions, String dbname, SQLInfo sql, int action, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        if (action == 0) {
            dbutil.preparedInsert(dbname, sql);
        } else if (action == 2) {
            dbutil.preparedDelete(dbname, sql);
        } else if (action == 1) {
            dbutil.preparedUpdate(dbname, sql);
        } else {
            dbutil.preparedUpdate(dbname, sql);
        }
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePrepared(dbOptions);
    }

    protected static void executeBatch(DBOptions dbOptions, String dbname, SQLInfo sql, int action, Object fields_) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        if (action == 0) {
            dbutil.preparedInsert(dbname, sql);
        } else if (action == 2) {
            dbutil.preparedDelete(dbname, sql);
        } else if (action == 1) {
            dbutil.preparedUpdate(dbname, sql);
        } else {
            dbutil.preparedUpdate(dbname, sql);
        }
        if (fields_ != null) {
            short[] fields;
            Class<?> componetType = fields_.getClass().getComponentType();
            if (componetType == Integer.TYPE) {
                int[] fields2 = (int[])fields_;
                if (fields2 != null && fields2.length > 0) {
                    for (int i = 0; i < fields2.length; ++i) {
                        int field = fields2[i];
                        dbutil.setInt(1, field);
                        dbutil.addPreparedBatch();
                    }
                }
            } else if (componetType == Long.TYPE) {
                long[] fields3 = (long[])fields_;
                if (fields3 != null && fields3.length > 0) {
                    for (int i = 0; i < fields3.length; ++i) {
                        long field = fields3[i];
                        dbutil.setLong(1, field);
                        dbutil.addPreparedBatch();
                    }
                }
            } else if (componetType == String.class) {
                String[] fields4 = (String[])fields_;
                if (fields4 != null && fields4.length > 0) {
                    for (int i = 0; i < fields4.length; ++i) {
                        String field = fields4[i];
                        dbutil.setString(1, field);
                        dbutil.addPreparedBatch();
                    }
                }
            } else if (componetType == Short.TYPE && (fields = (short[])fields_) != null && fields.length > 0) {
                for (int i = 0; i < fields.length; ++i) {
                    short field = fields[i];
                    dbutil.setShort(1, field);
                    dbutil.addPreparedBatch();
                }
            }
        }
        dbutil.executePreparedBatch(dbOptions);
    }

    public static Object update(DBOptions dbOptions, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbOptions, (String)null, sql, 1, fields);
    }

    public static Object delete(DBOptions dbOptions, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbOptions, (String)null, sql, 2, fields);
    }

    public static void deleteByKeys(DBOptions dbOptions, SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 2, fields);
    }

    public static void deleteByKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 2, fields);
    }

    public static void updateByKeys(DBOptions dbOptions, SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 1, fields);
    }

    public static void updateByKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, int ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 1, fields);
    }

    public static void deleteByLongKeys(DBOptions dbOptions, SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 2, fields);
    }

    public static void deleteByLongKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 2, fields);
    }

    public static void updateByLongKeys(DBOptions dbOptions, SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 1, fields);
    }

    public static void updateByLongKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, long ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 1, fields);
    }

    public static void deleteByKeys(DBOptions dbOptions, SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 2, fields);
    }

    public static void deleteByKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 2, fields);
    }

    public static void updateByKeys(DBOptions dbOptions, SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 1, fields);
    }

    public static void updateByKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, String ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 1, fields);
    }

    public static void deleteByShortKeys(DBOptions dbOptions, SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 2, fields);
    }

    public static void deleteByShortKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 2, fields);
    }

    public static void updateByShortKeys(DBOptions dbOptions, SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, null, sql, 1, fields);
    }

    public static void updateByShortKeysWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, short ... fields) throws SQLException {
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sql, 1, fields);
    }

    public static Object insert(DBOptions dbOptions, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbOptions, (String)null, sql, 0, fields);
    }

    public static Object updateWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbOptions, dbname, sql, 1, fields);
    }

    public static Object deleteWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbOptions, dbname, sql, 2, fields);
    }

    public static Object insertWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.execute(dbOptions, dbname, sql, 0, fields);
    }

    public static void updateBeans(DBOptions dbOptions, String dbname, SQLInfo sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, 1, null);
    }

    public static void updateBeans(DBOptions dbOptions, String dbname, SQLInfo sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, 1, GetCUDResult2);
    }

    public static void deleteBeans(DBOptions dbOptions, String dbname, SQLInfo sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, 2);
    }

    public static void deleteBeans(DBOptions dbOptions, String dbname, SQLInfo sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfoExecutor.execute(dbOptions, dbname, sql, beans, 2, GetCUDResult2);
    }

    public static void insertBean(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 0, false);
    }

    public static void insertBean(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        if (getCUDResult == null) {
            SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 0, false);
        } else {
            GetCUDResult getCUDResult_ = (GetCUDResult)SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 0, true);
            getCUDResult.setGetCUDResult(getCUDResult_);
        }
    }

    public static void updateBean(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 1, false);
    }

    public static void updateBean(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        if (getCUDResult != null) {
            GetCUDResult getCUDResult_ = (GetCUDResult)SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 1, true);
            getCUDResult.setGetCUDResult(getCUDResult_);
        } else {
            SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 1, false);
        }
    }

    public static void updateBean(DBOptions dbOptions, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.updateBean(dbOptions, null, sql, bean, getCUDResult);
    }

    public static void deleteBean(DBOptions dbOptions, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.deleteBean(dbOptions, null, sql, bean, getCUDResult);
    }

    public static void deleteBean(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 2, false);
    }

    public static void deleteBean(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        if (getCUDResult != null) {
            GetCUDResult getCUDResult_ = (GetCUDResult)SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 2, true);
            getCUDResult.setGetCUDResult(getCUDResult_);
        } else {
            SQLInfoExecutor.CUDexecute(dbOptions, dbname, sql, bean, 2, false);
        }
    }

    public static void insertBeans(DBOptions dbOptions, SQLInfo sql, List beans) throws SQLException {
        SQLInfoExecutor.insertBeans(dbOptions, null, sql, beans);
    }

    public static void insertBeans(DBOptions dbOptions, SQLInfo sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.insertBeans(dbOptions, null, sql, beans, getCUDResult);
    }

    public static void updateBeans(DBOptions dbOptions, SQLInfo sql, List beans) throws SQLException {
        SQLInfoExecutor.updateBeans(dbOptions, null, sql, beans);
    }

    public static void deleteBeans(DBOptions dbOptions, SQLInfo sql, List beans) throws SQLException {
        SQLInfoExecutor.deleteBeans(dbOptions, null, sql, beans);
    }

    public static void insertBean(DBOptions dbOptions, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.insertBean(dbOptions, (String)null, sql, bean);
    }

    public static void insertBean(DBOptions dbOptions, SQLInfo sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        SQLInfoExecutor.insertBean(dbOptions, null, sql, bean, getCUDResult);
    }

    public static void updateBean(DBOptions dbOptions, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.updateBean(dbOptions, (String)null, sql, bean);
    }

    public static void deleteBean(DBOptions dbOptions, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.deleteBean(dbOptions, (String)null, sql, bean);
    }

    public static <T> List<T> queryList(DBOptions dbOptions, Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListWithDBName(dbOptions, beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setMaxPageItems(pagesize);
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        return datas;
    }

    public static ListInfo moreListInfoWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsize(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize, totalsize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesql(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelectWithTotalsizesql(dbname, sql, offset, pagesize, totalsizesql);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfo(DBOptions dbOptions, Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName(dbOptions, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsize(DBOptions dbOptions, Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsize(dbOptions, beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesql(DBOptions dbOptions, Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesql(dbOptions, beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObject(DBOptions dbOptions, Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryObjectWithDBName(dbOptions, beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForList(dbOptions, beanType);
    }

    public static <T> T queryObjectWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForObject(dbOptions, beanType);
    }

    public static <T> List<T> queryListByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize, totalsize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelectWithTotalsizesql(dbname, sql, offset, pagesize, totalsizesql);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObjectByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryObjectWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForList(dbOptions, beanType, rowhandler);
    }

    public static <T> T queryObjectWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        return dbutil.executePreparedForObject(dbOptions, beanType, rowhandler);
    }

    public static void queryByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoExecutor.queryWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        dbutil.preparedSelect(dbname, sql, offset, pagesize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql, offset, pagesize, totalsize);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelectWithTotalsizesql(dbname, sql, offset, pagesize, totalsizesql);
        if (fields != null && fields.length > 0) {
            int length = fields.length;
            Object last = fields[length - 1];
            if (last instanceof PagineOrderby) {
                dbutil.setPagineOrderby(((PagineOrderby)last).getPagineOrderby());
                --length;
            }
            for (int i = 0; i < length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static void queryWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
    }

    public static <T> List<T> queryListBean(DBOptions dbOptions, Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListBeanWithDBName(dbOptions, beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, totalsize);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelectWithTotalsizesql(params, dbname, sql, offset, pagesize, totalsizesql);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.setMore(true);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBean(DBOptions dbOptions, Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBean(DBOptions dbOptions, Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBean(DBOptions dbOptions, Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, null, sql, offset, pagesize, -1L, bean);
    }

    public static String queryField(DBOptions dbOptions, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryFieldWithDBName(dbOptions, null, sql, fields);
    }

    public static String queryFieldBean(DBOptions dbOptions, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryFieldBeanWithDBName(dbOptions, null, sql, bean);
    }

    public static String queryFieldBeanWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        dbutil.executePrepared(dbOptions);
        if (dbutil.size() > 0) {
            return dbutil.getString(0, 0);
        }
        return null;
    }

    public static String queryFieldWithDBName(DBOptions dbOptions, String dbname, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        dbutil.executePrepared(dbOptions);
        if (dbutil.size() > 0) {
            return dbutil.getString(0, 0);
        }
        return null;
    }

    public static <T> T queryTField(DBOptions dbOptions, Class<T> beanType, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryTFieldWithDBName(dbOptions, (String)null, beanType, sql, fields);
    }

    public static <T> T queryTFieldBean(DBOptions dbOptions, Class<T> type, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryTFieldBeanWithDBName(dbOptions, null, type, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(DBOptions dbOptions, String dbname, Class<T> type, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryTFieldBeanWithDBName(dbOptions, dbname, type, null, sql, bean);
    }

    public static <T> T queryTFieldWithDBName(DBOptions dbOptions, String dbname, Class<T> type, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryTFieldWithDBName(dbOptions, dbname, type, (FieldRowHandler)null, sql, fields);
    }

    public static <T> T queryTField(DBOptions dbOptions, Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object ... fields) throws SQLException {
        return SQLInfoExecutor.queryTFieldWithDBName(dbOptions, (String)null, type, fieldRowHandler, sql, fields);
    }

    public static <T> T queryTFieldBean(DBOptions dbOptions, Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryTFieldBeanWithDBName(dbOptions, null, type, fieldRowHandler, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(DBOptions dbOptions, String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        if (fieldRowHandler == null) {
            dbutil.executePrepared();
            if (dbutil.size() > 0) {
                return (T)ValueObjectUtil.typeCast((Object)dbutil.getObject(0, 0), type);
            }
            return (T)ValueObjectUtil.getDefaultValue(type);
        }
        return dbutil.executePreparedForObject(dbOptions, type, fieldRowHandler);
    }

    public static <T> T queryTFieldWithDBName(DBOptions dbOptions, String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, SQLInfo sql, Object ... fields) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.preparedSelect(dbname, sql);
        if (fields != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                Object field = fields[i];
                dbutil.setObject(i + 1, field);
            }
        }
        if (fieldRowHandler == null) {
            dbutil.executePrepared();
            if (dbutil.size() > 0) {
                return (T)ValueObjectUtil.typeCast((Object)dbutil.getObject(0, 0), type);
            }
            return (T)ValueObjectUtil.getDefaultValue(type);
        }
        return dbutil.executePreparedForObject(dbOptions, type, fieldRowHandler);
    }

    public static <T> T queryObjectBean(DBOptions dbOptions, Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryObjectBeanWithDBName(dbOptions, beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForList(dbOptions, beanType);
    }

    public static <T> T queryObjectBeanWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForObject(dbOptions, beanType);
    }

    public static <T> List<T> queryListBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, totalsize);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.setMore(true);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelectWithTotalsizesql(params, dbname, sql, offset, pagesize, totalsizesql);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        ListInfo datas = new ListInfo();
        datas.setDatas(dbutil.executePreparedForList(dbOptions, beanType, rowhandler));
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, -1L, bean);
    }

    public static <T> T queryObjectBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, SQLInfo sql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryObjectBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForList(dbOptions, beanType, rowhandler);
    }

    public static <T> T queryObjectBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        return dbutil.executePreparedForObject(dbOptions, beanType, rowhandler);
    }

    public static void queryBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoExecutor.queryBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, totalsize);
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo moreListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        dbutil.setMore(true);
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setMore(true);
        datas.setResultSize(dbutil.size());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelectWithTotalsizesql(params, dbname, sql, offset, pagesize, totalsizesql);
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql, offset, pagesize, -1L);
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
        ListInfo datas = new ListInfo();
        datas.setTotalSize(dbutil.getLongTotalSize());
        datas.setMaxPageItems(pagesize);
        return datas;
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, SQLInfo totalsizesql, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, (String)null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, SQLInfo sql, long offset, int pagesize, Object bean) throws SQLException {
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, -1L, bean);
    }

    public static void queryBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, SQLInfo sql, Object bean) throws SQLException {
        SQLInfoDBUtil dbutil = new SQLInfoDBUtil();
        SQLParams params = SQLParams.convertBeanToSqlParams(bean, sql, dbname, 3, null);
        dbutil.preparedSelect(params, dbname, sql);
        dbutil.executePreparedWithRowHandler(dbOptions, rowhandler);
    }
}

