/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.model;

import com.frameworkset.orm.engine.EngineException;
import com.frameworkset.orm.engine.model.Column;
import com.frameworkset.orm.engine.model.Domain;
import com.frameworkset.orm.engine.model.ForeignKey;
import com.frameworkset.orm.engine.model.Table;
import com.frameworkset.orm.platform.Platform;
import com.frameworkset.orm.platform.PlatformFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.xml.sax.Attributes;

public class Database
implements Serializable {
    private String databaseType = null;
    private List tableList = new ArrayList();
    private Map domainMap = new HashMap();
    private String name;
    private String pkg;
    private String baseClass;
    private String basePeer;
    private String defaultIdMethod;
    private String defaultJavaType;
    private String defaultJavaNamingMethod;
    private Hashtable tablesByName = new Hashtable();
    private Hashtable tablesByJavaName = new Hashtable();
    private boolean heavyIndexing;
    private Set fileNames = new TreeSet();
    private String fileName;

    public Database(String databaseType) {
        this.databaseType = databaseType;
    }

    public void loadFromXML(Attributes attrib) {
        this.setName(attrib.getValue("name"));
        this.pkg = attrib.getValue("package");
        this.baseClass = attrib.getValue("baseClass");
        this.basePeer = attrib.getValue("basePeer");
        this.defaultJavaType = attrib.getValue("defaultJavaType");
        this.defaultIdMethod = attrib.getValue("defaultIdMethod");
        this.defaultJavaNamingMethod = attrib.getValue("defaultJavaNamingMethod");
        if (this.defaultJavaNamingMethod == null) {
            this.defaultJavaNamingMethod = "underscore";
        }
        this.heavyIndexing = "true".equals(attrib.getValue("heavyIndexing"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "default" : name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Set getFileNames() {
        return this.fileNames;
    }

    public void setFileName(String name) {
        this.fileName = name;
        this.fileNames.add(name);
    }

    public void setFileNames(Set names) {
        this.fileNames.addAll(names);
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String v) {
        this.pkg = v;
    }

    public String getBaseClass() {
        if (this.baseClass == null) {
            return "BaseObject";
        }
        return this.baseClass;
    }

    public void setBaseClass(String v) {
        this.baseClass = v;
    }

    public String getBasePeer() {
        if (this.basePeer == null) {
            return "BasePeer";
        }
        return this.basePeer;
    }

    public void setBasePeer(String v) {
        this.basePeer = v;
    }

    public String getDefaultIdMethod() {
        return this.defaultIdMethod;
    }

    public void setDefaultIdMethod(String v) {
        this.defaultIdMethod = v;
    }

    public String getDefaultJavaType() {
        return this.defaultJavaType;
    }

    public String getDefaultJavaNamingMethod() {
        return this.defaultJavaNamingMethod;
    }

    public void setDefaultJavaNamingMethod(String v) {
        this.defaultJavaNamingMethod = v;
    }

    public boolean isHeavyIndexing() {
        return this.heavyIndexing;
    }

    public void setHeavyIndexing(boolean v) {
        this.heavyIndexing = v;
    }

    public List getTables() {
        return this.tableList;
    }

    public Table getTable(String name) {
        return (Table)this.tablesByName.get(name);
    }

    public Table getTableByJavaName(String javaName) {
        return (Table)this.tablesByJavaName.get(javaName);
    }

    public Table addTable(Attributes attrib) {
        Table tbl = new Table();
        tbl.setDatabase(this);
        tbl.loadFromXML(attrib, this.getDefaultIdMethod());
        this.addTable(tbl);
        return tbl;
    }

    public void addTable(Table tbl) {
        tbl.setDatabase(this);
        this.tableList.add(tbl);
        this.tablesByName.put(tbl.getName(), tbl);
        this.tablesByJavaName.put(tbl.getJavaName(), tbl);
    }

    public void addDomain(Domain domain) {
        this.domainMap.put(domain.getName(), domain);
    }

    public Domain getDomain(String domainName) {
        return (Domain)this.domainMap.get(domainName);
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public Platform getPlatform() {
        return PlatformFactory.getPlatformFor(this.databaseType);
    }

    public boolean requiresIdTable() {
        for (Table table : this.getTables()) {
            if (!table.getIdMethod().equals("idbroker")) continue;
            return true;
        }
        return false;
    }

    public void doFinalInitialization() throws EngineException {
        for (Table currTable : this.getTables()) {
            if (currTable.getIdMethod().equals("autoincrement")) {
                boolean foundOne = false;
                Iterator colIter = currTable.getColumns().iterator();
                while (colIter.hasNext() && !foundOne) {
                    foundOne = ((Column)colIter.next()).isAutoIncrement();
                }
                if (!foundOne) {
                    String errorMessage = "Table '" + currTable.getName() + "' is marked as autoincrement, but it does not have a column which declared as the one to auto increment (i.e. autoIncrement=\"true\")\n";
                    throw new EngineException("Error in XML schema: " + errorMessage);
                }
            }
            currTable.doFinalInitialization();
            for (ForeignKey currFK : currTable.getForeignKeys()) {
                Table foreignTable = this.getTable(currFK.getForeignTableName());
                if (foreignTable == null) {
                    throw new EngineException("Attempt to set foreign key to nonexistent table, " + currFK.getForeignTableName());
                }
                List referrers = foreignTable.getReferrers();
                if (referrers == null || !referrers.contains(currFK)) {
                    foreignTable.addReferrer(currFK);
                }
                Iterator localColumnNames = currFK.getLocalColumns().iterator();
                while (localColumnNames.hasNext()) {
                    Column local = currTable.getColumn((String)localColumnNames.next());
                    if (local == null) {
                        throw new EngineException("Attempt to define foreign key with nonexistent column in table, " + currTable.getName());
                    }
                    if (!local.isPrimaryKey()) continue;
                    currTable.setContainsForeignPK(true);
                }
                for (String foreignColumnName : currFK.getForeignColumns()) {
                    Column foreign = foreignTable.getColumn(foreignColumnName);
                    if (foreign == null) {
                        throw new EngineException("Attempt to set foreign key to nonexistent column: table=" + currTable.getName() + ", foreign column=" + foreignColumnName);
                    }
                    foreign.addReferrer(currFK);
                }
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<?xml version=\"1.0\"?>\n");
        result.append("<!-- Autogenerated by SQLToXMLSchema! -->\n");
        result.append("<database name=\"").append(this.getName()).append('\"').append(" package=\"").append(this.getPackage()).append('\"').append(" defaultIdMethod=\"").append(this.getDefaultIdMethod()).append('\"').append(" baseClass=\"").append(this.getBaseClass()).append('\"').append(" basePeer=\"").append(this.getBasePeer()).append('\"').append(">\n");
        Iterator i = this.tableList.iterator();
        while (i.hasNext()) {
            result.append(i.next());
        }
        result.append("</database>");
        return result.toString();
    }

    public void addDataBase(Database db) {
        this.setFileNames(db.getFileNames());
        this.addTables(db.getTables());
    }

    private void addTables(List tables) {
        for (Table table : tables) {
            if (this.contain(table)) continue;
            this.addTable(table);
        }
    }

    private boolean contain(Table table) {
        for (Table tb : this.tableList) {
            if (!tb.equals(table)) continue;
            return true;
        }
        return false;
    }
}

