/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.CallableParam;
import com.frameworkset.common.poolman.CallableParams;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.NewSQLInfo;
import com.frameworkset.common.poolman.Param;
import com.frameworkset.common.poolman.Params;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.ResultMap;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.handle.XMLMark;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.frameworkset.persitent.type.BaseTypeMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableDBUtil
extends PreparedDBUtil {
    public static int CALL_PROCEDURE = 0;
    public static int CALL_FUNCTION = 1;
    private static Logger log = LoggerFactory.getLogger(CallableDBUtil.class);
    private ResultMap callableResult;

    @Override
    protected Param buildParam() {
        return this.buildCallableParam();
    }

    @Override
    protected Params buildParams() {
        return this.buildCallableParams(CALL_PROCEDURE);
    }

    protected Params buildCallableParams(int calltype) {
        CallableParams temp_ = new CallableParams();
        temp_.call_type = calltype;
        return temp_;
    }

    protected CallableParam buildCallableParam() {
        return new CallableParam();
    }

    private void addCallableParam(int index, int sqlType, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.sqlType = sqlType;
        param.index = index;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(int index, int sqlType, String typeName, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.sqlType = sqlType;
        param.index = index;
        param.method = method;
        param.typeName = typeName;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(int index, int sqlType, int scale, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.sqlType = sqlType;
        param.index = index;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String paramName, int sqlType, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = paramName;
        param.sqlType = sqlType;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String parameterName, int sqlType, String typeName, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = parameterName;
        param.sqlType = sqlType;
        param.typeName = typeName;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String paramName, int sqlType, int scale, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = paramName;
        param.sqlType = sqlType;
        param.scale = scale;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String paramName, Object value, int scale, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = paramName;
        param.data = value;
        param.scale = scale;
        param.method = method;
        ((CallableParams)this.Params).callParams.add(param);
    }

    private void addCallableParam(String parameterName, Object value, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = parameterName;
        param.data = value;
        param.method = method;
        ((CallableParams)this.Params).callParams.add(param);
    }

    private void addCallableParam(String parameterName, Object value, int targetSqlType, int scale, BaseTypeMethod method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = parameterName;
        param.data = value;
        param.sqlType = targetSqlType;
        param.scale = scale;
        param.method = method;
        ((CallableParams)this.Params).callParams.add(param);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.addCallableParam(parameterIndex, sqlType, CallableParam.registerOutParameter_int_parameterIndex_int_sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.addCallableParam(parameterIndex, sqlType, scale, CallableParam.registerOutParameter_int_parameterIndex_int_sqlType_int_scale);
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public String getString(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getString(parameterIndex);
        }
        return null;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBoolean(parameterIndex);
        }
        throw new SQLException("getBoolean(" + parameterIndex + ") failed:value=null.");
    }

    public byte getByte(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getByte(parameterIndex);
        }
        throw new SQLException("getByte(" + parameterIndex + ") failed:value=null.");
    }

    public short getShort(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getShort(parameterIndex);
        }
        throw new SQLException("getShort(" + parameterIndex + ") failed:value=null.");
    }

    public int getInt(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getInt(parameterIndex);
        }
        throw new SQLException("getInt(" + parameterIndex + ") failed:value=null.");
    }

    public long getLong(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getLong(parameterIndex);
        }
        throw new SQLException("getInt(" + parameterIndex + ") failed:value=null.");
    }

    public float getFloat(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getFloat(parameterIndex);
        }
        throw new SQLException("getFloat(" + parameterIndex + ") failed:value=null.");
    }

    public double getDouble(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDouble(parameterIndex);
        }
        throw new SQLException("getDouble(" + parameterIndex + ") failed:value=null.");
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBigDecimal(parameterIndex, scale);
        }
        return null;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBytes(parameterIndex);
        }
        return null;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterIndex);
        }
        return null;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterIndex);
        }
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterIndex);
        }
        return null;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(parameterIndex);
        }
        return null;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBigDecimal(parameterIndex);
        }
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(i, map);
        }
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getRef(i);
        }
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBlob(i);
        }
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getClob(i);
        }
        return null;
    }

    public Array getArray(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getArray(i);
        }
        return null;
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterIndex, cal);
        }
        return null;
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterIndex, cal);
        }
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterIndex, cal);
        }
        return null;
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.addCallableParam(paramIndex, sqlType, typeName, CallableParam.registerOutParameter_int_paramIndex_int_sqlType_String_typeName);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.addCallableParam(parameterName, sqlType, CallableParam.registerOutParameter_String_parameterName_int_sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.addCallableParam(parameterName, sqlType, scale, CallableParam.registerOutParameter_String_parameterName_int_sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.addCallableParam(parameterName, sqlType, typeName, CallableParam.registerOutParameter_String_parameterName_int_sqlType_String_typeName);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getURL(parameterIndex);
        }
        return null;
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this.addCallableParam(parameterName, val, CallableParam.setURL_String_parameterName_URL_val);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.addCallableParam(parameterName, sqlType, CallableParam.setNull_String_parameterName_int_sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setBoolean_String_parameterName_boolean_x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.addCallableParam(parameterName, (int)x, CallableParam.setByte_String_parameterName_byte_x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.addCallableParam(parameterName, (int)x, CallableParam.setShort_String_parameterName_short_x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setInt_String_parameterName_int_x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setLong_String_parameterName_long_x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.addCallableParam(parameterName, Float.valueOf(x), CallableParam.setFloat_String_parameterName_float_x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setDouble_String_parameterName_double_x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setBigDecimal_String_parameterName_BigDecimal_x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setString_String_parameterName_String_x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setBytes_String_parameterName_byteArray_x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setDate_String_parameterName_Date_x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setTime_String_parameterName_Time_x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setTimestamp_String_parameterName_Timestamp_x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, length}, CallableParam.setAsciiStream_String_parameterName_InputStream_x_int_length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, length}, CallableParam.setBinaryStream_String_parameterName_InputStream_x_int_length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.addCallableParam(parameterName, x, targetSqlType, scale, CallableParam.setObject_String_parameterName_Object_x_int_targetSqlType_int_scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.addCallableParam(parameterName, x, targetSqlType, CallableParam.setObject_String_parameterName_Object_x_int_targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.addCallableParam(parameterName, x, CallableParam.setObject_String_parameterName_Object_x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{reader, length}, CallableParam.setCharacterStream_String_parameterName_Reader_reader_int_length);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, cal}, CallableParam.setDate_String_parameterName_Date_x_Calendar_cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, cal}, CallableParam.setTime_String_parameterName_Time_x_Calendar_cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, cal}, CallableParam.setTimestamp_String_parameterName_Timestamp_x_Calendar_cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{sqlType, typeName}, CallableParam.setNull_String_parameterName_int_sqlType_String_typeName);
    }

    public String getString(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getString(parameterName);
        }
        return null;
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBoolean(parameterName);
        }
        throw new SQLException("getBoolean(" + parameterName + ") failed:value=null.");
    }

    public byte getByte(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getByte(parameterName);
        }
        throw new SQLException("getByte(" + parameterName + ") failed:value=null.");
    }

    public short getShort(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getShort(parameterName);
        }
        throw new SQLException("getShort(" + parameterName + ") failed:value=null.");
    }

    public int getInt(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getInt(parameterName);
        }
        throw new SQLException("getInt(" + parameterName + ") failed:value=null.");
    }

    public long getLong(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getLong(parameterName);
        }
        throw new SQLException("getInt(" + parameterName + ") failed:value=null.");
    }

    public float getFloat(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getFloat(parameterName);
        }
        throw new SQLException("getFloat(" + parameterName + ") failed:value=null.");
    }

    public double getDouble(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDouble(parameterName);
        }
        throw new SQLException("getDouble(" + parameterName + ") failed:value=null.");
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBytes(parameterName);
        }
        return null;
    }

    public Date getDate(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterName);
        }
        return null;
    }

    public Time getTime(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterName);
        }
        return null;
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterName);
        }
        return null;
    }

    public Object getObject(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(parameterName);
        }
        return null;
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBigDecimal(parameterName);
        }
        return null;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(parameterName, map);
        }
        return null;
    }

    public Ref getRef(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getRef(parameterName);
        }
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBlob(parameterName);
        }
        return null;
    }

    public Clob getClob(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getClob(parameterName);
        }
        return null;
    }

    public Array getArray(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getArray(parameterName);
        }
        return null;
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterName, cal);
        }
        return null;
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterName, cal);
        }
        return null;
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterName, cal);
        }
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getURL(parameterName);
        }
        return null;
    }

    public void getFile(int index, File file) throws SQLException, IOException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            this.callableResult.getOrigineprocresult().getFile(index, file);
        }
    }

    public void getFile(String parameterName, File file) throws SQLException, IOException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            this.callableResult.getOrigineprocresult().getFile(parameterName, file);
        }
    }

    public void prepareCallable(String sql) {
        this.Params = this.buildCallableParams(CALL_PROCEDURE);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    public void prepareCallable(String preparedDBName, String sql) {
        this.prepareDBName = preparedDBName;
        this.Params = this.buildCallableParams(CALL_PROCEDURE);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    private void prepareCallable(String sql, int calltype) throws SQLException {
        if (calltype != CALL_FUNCTION && calltype != CALL_PROCEDURE) {
            throw new SQLException("CALL_TYPE error: Must be CALL_FUNCTION or CALL_PROCEDURE.");
        }
        this.Params = this.buildCallableParams(calltype);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    private void prepareCallable(String preparedDBName, String sql, int calltype) throws SQLException {
        if (calltype != CALL_FUNCTION && calltype != CALL_PROCEDURE) {
            throw new SQLException("CALL_TYPE error: Must be CALL_FUNCTION or CALL_PROCEDURE.");
        }
        this.prepareDBName = preparedDBName;
        this.Params = this.buildCallableParams(calltype);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    public void executeCallable() throws SQLException {
        this.executeCallable(null, Map.class, null);
    }

    public String executeCallableForXML() throws SQLException {
        return this.executeCallableForXML(null, null);
    }

    public String executeCallableForXML(RowHandler rowhandler) throws SQLException {
        return this.executeCallableForXML(null, rowhandler);
    }

    public String executeCallableForXML(Connection con) throws SQLException {
        return this.executeCallableForXML(con, null);
    }

    public String executeCallableForXML(Connection con, RowHandler rowhandler) throws SQLException {
        this.executeCallable(con, XMLMark.class, rowhandler);
        if (this.callableResult != null) {
            return (String)this.callableResult.getCommonresult();
        }
        return null;
    }

    public Object executeCallableForObject(Class objectClass, RowHandler rowHandler) throws SQLException {
        return this.executeCallableForObject(null, objectClass, rowHandler);
    }

    public Object executeCallableForObject(Class objectClass) throws SQLException {
        return this.executeCallableForObject(null, objectClass);
    }

    public Object executeCallableForObject(Connection con, Class objectClass) throws SQLException {
        return this.executeCallableForObject(con, objectClass, null);
    }

    public Object executeCallableForObject(Connection con, Class objectClass, RowHandler rowHandler) throws SQLException {
        this.executeCallable(con, objectClass, rowHandler);
        if (this.callableResult != null) {
            return this.callableResult.getCommonresult();
        }
        return null;
    }

    public void executeCallable(Connection con) throws SQLException {
        this.executeCallable(con, Map.class, null);
    }

    public void executeCallable(RowHandler rowHander) throws SQLException {
        this.executeCallable(null, Map.class, rowHander);
    }

    public void executeCallable(Connection con, RowHandler rowHander) throws SQLException {
        this.executeCallable(con, Map.class, rowHander);
    }

    protected void executeCallable(Connection con_, Class objectclass, RowHandler rowHander) throws SQLException {
        if (this.Params == null || !(this.Params instanceof CallableParams)) {
            throw new SQLException("Callable statement do not been set corrected.");
        }
        StatementInfo stmtInfo = null;
        CallableStatement cstmt = null;
        if (objectclass == null) {
            objectclass = Map.class;
        }
        ArrayList resources = null;
        try {
            stmtInfo = new StatementInfo(this.prepareDBName, this.Params.prepareSqlifo, false, con_, false);
            stmtInfo.init();
            CallableParams _params = (CallableParams)this.Params;
            cstmt = stmtInfo.prepareCallableStatement();
            resources = new ArrayList();
            super.setUpParams(stmtInfo, this.Params, cstmt, resources);
            this.setUpCallableParams(_params, cstmt);
            if (log.isInfoEnabled() && CallableDBUtil.showsql(stmtInfo.getDbname())) {
                log.info("Execute JDBC callable statement:{}", (Object)stmtInfo.getSql());
            }
            boolean success = cstmt.execute();
            if (_params.outParams.size() > 0) {
                this.callableResult = new ResultMap();
            }
            if (_params.call_type == CALL_FUNCTION) {
                if (success) {
                    ResultSet res = cstmt.getResultSet();
                    stmtInfo.addResultSet(res);
                }
                if (this.callableResult != null) {
                    this.callableResult.handle(cstmt, null, objectclass, _params, stmtInfo, rowHander);
                }
            } else if (this.callableResult != null) {
                this.callableResult.handle(cstmt, null, objectclass, _params, stmtInfo, rowHander);
            }
        }
        catch (Exception e) {
            try {
                String error = "Execute " + this.Params.prepareSqlifo.getNewsql() + " on " + this.prepareDBName + " failed:" + e.getMessage();
                System.out.println(error);
                log.error(error, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new NestedSQLException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            stmtInfo = null;
            if (this.Params != null) {
                this.Params.clear();
            }
            CallableDBUtil.releaseResources(resources);
            resources = null;
        }
    }

    public Object getFunctionResult() {
        if (this.callableResult != null) {
            return this.callableResult.getFunctionResult();
        }
        return null;
    }

    protected void setUpCallableParams(CallableParams params, CallableStatement cstmt) throws SQLException {
        for (int i = 0; i < params.callParams.size(); ++i) {
            CallableParam param = (CallableParam)params.callParams.get(i);
            param.method.action(null, param, cstmt);
        }
    }
}

