/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.handle;

import com.frameworkset.common.poolman.Record;
import com.frameworkset.common.poolman.ResultMap;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.RowHandlerException;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.engine.model.SchemaType;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class RowHandler<T> {
    protected PoolManResultSetMetaData meta;
    protected String dbname;
    protected StatementInfo stmtInfo;

    public abstract void handleRow(T var1, Record var2) throws Exception;

    public void init(StatementInfo stmtInfo, PoolManResultSetMetaData meta, String dbname) {
        this.meta = meta;
        this.dbname = dbname;
        this.stmtInfo = stmtInfo;
    }

    public void destroy() {
        this.meta = null;
        this.dbname = null;
    }

    public SchemaType getSchemaType(int clindex) {
        if (this.meta == null) {
            throw new RowHandlerException("\u6e90\u6570\u636e\u5bf9\u8c61[meta]\u672a\u521d\u59cb\u5316,\u65e0\u6cd5\u8fdb\u884c\u884c\u5904\u7406.");
        }
        try {
            int sqltype = this.meta.getColumnType(clindex);
            String typename = this.meta.getColumnTypeName(clindex);
            SchemaType schemaType = SQLUtil.getSchemaType(this.dbname, sqltype, typename);
            return schemaType;
        }
        catch (Exception e) {
            throw new RowHandlerException(e);
        }
    }

    public SchemaType getSchemaType(String colName) {
        if (this.meta == null) {
            throw new RowHandlerException("\u6e90\u6570\u636e\u5bf9\u8c61[meta]\u672a\u521d\u59cb\u5316,\u65e0\u6cd5\u8fdb\u884c\u884c\u5904\u7406.");
        }
        try {
            int index = this.seekIndex(colName);
            int sqltype = this.meta.getColumnTypeByIndex(index);
            String typename = this.meta.getColumnTypeNameByIndex(index);
            SchemaType schemaType = SQLUtil.getSchemaType(this.dbname, sqltype, typename);
            return schemaType;
        }
        catch (RowHandlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RowHandlerException(e);
        }
    }

    private int seekIndex(String colName) {
        return this.meta.seekIndex(colName);
    }

    public <V> V buildValueObject(ResultSet rs, Class<V> valueObjectType) throws SQLException {
        return ResultMap.buildValueObject(rs, valueObjectType, this.stmtInfo);
    }
}

