/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.sql;

import com.frameworkset.common.poolman.sql.PrimaryKey;
import com.frameworkset.common.poolman.sql.PrimaryKeyCache;
import com.frameworkset.common.poolman.util.SQLManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyCacheManager {
    private static Logger log = LoggerFactory.getLogger(PrimaryKeyCacheManager.class);
    private Map<String, PrimaryKeyCache> primaryKeyCaches = Collections.synchronizedMap(new HashMap());
    private static PrimaryKeyCacheManager self;

    public static void destroy(Map<String, Integer> destroies) {
        if (self != null) {
            self._destroy(destroies);
            self = null;
        }
    }

    void _destroy(Map<String, Integer> destroies) {
        if (this.primaryKeyCaches != null) {
            Iterator<Map.Entry<String, PrimaryKeyCache>> it = this.primaryKeyCaches.entrySet().iterator();
            ArrayList<String> closed = new ArrayList<String>();
            while (it.hasNext()) {
                Map.Entry<String, PrimaryKeyCache> entry = it.next();
                if (!destroies.containsKey(entry.getKey())) continue;
                entry.getValue().destroy();
                closed.add(entry.getKey());
            }
            for (String name : closed) {
                this.primaryKeyCaches.remove(name);
            }
        }
    }

    public static void reset() {
        if (self != null) {
            self._reset();
        }
    }

    void _reset() {
        if (this.primaryKeyCaches != null) {
            for (Map.Entry<String, PrimaryKeyCache> entry : this.primaryKeyCaches.entrySet()) {
                entry.getValue().reset();
            }
        }
    }

    private PrimaryKeyCacheManager() {
    }

    public static PrimaryKeyCacheManager getInstance() {
        if (self == null) {
            self = new PrimaryKeyCacheManager();
        }
        return self;
    }

    public void addPrimaryKeyCache(PrimaryKeyCache primaryKeyCache) {
        this.primaryKeyCaches.put(primaryKeyCache.getDbname(), primaryKeyCache);
    }

    public boolean removePrimaryKeyCache(String dbname) {
        return this.primaryKeyCaches.remove(dbname) != null;
    }

    public PrimaryKeyCache getPrimaryKeyCache(String dbname) {
        if (SQLManager.getInstance().getPool(dbname) == null) {
            return null;
        }
        String _dbname = SQLManager.getRealDBNameFromExternalDBNameIfExist(dbname);
        PrimaryKeyCache keyCache = this.primaryKeyCaches.get(_dbname);
        if (keyCache != null) {
            return keyCache;
        }
        return null;
    }

    public PrimaryKey loaderPrimaryKey(String dbname, String tableName) {
        return this.loaderPrimaryKey(null, dbname, tableName);
    }

    public PrimaryKey loaderPrimaryKey(Connection con, String dbname, String tableName) {
        return this.getPrimaryKeyCache(dbname).loaderPrimaryKey(con, tableName);
    }
}

