/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.frameworkset.persitent.datasource.BalanceDatasourceConfig;
import org.frameworkset.persitent.datasource.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceDatasourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(BalanceDatasourceUtil.class);

    public static String acceptsURL(String[] JDBC_CLICKHOUSE_PREFIXS, String url) {
        for (String prefix : JDBC_CLICKHOUSE_PREFIXS) {
            if (!url.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    public static BalanceDatasourceConfig getBalanceDatasourceConfig(String[] JDBC_CLICKHOUSE_PREFIXS, String url, boolean supportFailLoad) throws InvalidValueException {
        String prefix = BalanceDatasourceUtil.acceptsURL(JDBC_CLICKHOUSE_PREFIXS, url);
        if (prefix == null) {
            return null;
        }
        try {
            BalanceDatasourceConfig balanceDatasourceConfig = new BalanceDatasourceConfig();
            int index = url.indexOf("/", prefix.length());
            String hosts = null;
            String database2ndParams = null;
            if (index > 0) {
                hosts = url.substring(prefix.length(), index);
                database2ndParams = url.substring(index + 1);
            } else {
                hosts = url.substring(prefix.length());
            }
            BalanceDatasourceUtil.extractParameters(balanceDatasourceConfig, database2ndParams);
            String[] hostsA = hosts.split(",");
            ArrayList<String> hostsL = new ArrayList<String>(hostsA.length);
            if (index < 0) {
                for (int i = 0; i < hostsA.length; ++i) {
                    StringBuilder tmp = new StringBuilder();
                    tmp.append(prefix).append(hostsA[i]);
                    if (supportFailLoad) {
                        for (int j = 0; j < hostsA.length; ++j) {
                            if (j == i) continue;
                            tmp.append(",").append(hostsA[j]);
                        }
                    }
                    String nodeAdd = tmp.toString();
                    tmp.setLength(0);
                    if (logger.isInfoEnabled()) {
                        logger.info("add node:{}", (Object)nodeAdd);
                    }
                    hostsL.add(nodeAdd);
                }
            } else {
                for (int i = 0; i < hostsA.length; ++i) {
                    StringBuilder tmp = new StringBuilder();
                    tmp.append(prefix).append(hostsA[i]);
                    if (supportFailLoad) {
                        for (int j = 0; j < hostsA.length; ++j) {
                            if (j == i) continue;
                            tmp.append(",").append(hostsA[j]);
                        }
                    }
                    tmp.append("/").append(balanceDatasourceConfig.getDatabase2ndParams());
                    String nodeAdd = tmp.toString();
                    tmp.setLength(0);
                    if (logger.isInfoEnabled()) {
                        logger.info("add node:{}", (Object)nodeAdd);
                    }
                    hostsL.add(nodeAdd);
                }
            }
            balanceDatasourceConfig.setNodes(hostsL);
            return balanceDatasourceConfig;
        }
        catch (Exception e) {
            logger.warn("getBalanceDatasourceConfig of " + url + " failed:", (Throwable)e);
            return null;
        }
    }

    private static void ensure(boolean expr, String message) throws InvalidValueException {
        if (!expr) {
            throw new InvalidValueException(message);
        }
    }

    private static void extractParameters(BalanceDatasourceConfig balanceDatasourceConfig, String database2ndParams) throws InvalidValueException {
        int paramIndex = database2ndParams != null ? database2ndParams.indexOf("?") : -1;
        String database = null;
        String queryParameters = null;
        if (paramIndex >= 0) {
            queryParameters = database2ndParams.substring(paramIndex + 1);
            database = database2ndParams.substring(0, paramIndex);
            balanceDatasourceConfig.setDatabase(database);
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            StringTokenizer tokenizer = new StringTokenizer(queryParameters == null ? "" : queryParameters, "&");
            while (tokenizer.hasMoreTokens()) {
                String[] queryParameter = tokenizer.nextToken().split("=", 2);
                BalanceDatasourceUtil.ensure(queryParameter.length == 2, "JDBC URL Parameter '" + queryParameters + "' Error, Expected '='.");
                String name = queryParameter[0];
                String value = queryParameter[1];
                parameters.put(name, value);
            }
            String balance = (String)parameters.remove("b.balance");
            balanceDatasourceConfig.setBalance(balance);
            String enableBalance = (String)parameters.remove("b.enableBalance");
            if (enableBalance != null && enableBalance.equals("true")) {
                balanceDatasourceConfig.setEnabaleBalance(true);
            }
            Iterator iterator = parameters.entrySet().iterator();
            StringBuilder builder = new StringBuilder();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (builder.length() > 0) {
                    builder.append("&");
                }
                builder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            if (builder.length() > 0) {
                balanceDatasourceConfig.setNormalParams(builder.toString());
            }
            if (database != null) {
                if (balanceDatasourceConfig.getNormalParams() != null) {
                    balanceDatasourceConfig.setDatabase2ndParams(database + "?" + balanceDatasourceConfig.getNormalParams());
                } else {
                    balanceDatasourceConfig.setDatabase2ndParams(database);
                }
            } else {
                balanceDatasourceConfig.setDatabase2ndParams("?" + balanceDatasourceConfig.getNormalParams());
            }
            balanceDatasourceConfig.setParams(parameters);
        } else {
            balanceDatasourceConfig.setDatabase2ndParams(database2ndParams);
            balanceDatasourceConfig.setDatabase(database2ndParams);
        }
    }

    public static void main(String[] args) throws InvalidValueException {
        String[] JDBC_CLICKHOUSE_PREFIXS = new String[]{"jdbc:clickhouse://", "jdbc:clickhouse:http://", "jdbc:clickhouse:https://", "jdbc:ch:http://", "jdbc:ch:https://"};
        String addr = "jdbc:clickhouse://101.13.6.4:29000,101.13.6.7:29000,101.13.6.6:29000/visualops";
        BalanceDatasourceConfig balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, true);
        balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, false);
        addr = "jdbc:clickhouse:http://192.168.137.1:28123,192.168.137.1:28125,192.168.137.1:28126/visualops?ssl=false&connect_timeout=60000&socket_timeout=60000&query_timeout=60000&keep_alive_timeout=60000&clickhouse.jdbc.v1=false&b.balance=random&b.enableBalance=true";
        balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, true);
        balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, false);
        addr = "jdbc:clickhouse://101.13.6.4:29000,101.13.6.7:29000,101.13.6.6:29000";
        balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, true);
        balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, false);
        addr = "jdbc:clickhouse:http://192.168.137.1:28123,192.168.137.1:28125,192.168.137.1:28126/?ssl=false&connect_timeout=60000&socket_timeout=60000&query_timeout=60000&keep_alive_timeout=60000&clickhouse.jdbc.v1=false";
        balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, true);
        balanceDatasourceConfig = BalanceDatasourceUtil.getBalanceDatasourceConfig(JDBC_CLICKHOUSE_PREFIXS, addr, false);
    }
}

