/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.util;

import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.runtime.VelocityEngineVersion;
import bboss.org.apache.velocity.runtime.resource.Resource;
import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.VariableHandler;
import com.frameworkset.velocity.BBossVelocityUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.persitent.template.SQLTemplateFactory;
import org.frameworkset.persitent.util.GloableSQLUtil;
import org.frameworkset.persitent.util.SQLBaseCache;
import org.frameworkset.persitent.util.SQLCache;
import org.frameworkset.persitent.util.SQLConfigException;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLMissingCache;
import org.frameworkset.persitent.util.SQLSOAFileApplicationContext;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProList;
import org.frameworkset.spi.assemble.ProMap;
import org.frameworkset.spi.assemble.ProSet;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLUtil {
    protected BaseApplicationContext sqlcontext;
    private static Logger log = LoggerFactory.getLogger(SQLUtil.class);
    protected static Map<String, SQLUtil> sqlutils = new HashMap<String, SQLUtil>();
    protected SQLBaseCache cache;
    protected static long refresh_interval = 5000L;
    public static final int defaultResultMetaCacheSize = 6000;
    public static final int defaultGloableResultMetaCacheSize = 10000;
    public static final int defaultMaxGloableTemplateCacheSize = 10000;
    public static final int defaultPerKeySqlStructionCacheSize = 5000;
    public static final boolean defaultAlwaysCache = false;
    public static final int defaultGlobalKeySqlStructionCacheSize = 10000;
    protected String defaultDBName = null;
    protected Map<String, SQLInfo> sqls;
    protected Map<String, SQLRef> sqlrefs;
    protected boolean hasrefs;
    protected boolean alwaysCache = false;
    protected String sqlFile;
    protected int resultMetaCacheSize;
    protected int perKeySqlStructionCacheSize;
    private static SQLTemplateFactory factory = null;
    private static GloableSQLUtil globalSQLUtil;
    private static DaemonThread damon;
    private static Object lock;

    private static void initSQLTemplateFactory() {
        if (factory != null) {
            return;
        }
        if (VelocityEngineVersion.getVersion() >= 20) {
            SQLUtil.initSQLTemplateFactory2();
        } else {
            SQLUtil.initSQLTemplateFactory1();
        }
    }

    private static void initSQLTemplateFactory1() {
        if (factory != null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("org.frameworkset.persitent.template.SQLTemplateFactoryImpl1");
            factory = (SQLTemplateFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.error("org.frameworkset.persitent.template.SQLTemplateFactoryImpl not exist", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static void initSQLTemplateFactory2() {
        if (factory != null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("org.frameworkset.persitent.template.SQLTemplateFactoryImpl2");
            factory = (SQLTemplateFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.error("org.frameworkset.persitent.template.SQLTemplateFactoryImpl2 not exist", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Resource createSQLTemplate(SQLInfo sqlinfo) {
        return factory.createSQLTemplate(sqlinfo);
    }

    public Map<String, SQLRef> getSQLRefers() {
        return this.sqlrefs;
    }

    private void trimValues() {
        if (this.sqlcontext == null) {
            return;
        }
        HashMap<String, SQLInfo> sqls = new HashMap<String, SQLInfo>();
        HashMap<String, SQLRef> sqlrefs = new HashMap<String, SQLRef>();
        Set keys = this.sqlcontext.getPropertyKeys();
        boolean hasrefs = false;
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                Pro pro = this.sqlcontext.getProBean(key);
                String sqlfile = (String)pro.getExtendAttribute("sqlfile");
                if (sqlfile == null) {
                    String value;
                    Object o = pro.getObject();
                    if (!(o instanceof String) || (value = (String)o) == null) continue;
                    boolean cacheSql = pro.getBooleanExtendAttribute("cacheSql", true);
                    boolean istpl = pro.getBooleanExtendAttribute("istpl", true);
                    boolean multiparser = pro.getBooleanExtendAttribute("multiparser", istpl);
                    Resource sqltpl = null;
                    value = value.trim();
                    SQLInfo sqlinfo = new SQLInfo(key, value, istpl, multiparser, cacheSql);
                    sqlinfo.setSqlutil(this);
                    if (istpl) {
                        sqltpl = SQLUtil.createSQLTemplate(sqlinfo);
                        sqlinfo.setSqltpl(sqltpl);
                        BBossVelocityUtil.initDBTemplate((Resource)sqltpl);
                        sqltpl.process();
                    }
                    sqls.put(key, sqlinfo);
                    continue;
                }
                String sqlname = (String)pro.getExtendAttribute("sqlname");
                if (sqlname == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn(this.sqlcontext.getConfigfile() + "\u4e2dname=" + key + "\u7684sql\u88ab\u914d\u7f6e\u4e3a\u5bf9" + sqlfile + "\u4e2d\u7684sql\u5f15\u7528\uff0c\u4f46\u662f\u6ca1\u6709\u901a\u8fc7sqlname\u8bbe\u7f6e\u8981\u5f15\u7528\u7684sql\u8bed\u53e5!");
                    continue;
                }
                sqlrefs.put(key, new SQLRef(sqlname, sqlfile, key));
                hasrefs = true;
            }
        }
        int resultMetaCacheSize = this.sqlcontext.getIntProperty("resultMetaCacheSize", 6000);
        int perKeySqlStructionCacheSize = this.sqlcontext.getIntProperty("perKeySqlStructionCacheSize", 5000);
        this.sqlrefs = sqlrefs;
        this.sqls = sqls;
        this.alwaysCache = this.sqlcontext.getBooleanProperty("alwaysCache", false);
        this.cache = this.alwaysCache ? new SQLCache(this.sqlFile, resultMetaCacheSize, perKeySqlStructionCacheSize) : new SQLMissingCache(this.sqlFile, resultMetaCacheSize, perKeySqlStructionCacheSize);
        this.hasrefs = hasrefs;
    }

    public boolean hasrefs() {
        return this.hasrefs;
    }

    protected void _destroy() {
        if (this.sqls != null) {
            this.sqls.clear();
            this.sqls = null;
        }
        if (this.sqlrefs != null) {
            this.sqlrefs.clear();
            this.sqlrefs = null;
        }
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.sqlcontext != null) {
            this.sqlcontext.destroy(true);
        }
        this.defaultDBName = null;
    }

    void reinit() {
        if (this.sqlcontext != null) {
            String file = this.sqlcontext.getConfigfile();
            this.sqlcontext.removeCacheContext();
            SQLSOAFileApplicationContext _sqlcontext = new SQLSOAFileApplicationContext(PoolManConfiguration.getSqlMappingDir(), file);
            if (_sqlcontext.getParserError() == null) {
                this.sqlcontext.destroy(false);
                this.sqlcontext = _sqlcontext;
                this.defaultDBName = this.sqlcontext.getProperty("default.dbname");
                this.trimValues();
            } else {
                this.sqlcontext.restoreCacheContext();
            }
        }
    }

    public VariableHandler.SQLStruction getSQLStruction(SQLInfo sqlinfo, String newsql) {
        return this.cache.getSQLStruction(sqlinfo, newsql);
    }

    public VariableHandler.SQLStruction getTotalsizeSQLStruction(SQLInfo totalsizesqlinfo, String totalsizesql) {
        return this.cache.getTotalsizeSQLStruction(totalsizesqlinfo, totalsizesql);
    }

    public static void stopmonitor() {
        try {
            if (damon != null) {
                damon.stopped();
                damon = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getSQLFile() {
        return this.sqlcontext.getConfigfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSQLUtil(URL sqlfileURL, String sqlfile, SQLUtil sqlutil) {
        refresh_interval = PoolManConfiguration.getRefresh_interval();
        if (refresh_interval > 0L) {
            if (damon == null) {
                Object object = lock;
                synchronized (object) {
                    if (damon == null) {
                        damon = new DaemonThread(refresh_interval, "SQL files Refresh Worker");
                        damon.start();
                    }
                }
            }
            damon.addFile(sqlfileURL, sqlfile, (ResourceInitial)new ResourceSQLRefresh(sqlutil));
        }
    }

    private SQLUtil(String sqlfile) {
        this.sqlFile = sqlfile;
        this.sqlcontext = new SQLSOAFileApplicationContext(PoolManConfiguration.getSqlMappingDir(), sqlfile);
        this.trimValues();
        this.defaultDBName = this.sqlcontext.getProperty("default.dbname");
        if (this.sqlcontext.getConfigFileURL() != null) {
            SQLUtil.checkSQLUtil(this.sqlcontext.getConfigFileURL(), sqlfile, this);
        }
    }

    public SQLUtil(int resultMetaCacheSize, int perKeySqlStructionCacheSize, boolean alwaysCache) {
        this.alwaysCache = alwaysCache;
        this.resultMetaCacheSize = resultMetaCacheSize;
        this.perKeySqlStructionCacheSize = perKeySqlStructionCacheSize;
        this.cache = alwaysCache ? new SQLCache(null, resultMetaCacheSize, perKeySqlStructionCacheSize) : new SQLMissingCache(null, resultMetaCacheSize, perKeySqlStructionCacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLUtil getInstance(String sqlfile) {
        if (sqlfile == null) {
            throw new SQLConfigException("SQL config file is null.");
        }
        SQLUtil sqlUtil = sqlutils.get(sqlfile);
        if (sqlUtil != null) {
            return sqlUtil;
        }
        Map<String, SQLUtil> map = sqlutils;
        synchronized (map) {
            sqlUtil = sqlutils.get(sqlfile);
            if (sqlUtil != null) {
                return sqlUtil;
            }
            sqlUtil = new SQLUtil(sqlfile);
            sqlutils.put(sqlfile, sqlUtil);
        }
        return sqlUtil;
    }

    static void destory() {
        if (sqlutils != null) {
            for (Map.Entry<String, SQLUtil> entry : sqlutils.entrySet()) {
                entry.getValue()._destroy();
            }
            sqlutils.clear();
            sqlutils = null;
        }
    }

    private SQLInfo getReferSQLInfo(String dbname, String sqlname) {
        SQLRef ref = this.sqlrefs.get(sqlname);
        if (ref != null) {
            return ref.getSQLInfo(dbname);
        }
        return null;
    }

    public SQLInfo getSQLInfo(String dbname, String sqlname) {
        SQLInfo sql = null;
        if (this.hasrefs && (sql = this.getReferSQLInfo(dbname, sqlname)) != null) {
            return sql;
        }
        String dbtype = SQLManager.getInstance().getDBAdapter(dbname).getDBTYPE();
        if (dbtype != null) {
            sql = this.sqls.get(sqlname + "-" + dbtype.toLowerCase());
        }
        if (sql == null) {
            sql = this.sqls.get(sqlname);
        }
        if (sql == null) {
            sql = this.sqls.get(sqlname + "-default");
        }
        return sql;
    }

    public String getPlainSQL(String dbname, String sqlname) {
        SQLInfo sql = null;
        if (this.hasrefs && (sql = this.getReferSQLInfo(dbname, sqlname)) != null) {
            return sql.getSql();
        }
        String dbtype = SQLManager.getInstance().getDBAdapter(dbname).getDBTYPE();
        if (dbtype != null) {
            sql = this.sqls.get(sqlname + "-" + dbtype.toLowerCase());
        }
        if (sql == null) {
            sql = this.sqls.get(sqlname);
        }
        if (sql == null) {
            sql = this.sqls.get(sqlname + "-default");
        }
        if (sql != null) {
            return sql.getSql();
        }
        return null;
    }

    private String getReferSQL(String dbname, String sqlname) {
        SQLRef ref = this.sqlrefs.get(sqlname);
        if (ref != null) {
            return ref.getSQL(dbname);
        }
        return null;
    }

    public String getSQL(String dbname, String sqlname) {
        String sql;
        if (this.hasrefs && (sql = this.getReferSQL(dbname, sqlname)) != null) {
            return sql;
        }
        String dbtype = SQLManager.getInstance().getDBAdapter(dbname).getDBTYPE();
        SQLInfo sql2 = null;
        if (dbtype != null) {
            sql2 = this.sqls.get(sqlname + "-" + dbtype.toLowerCase());
        }
        if (sql2 == null) {
            sql2 = this.sqls.get(sqlname);
        }
        if (sql2 == null) {
            sql2 = this.sqls.get(sqlname + "-default");
        }
        return sql2 != null ? sql2.getSql() : null;
    }

    private String getReferSQL(String dbname, String sqlname, Map variablevalues) {
        SQLRef ref = this.sqlrefs.get(sqlname);
        if (ref != null) {
            return ref.getSQL(dbname, variablevalues);
        }
        return null;
    }

    public String getSQL(String dbname, String sqlname, Map variablevalues) {
        String sql;
        if (this.hasrefs && (sql = this.getReferSQL(dbname, sqlname, variablevalues)) != null) {
            return sql;
        }
        String dbtype = SQLManager.getInstance().getDBAdapter(dbname).getDBTYPE();
        String newsql = null;
        SQLInfo sql2 = null;
        if (dbtype != null) {
            sql2 = this.sqls.get(sqlname + "-" + dbtype.toLowerCase());
        }
        if (sql2 == null) {
            sql2 = this.sqls.get(sqlname);
        }
        if (sql2 == null) {
            sql2 = this.sqls.get(sqlname + "-default");
        }
        if (sql2 != null) {
            newsql = SQLUtil._getSQL(sql2, variablevalues);
        }
        return newsql;
    }

    public static String _getSQL(SQLInfo sqlinfo, Map variablevalues) {
        String sql = null;
        VelocityContext vcontext = null;
        if (sqlinfo.istpl()) {
            sqlinfo.getSqltpl().process();
            if (sqlinfo.istpl()) {
                vcontext = BBossVelocityUtil.buildVelocityContext((Map)variablevalues);
                StringWriter sw = new StringWriter();
                sqlinfo.getSqltpl().merge((Context)vcontext, (Writer)sw);
                sql = sw.toString();
            } else {
                sql = sqlinfo.getSql();
            }
        } else {
            sql = sqlinfo.getSql();
        }
        return sql;
    }

    public String evaluateSQL(String name, String sql, Map variablevalues) {
        if (sql != null && variablevalues != null && variablevalues.size() > 0) {
            sql = BBossVelocityUtil.evaluate((Map)variablevalues, (String)(this.sqlcontext.getConfigfile() + "|" + name), (String)sql);
        }
        return sql;
    }

    public String getSQL(String sqlname, Map variablevalues) {
        return this.getSQL(null, sqlname, variablevalues);
    }

    public String getDBName(String sqlname) {
        Pro pro = this.sqlcontext.getProBean(sqlname);
        if (pro == null) {
            return this.defaultDBName;
        }
        return pro.getStringExtendAttribute("dbname");
    }

    public String[] getPropertyKeys() {
        Set keys = this.sqlcontext.getPropertyKeys();
        if (keys == null) {
            return new String[0];
        }
        String[] rets = new String[keys.size()];
        Iterator its = keys.iterator();
        int i = 0;
        while (its.hasNext()) {
            rets[i] = (String)its.next();
            ++i;
        }
        return rets;
    }

    public SQLInfo getSQLInfo(String sqlname) {
        return this.getSQLInfo(null, sqlname);
    }

    public String getSQL(String sqlname) {
        return this.getSQL(null, sqlname);
    }

    public Map getMapSQLs(String sqlname) {
        return this.getMapSQLs(this.getDBName(sqlname), sqlname);
    }

    public Map getMapSQLs(String dbname, String sqlname) {
        ProMap sqls = this.sqlcontext.getMapProperty(sqlname);
        if (sqls == null) {
            String dbtype = SQLManager.getInstance().getDBAdapter(dbname).getDBTYPE();
            sqls = this.sqlcontext.getMapProperty(sqlname + "-" + dbtype.toLowerCase());
        }
        if (sqls == null) {
            sqls = this.sqlcontext.getMapProperty(sqlname + "-default");
        }
        return sqls;
    }

    public PoolManResultSetMetaData getPoolManResultSetMetaData(JDBCPool db, String dbname, String sqlkey, ResultSetMetaData rsmetadata) throws SQLException {
        return this.cache.getPoolManResultSetMetaData(true, db, dbname, sqlkey, rsmetadata);
    }

    public List getListSQLs(String sqlname) {
        return this.getListSQLs(this.getDBName(sqlname), sqlname);
    }

    public List getListSQLs(String dbname, String sqlname) {
        ProList sqls = this.sqlcontext.getListProperty(sqlname);
        if (sqls == null) {
            String dbtype = SQLManager.getInstance().getDBAdapter(dbname).getDBTYPE();
            sqls = this.sqlcontext.getListProperty(sqlname + "-" + dbtype.toLowerCase());
        }
        if (sqls == null) {
            sqls = this.sqlcontext.getListProperty(sqlname + "-default");
        }
        return sqls;
    }

    public Set getSetSQLs(String sqlname) {
        return this.getSetSQLs(this.getDBName(sqlname), sqlname);
    }

    public Set getSetSQLs(String dbname, String sqlname) {
        ProSet sqls = this.sqlcontext.getSetProperty(sqlname);
        if (sqls == null) {
            String dbtype = SQLManager.getInstance().getDBAdapter(dbname).getDBTYPE();
            sqls = this.sqlcontext.getSetProperty(sqlname + "-" + dbtype.toLowerCase());
        }
        if (sqls == null) {
            sqls = this.sqlcontext.getSetProperty(sqlname + "-default");
        }
        return sqls;
    }

    public BaseApplicationContext getSqlcontext() {
        return this.sqlcontext;
    }

    public long getRefresh_interval() {
        return refresh_interval;
    }

    public static List<String> getSQLFiles() {
        Iterator<String> it = sqlutils.keySet().iterator();
        ArrayList<String> files = new ArrayList<String>();
        while (it.hasNext()) {
            files.add(it.next());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GloableSQLUtil getGlobalSQLUtil() {
        if (globalSQLUtil != null) {
            return globalSQLUtil;
        }
        Class<GloableSQLUtil> clazz = GloableSQLUtil.class;
        synchronized (GloableSQLUtil.class) {
            if (globalSQLUtil != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return globalSQLUtil;
            }
            globalSQLUtil = new GloableSQLUtil(10000, 10000, 10000, false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalSQLUtil;
        }
    }

    public boolean fromConfig() {
        return this.sqlcontext != null;
    }

    static {
        SQLUtil.initSQLTemplateFactory();
        globalSQLUtil = null;
        damon = null;
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                SQLUtil.stopmonitor();
                SQLUtil.destory();
                if (globalSQLUtil != null) {
                    globalSQLUtil._destroy();
                    globalSQLUtil = null;
                }
            }
        });
        lock = new Object();
    }

    public static class SQLRef {
        private SQLUtil sqlutil;
        private String sqlname;
        private String sqlfile;
        private String name;

        public SQLRef(String sqlname, String sqlfile, String name) {
            this.sqlname = sqlname;
            this.sqlfile = sqlfile;
            this.name = name;
        }

        public String getSqlname() {
            return this.sqlname;
        }

        public String getSqlfile() {
            return this.sqlfile;
        }

        public String getName() {
            return this.name;
        }

        public SQLInfo getSQLInfo(String dbname) {
            if (this.sqlutil == null) {
                this.init();
            }
            return this.sqlutil.getSQLInfo(dbname, this.sqlname);
        }

        private synchronized void init() {
            if (this.sqlutil == null) {
                this.sqlutil = SQLUtil.getInstance(this.sqlfile);
            }
        }

        public String getSQL(String dbname) {
            if (this.sqlutil == null) {
                this.init();
            }
            return this.sqlutil.getSQL(dbname, this.sqlname);
        }

        public String getSQL() {
            if (this.sqlutil == null) {
                this.init();
            }
            return this.sqlutil.getSQL(null, this.sqlname);
        }

        public String getSQL(String dbname, Map variablevalues) {
            if (this.sqlutil == null) {
                this.init();
            }
            return this.sqlutil.getSQL(dbname, this.sqlname, variablevalues);
        }
    }

    static class ResourceSQLRefresh
    implements ResourceInitial {
        private SQLUtil sqlutil;

        public ResourceSQLRefresh(SQLUtil sqlutil) {
            this.sqlutil = sqlutil;
        }

        public void reinit() {
            this.sqlutil.reinit();
        }
    }
}

