/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.ClassData;
import com.frameworkset.util.EditorInf;
import com.frameworkset.util.NoSupportTypeCastException;
import com.frameworkset.util.ValueObjectUtil;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.beans.PropertyAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(TransferObjectFactory.class);
    private static HashMap classDataInfo = new HashMap();

    public static Serializable createTransferObject(Object ejb, String whichTOType, String completeTOType) {
        try {
            ClassData cData = TransferObjectFactory.getClassData(completeTOType);
            ClassData voCData = TransferObjectFactory.getClassData(whichTOType);
            Object whichTO = Class.forName(whichTOType).newInstance();
            Field[] voFields = voCData.arrFields;
            Field[] beanFields = cData.arrFields;
            if (voFields == null || voFields.length == 0 || beanFields == null || beanFields.length == 0) {
                return (Serializable)TransferObjectFactory.createTransferObject(ejb, whichTO);
            }
            block4: for (int i = 0; i < voFields.length; ++i) {
                try {
                    String voFieldName = voFields[i].getName();
                    for (int j = 0; j < beanFields.length; ++j) {
                        if (!voFieldName.equals(beanFields[j].getName())) continue;
                        voFields[i].set(whichTO, beanFields[j].get(ejb));
                        continue block4;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (Serializable)whichTO;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object createTransferObject(Map completeVO, Object whichToVO) {
        if (completeVO == null || whichToVO == null) {
            return null;
        }
        ClassUtil.ClassInfo beanInfo = null;
        try {
            beanInfo = ClassUtil.getClassInfo(whichToVO.getClass());
        }
        catch (Exception e) {
            throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, "", null, null), "\u83b7\u53d6bean \u4fe1\u606f\u5931\u8d25", e);
        }
        List attributes = beanInfo.getPropertyDescriptors();
        Set keys = completeVO.entrySet();
        block6: for (Map.Entry entry : keys) {
            String name = String.valueOf(entry.getKey());
            Object pvalue = entry.getValue();
            for (ClassUtil.PropertieDescription property : attributes) {
                if (!name.equals(property.getName())) continue;
                Class type = property.getPropertyType();
                Object value = null;
                Method writeMethod = property.getWriteMethod();
                if (pvalue != null) {
                    EditorInf editor = property.getWriteMethodEditor();
                    value = editor == null ? ValueObjectUtil.typeCast(pvalue, pvalue.getClass(), (Class)type) : ValueObjectUtil.typeCast(pvalue, (EditorInf)editor);
                }
                try {
                    writeMethod.invoke(whichToVO, value);
                    continue block6;
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, name, null, value), "\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25", e);
                }
                catch (IllegalAccessException e) {
                    throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, name, null, value), "\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25", e);
                }
                catch (InvocationTargetException e) {
                    throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, name, null, value), "\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25", e);
                }
            }
        }
        return whichToVO;
    }

    public static Object createTransferObject(Hashtable completeVO, Object whichToVO) {
        if (completeVO == null || whichToVO == null) {
            return null;
        }
        Method[] wMethods = whichToVO.getClass().getMethods();
        if (wMethods == null || wMethods.length == 0) {
            return whichToVO;
        }
        for (int i = 0; i < wMethods.length; ++i) {
            String wmName = wMethods[i].getName();
            if (!wmName.startsWith("set")) continue;
            String wmPrex = wmName.substring(0, 3);
            String wfield = wmName.substring(3);
            Object value = null;
            try {
                Class<?> paramType;
                value = completeVO.get(wfield);
                if (value == null) {
                    log.info("warning:[" + wfield + " not found in hashmap" + "]!");
                    continue;
                }
                Class<?> retType = value.getClass();
                if (retType == (paramType = wMethods[i].getParameterTypes()[0])) {
                    ValueObjectUtil.invoke((Object)whichToVO, (Method)wMethods[i], (Object[])new Object[]{value});
                    continue;
                }
                Object obj = ValueObjectUtil.typeCast((Object)value, retType, paramType);
                ValueObjectUtil.invoke((Object)whichToVO, (Method)wMethods[i], (Object[])new Object[]{obj});
                continue;
            }
            catch (NullPointerException e) {
                log.info("warning NullPointerException:[" + wfield + "] not found in [map]!");
                continue;
            }
            catch (NoSuchMethodException e) {
                log.info("warning NoSuchMethodException:[" + e.getMessage() + "]");
                continue;
            }
            catch (SecurityException securitye) {
                log.info("warning SecurityException:[" + securitye.getMessage() + "]");
                continue;
            }
            catch (NoSupportTypeCastException castException) {
                log.info("warning NoSupportTypeCastException:[" + wfield + "][" + wMethods[i] + "] return value type not match the param type!");
                continue;
            }
            catch (NumberFormatException e) {
                log.info("warning NumberFormatException:[" + e.getMessage() + "]");
                continue;
            }
            catch (IllegalArgumentException e) {
                log.info("warning IllegalArgumentException:[" + e.getMessage() + "]");
                continue;
            }
            catch (Exception e) {
                log.info("warning Exception:[" + e.getMessage() + "]");
            }
        }
        return whichToVO;
    }

    public static Object createTransferObject(Object completeVO, Object whichToVO) {
        if (completeVO == null || whichToVO == null) {
            return null;
        }
        Method[] wMethods = whichToVO.getClass().getMethods();
        Class<?> cClazz = completeVO.getClass();
        if (wMethods == null || wMethods.length == 0) {
            return whichToVO;
        }
        for (int i = 0; i < wMethods.length; ++i) {
            String wmName = wMethods[i].getName();
            if (!wmName.startsWith("set")) continue;
            String wmPrex = wmName.substring(0, 3);
            String wfield = wmName.substring(3);
            Method cMethod = null;
            try {
                Class<?> paramType;
                Class<?> retType;
                block20: {
                    try {
                        cMethod = cClazz.getMethod(ValueObjectUtil.getMethodName((String)wfield), null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cMethod == null) {
                        try {
                            cMethod = cClazz.getMethod(ValueObjectUtil.getBooleanMethodName((String)wfield), null);
                            if (cMethod == null) {
                                log.info("warning:[" + wMethods[i] + "]" + ValueObjectUtil.getMethodName((String)wfield) + " not found in [" + cClazz + "]!");
                            }
                            break block20;
                        }
                        catch (Exception e) {
                            log.info("warning:[" + wMethods[i] + "]" + ValueObjectUtil.getMethodName((String)wfield) + " not found in [" + cClazz + "]!");
                        }
                        continue;
                    }
                }
                if ((retType = cMethod.getReturnType()) == (paramType = wMethods[i].getParameterTypes()[0])) {
                    ValueObjectUtil.invoke((Object)whichToVO, (Method)wMethods[i], (Object[])new Object[]{ValueObjectUtil.invoke((Object)completeVO, (Method)cMethod, null)});
                    continue;
                }
                Object obj = ValueObjectUtil.typeCast((Object)ValueObjectUtil.invoke((Object)completeVO, (Method)cMethod, null), retType, paramType);
                ValueObjectUtil.invoke((Object)whichToVO, (Method)wMethods[i], (Object[])new Object[]{obj});
                continue;
            }
            catch (NullPointerException e) {
                log.info("warning NullPointerException:[" + wMethods[i] + "] not found in [" + cClazz + "]!");
                continue;
            }
            catch (NoSuchMethodException e) {
                log.info("warning NoSuchMethodException:[" + e.getMessage() + "]");
                continue;
            }
            catch (SecurityException securitye) {
                log.info("warning SecurityException:[" + securitye.getMessage() + "]");
                continue;
            }
            catch (NoSupportTypeCastException castException) {
                log.info("warning NoSupportTypeCastException:[" + cMethod + "][" + wMethods[i] + ("] return value type not match the param type!" + castException.getMessage()), (Throwable)castException);
                continue;
            }
            catch (NumberFormatException e) {
                log.info("warning NumberFormatException:[" + e.getMessage() + "]");
                continue;
            }
            catch (IllegalArgumentException e) {
                log.info("warning IllegalArgumentException:[" + e.getMessage() + "]");
                continue;
            }
            catch (Exception e) {
                log.info("warning Exception:[" + e.getMessage() + "]");
            }
        }
        return whichToVO;
    }

    private static ClassData getClassData(String className) {
        ClassData cData = (ClassData)classDataInfo.get(className);
        try {
            if (cData == null) {
                Class<?> ejbTOClass = Class.forName(className);
                Field[] arrFields = ejbTOClass.getFields();
                cData = new ClassData(ejbTOClass, arrFields, ejbTOClass.getMethods());
                classDataInfo.put(className, cData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cData;
    }

    public static void main(String[] args) {
        log.debug("debug:aaaaa");
        log.info("info:bbbbbbb");
        log.warn("warn:bbbbbbb");
        log.error("error:bbbbbbb");
    }
}

