/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.GenericCollectionTypeResolver;
import org.frameworkset.util.JdkVersion;
import org.frameworkset.util.MethodParameter;

public abstract class Conventions {
    private static final String PLURAL_SUFFIX = "List";
    private static final Set ignoredInterfaces = new HashSet();

    public static String getVariableName(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        Class valueClass = null;
        boolean pluralize = false;
        if (value.getClass().isArray()) {
            valueClass = value.getClass().getComponentType();
            pluralize = true;
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object valueToCheck = Conventions.peekAhead(collection);
            valueClass = Conventions.getClassForValue(valueToCheck);
            pluralize = true;
        } else {
            valueClass = Conventions.getClassForValue(value);
        }
        String name = ClassUtils.getShortNameAsProperty((Class)valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String getVariableNameForParameter(MethodParameter parameter) {
        Assert.notNull((Object)parameter, (String)"MethodParameter must not be null");
        Class valueClass = null;
        boolean pluralize = false;
        if (parameter.getParameterType().isArray()) {
            valueClass = parameter.getParameterType().getComponentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(parameter.getParameterType())) {
            if (JdkVersion.isAtLeastJava15()) {
                valueClass = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)parameter);
            }
            if (valueClass == null) {
                throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection parameter type");
            }
            pluralize = true;
        } else {
            valueClass = parameter.getParameterType();
        }
        String name = ClassUtils.getShortNameAsProperty((Class)valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String getVariableNameForReturnType(Method method) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), null);
    }

    public static String getVariableNameForReturnType(Method method, Object value) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), value);
    }

    public static String getVariableNameForReturnType(Method method, Class resolvedType, Object value) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        if (Object.class.equals((Object)resolvedType)) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot generate variable name for an Object return type with null value");
            }
            return Conventions.getVariableName(value);
        }
        Class valueClass = null;
        boolean pluralize = false;
        if (resolvedType.isArray()) {
            valueClass = resolvedType.getComponentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(resolvedType)) {
            if (JdkVersion.isAtLeastJava15()) {
                valueClass = GenericCollectionTypeResolver.getCollectionReturnType((Method)method);
            }
            if (valueClass == null) {
                if (!(value instanceof Collection)) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and a non-Collection value");
                }
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and an empty Collection value");
                }
                Object valueToCheck = Conventions.peekAhead(collection);
                valueClass = Conventions.getClassForValue(valueToCheck);
            }
            pluralize = true;
        } else {
            valueClass = resolvedType;
        }
        String name = ClassUtils.getShortNameAsProperty((Class)valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String attributeNameToPropertyName(String attributeName) {
        Assert.notNull((Object)attributeName, (String)"'attributeName' must not be null");
        if (attributeName.indexOf("-") == -1) {
            return attributeName;
        }
        char[] chars = attributeName.toCharArray();
        char[] result = new char[chars.length - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                result[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
                continue;
            }
            result[currPos++] = c;
        }
        return new String(result, 0, currPos);
    }

    public static String getQualifiedAttributeName(Class enclosingClass, String attributeName) {
        Assert.notNull((Object)enclosingClass, (String)"'enclosingClass' must not be null");
        Assert.notNull((Object)attributeName, (String)"'attributeName' must not be null");
        return enclosingClass.getName() + "." + attributeName;
    }

    private static Class getClassForValue(Object value) {
        Class<?> valueClass = value.getClass();
        if (Proxy.isProxyClass(valueClass)) {
            Class<?>[] ifcs = valueClass.getInterfaces();
            for (int i = 0; i < ifcs.length; ++i) {
                Class<?> ifc = ifcs[i];
                if (ignoredInterfaces.contains(ifc)) continue;
                return ifc;
            }
        } else if (valueClass.getName().lastIndexOf(36) != -1 && valueClass.getDeclaringClass() == null) {
            valueClass = valueClass.getSuperclass();
        }
        return valueClass;
    }

    private static String pluralize(String name) {
        return name + PLURAL_SUFFIX;
    }

    private static Object peekAhead(Collection collection) {
        Iterator it = collection.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        Object value = it.next();
        if (value == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return value;
    }

    static {
        ignoredInterfaces.add(Serializable.class);
        ignoredInterfaces.add(Externalizable.class);
        ignoredInterfaces.add(Cloneable.class);
        ignoredInterfaces.add(Comparable.class);
    }
}

