/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtils;

public abstract class TypeUtils {
    public static boolean isAssignable(Type lhsType, Type rhsType) {
        Assert.notNull((Object)lhsType, (String)"Left-hand side type must not be null");
        Assert.notNull((Object)rhsType, (String)"Right-hand side type must not be null");
        if (lhsType.equals(rhsType)) {
            return true;
        }
        if (lhsType instanceof Class && rhsType instanceof Class) {
            return ClassUtils.isAssignable((Class)((Class)lhsType), (Class)((Class)rhsType));
        }
        if (lhsType instanceof ParameterizedType && rhsType instanceof ParameterizedType) {
            return TypeUtils.isAssignable((ParameterizedType)lhsType, (ParameterizedType)rhsType);
        }
        if (lhsType instanceof WildcardType) {
            return TypeUtils.isAssignable((WildcardType)lhsType, rhsType);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType lhsType, ParameterizedType rhsType) {
        Type[] rhsTypeArguments;
        if (lhsType.equals(rhsType)) {
            return true;
        }
        Type[] lhsTypeArguments = lhsType.getActualTypeArguments();
        if (lhsTypeArguments.length != (rhsTypeArguments = rhsType.getActualTypeArguments()).length) {
            return false;
        }
        int size = lhsTypeArguments.length;
        for (int i = 0; i < size; ++i) {
            Type lhsArg = lhsTypeArguments[i];
            Type rhsArg = rhsTypeArguments[i];
            if (lhsArg.equals(rhsArg) || lhsArg instanceof WildcardType && TypeUtils.isAssignable((WildcardType)lhsArg, rhsArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType lhsType, Type rhsType) {
        int i;
        Type[] upperBounds = lhsType.getUpperBounds();
        Type[] lowerBounds = lhsType.getLowerBounds();
        int size = upperBounds.length;
        for (i = 0; i < size; ++i) {
            if (TypeUtils.isAssignable(upperBounds[i], rhsType)) continue;
            return false;
        }
        size = lowerBounds.length;
        for (i = 0; i < size; ++i) {
            if (TypeUtils.isAssignable(rhsType, lowerBounds[i])) continue;
            return false;
        }
        return true;
    }
}

