/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.frameworkset.tran.jobflow.CompositionJobFlowNode;
import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.JobFlowCyclicBarrier;
import org.frameworkset.tran.jobflow.JobFlowException;
import org.frameworkset.tran.jobflow.JobFlowNodeType;
import org.frameworkset.tran.jobflow.NodeTrigger;
import org.frameworkset.tran.jobflow.context.JobFlowContext;
import org.frameworkset.tran.jobflow.context.JobFlowNodeContext;
import org.frameworkset.tran.jobflow.context.JobFlowNodeExecuteContext;
import org.frameworkset.tran.jobflow.context.ParrelJobFlowNodeContext;
import org.frameworkset.tran.jobflow.context.SequenceJobFlowNodeContext;
import org.frameworkset.tran.jobflow.listener.JobFlowNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobFlowNode {
    private static Logger logger_ = LoggerFactory.getLogger(JobFlowNode.class);
    protected JobFlowNodeType jobFlowNodeType = JobFlowNodeType.SIMPLE;
    protected String nodeId;
    protected String nodeName;
    protected JobFlow jobFlow;
    protected String jobFlowNodeInfo;
    protected CompositionJobFlowNode compositionJobFlowNode;
    protected NodeTrigger nodeTrigger;
    protected JobFlowNode parentJobFlowNode;
    protected List<JobFlowNodeListener> jobFlowNodeListeners;
    protected JobFlowNode nextJobFlowNode;
    protected SequenceJobFlowNodeContext containerSequenceJobFlowNodeContext;
    protected ParrelJobFlowNodeContext containerParrelJobFlowNodeContext;
    protected JobFlowContext containerJobFlowContext;
    protected JobFlowNodeContext jobFlowNodeContext;
    protected JobFlowNodeExecuteContext jobFlowNodeExecuteContext;

    protected void release() {
        this.jobFlowNodeExecuteContext = null;
    }

    public void setJobFlowNodeListeners(List<JobFlowNodeListener> jobFlowNodeListeners) {
        this.jobFlowNodeListeners = jobFlowNodeListeners;
    }

    public List<JobFlowNodeListener> getJobFlowNodeListeners() {
        return this.jobFlowNodeListeners;
    }

    public JobFlowNodeExecuteContext getContainerJobFlowNodeExecuteContext() {
        if (this.compositionJobFlowNode != null) {
            return this.compositionJobFlowNode.getJobFlowNodeExecuteContext();
        }
        return null;
    }

    public JobFlowNodeExecuteContext getJobFlowNodeExecuteContext() {
        return this.jobFlowNodeExecuteContext;
    }

    protected String buildJobFlowNodeInfo() {
        if (this.jobFlowNodeInfo == null) {
            StringBuilder info = new StringBuilder();
            info.append(this.getClass().getSimpleName()).append("[id=").append(this.getNodeId()).append(",nodeName=").append(this.getNodeName()).append(",nodeType=").append(this.jobFlowNodeType.name()).append("]");
            this.jobFlowNodeInfo = info.toString();
            return this.jobFlowNodeInfo;
        }
        return this.jobFlowNodeInfo;
    }

    public String getJobFlowNodeInfo() {
        return this.buildJobFlowNodeInfo();
    }

    public void setCompositionJobFlowNode(CompositionJobFlowNode compositionJobFlowNode) {
        this.compositionJobFlowNode = compositionJobFlowNode;
    }

    public JobFlowNodeContext getJobFlowNodeContext() {
        return this.jobFlowNodeContext;
    }

    public void setContainerSequenceJobFlowNodeContext(SequenceJobFlowNodeContext containerSequenceJobFlowNodeContext) {
        this.containerSequenceJobFlowNodeContext = containerSequenceJobFlowNodeContext;
        if (this.nextJobFlowNode != null) {
            this.nextJobFlowNode.setContainerSequenceJobFlowNodeContext(containerSequenceJobFlowNodeContext);
        }
    }

    public void setContainerJobFlowContext(JobFlowContext containerJobFlowContext) {
        this.containerJobFlowContext = containerJobFlowContext;
        if (this.nextJobFlowNode != null) {
            this.nextJobFlowNode.setContainerJobFlowContext(containerJobFlowContext);
        }
    }

    public void setContainerParrelJobFlowNodeContext(ParrelJobFlowNodeContext containerParrelJobFlowNodeContext) {
        this.containerParrelJobFlowNodeContext = containerParrelJobFlowNodeContext;
    }

    public CompositionJobFlowNode getCompositionJobFlowNode() {
        return this.compositionJobFlowNode;
    }

    public void setParentJobFlowNode(JobFlowNode parentJobFlowNode) {
        this.parentJobFlowNode = parentJobFlowNode;
    }

    public void reset() {
        this.jobFlowNodeContext.reset();
        if (this.nextJobFlowNode != null) {
            this.nextJobFlowNode.reset();
        }
    }

    public boolean assertTrigger() {
        if (this.nodeTrigger == null) {
            logger_.info("AssertTrigger: null AssertTrigger and return true,flowNode[id={},name={}].", (Object)this.getNodeId(), (Object)this.getNodeName());
            return true;
        }
        try {
            if (this.nodeTrigger.assertTrigger(this.jobFlow, this)) {
                logger_.info("AssertTrigger: true,flowNode[id={},name={}].", (Object)this.getNodeId(), (Object)this.getNodeName());
                return true;
            }
            logger_.info("AssertTrigger: false,flowNode[id={},name={}].", (Object)this.getNodeId(), (Object)this.getNodeName());
            return false;
        }
        catch (Exception e) {
            throw new JobFlowException("AassertTrigger failed:", e);
        }
    }

    public JobFlowNode getParentJobFlowNode() {
        return this.parentJobFlowNode;
    }

    public void setNextJobFlowNode(JobFlowNode nextJobFlowNode) {
        this.nextJobFlowNode = nextJobFlowNode;
    }

    public JobFlowNode getNextJobFlowNode() {
        return this.nextJobFlowNode;
    }

    public void setNodeTrigger(NodeTrigger nodeTrigger) {
        this.nodeTrigger = nodeTrigger;
    }

    public NodeTrigger getNodeTrigger() {
        return this.nodeTrigger;
    }

    public void setJobFlow(JobFlow jobFlow) {
        this.jobFlow = jobFlow;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public JobFlow getJobFlow() {
        return this.jobFlow;
    }

    public abstract boolean start(JobFlowCyclicBarrier var1);

    public void start() {
        this.start(null);
    }

    public abstract void stop();

    public abstract void pause();

    public abstract void consume();

    public void nodeComplete(Throwable throwable) {
        this.nodeComplete(throwable, false);
    }

    public void nodeComplete(Throwable throwable, boolean ignoreExecute) {
        if (this.jobFlowNodeExecuteContext == null || !this.jobFlowNodeExecuteContext.nodeCompleteUnExecuted()) {
            return;
        }
        this.jobFlowNodeContext.setExecuteException(throwable);
        this.complete(throwable);
        if (CollectionUtils.isNotEmpty(this.jobFlowNodeListeners)) {
            for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                jobFlowNodeListener.afterExecute(this.jobFlowNodeExecuteContext, throwable);
            }
        } else if (throwable != null) {
            logger_.error(this.getJobFlowNodeInfo() + " complete with exception:", throwable);
        }
        this.release();
        if (this.nextJobFlowNode != null && !ignoreExecute) {
            logger_.info("{} execute complete and start nextJobFlowNode[{}]", (Object)this.getJobFlowNodeInfo(), (Object)this.nextJobFlowNode.getJobFlowNodeInfo());
            this.nextJobFlowNode.start();
        } else if (this.parentJobFlowNode != null) {
            logger_.info("{} execute complete and call parentJobFlowNode[{}]\u2018s nextNodeComplete", (Object)this.getJobFlowNodeInfo(), (Object)this.parentJobFlowNode.getJobFlowNodeInfo());
            this.parentJobFlowNode.nextNodeComplete(null);
        } else if (this.compositionJobFlowNode != null) {
            logger_.info("Execute {} complete and call compositionJobFlowNode[{}]'s brachComplete.", (Object)this.getJobFlowNodeInfo(), (Object)this.compositionJobFlowNode.getJobFlowNodeInfo());
            this.compositionJobFlowNode.brachComplete(this, null);
        } else {
            logger_.info("Execute {} complete and call {}'s complete.", (Object)this.getJobFlowNodeInfo(), (Object)this.jobFlow.getJobInfo());
            this.jobFlow.complete(null);
        }
    }

    public void nextNodeComplete(Throwable e) {
        if (this.parentJobFlowNode != null) {
            this.parentJobFlowNode.nextNodeComplete(e);
        } else if (this.compositionJobFlowNode != null) {
            this.compositionJobFlowNode.brachComplete(this, e);
        } else {
            this.jobFlow.complete(e);
        }
    }

    public void setJobFlowNodeType(JobFlowNodeType jobFlowNodeType) {
        this.jobFlowNodeType = jobFlowNodeType;
    }

    public JobFlowNodeType getJobFlowNodeType() {
        return this.jobFlowNodeType;
    }

    public String toString() {
        return this.getJobFlowNodeInfo();
    }

    protected void nodeStart() {
        if (this.containerJobFlowContext != null) {
            this.containerJobFlowContext.setRunningJobFlowNode(this);
            this.containerJobFlowContext.nodeStart(this);
        }
        if (this.containerSequenceJobFlowNodeContext != null) {
            this.containerSequenceJobFlowNodeContext.setRunningJobFlowNode(this);
            this.containerSequenceJobFlowNodeContext.nodeStart(this);
        }
        if (this.containerParrelJobFlowNodeContext != null) {
            this.containerParrelJobFlowNodeContext.nodeStart(this);
        }
    }

    protected void complete(Throwable throwable) {
        if (this.containerSequenceJobFlowNodeContext != null) {
            this.containerSequenceJobFlowNodeContext.nodeComplete(throwable, this);
        }
        if (this.containerJobFlowContext != null) {
            this.containerJobFlowContext.nodeComplete(throwable, this);
        }
        if (this.containerParrelJobFlowNodeContext != null) {
            this.containerParrelJobFlowNodeContext.nodeComplete(throwable, this);
        }
    }
}

