/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.MetricKey;
import org.frameworkset.tran.metrics.job.BaseKeyMetrics;
import org.frameworkset.tran.metrics.job.BaseMetrics;
import org.frameworkset.tran.metrics.job.KeyMetricBuilder;
import org.frameworkset.tran.metrics.job.KeyMetricsContainer;
import org.frameworkset.tran.metrics.job.KeyMetricsPersistent;
import org.frameworkset.tran.metrics.job.MetricsLogAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyMetrics
extends BaseKeyMetrics
implements BaseMetrics {
    private String metricsName = "TimeMetrics";
    private ReentrantLock lock = new ReentrantLock();
    private MetricsLogAPI metricsLogAPI;
    private static Logger logger = LoggerFactory.getLogger(KeyMetrics.class);
    private boolean stoped;
    private Object stopLock = new Object();

    protected void initKeyMetric(KeyMetric keyMetric, MapData data, String metricsKey) {
        this.initKeyMetric(keyMetric, data, new MetricKey(metricsKey));
    }

    protected void initKeyMetric(KeyMetric keyMetric, MapData data, MetricKey metricsKey) {
        keyMetric.setDataTime(data.metricsDataTime(metricsKey));
        keyMetric.setSlotTime(new Date());
        keyMetric.setMetric(metricsKey.getMetricKey());
        keyMetric.init(data);
    }

    @Override
    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    @Override
    public KeyMetric metric(String metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        return this.metric(new MetricKey(metricsKey), data, metricBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyMetric metric(MetricKey metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        if (!metricBuilder.validateData(data)) {
            if (logger.isDebugEnabled()) {
                logger.debug("data validate failed:{}", (Object)SimpleStringUtil.object2json(data.getData()));
            }
            return null;
        }
        boolean isFull = false;
        KeyMetric keyMetric = null;
        KeyMetricsContainer keyMetricsContainerTemp = this.keyMetricsContainerS0;
        KeyMetricsContainer persistent = null;
        this.lock.lock();
        try {
            keyMetric = keyMetricsContainerTemp.getKeyMetric(metricsKey.getMetricKey());
            if (keyMetric == null) {
                keyMetric = this.keyMetricsContainerS1.getKeyMetric(metricsKey.getMetricKey());
            }
            if (keyMetric == null) {
                keyMetric = metricBuilder.build();
                keyMetric.setMetricsLogAPI(this.getMetricsLogAPI());
                this.initKeyMetric(keyMetric, data, metricsKey);
                boolean bl = isFull = !keyMetricsContainerTemp.putKeyMetric(metricsKey.getMetricKey(), keyMetric);
                if (isFull) {
                    if (this.keyMetricsContainerS1.isEmpty()) {
                        this.keyMetricsContainerS0 = this.keyMetricsContainerS1;
                        this.keyMetricsContainerS1 = keyMetricsContainerTemp;
                    } else {
                        KeyMetricsContainer keyMetricsContainerS0Temp;
                        persistent = this.keyMetricsContainerS1;
                        this.keyMetricsContainerS1 = keyMetricsContainerTemp;
                        this.keyMetricsContainerS0 = keyMetricsContainerS0Temp = this.buildKeyMetricsContainer();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        keyMetric.increment(data);
        if (persistent != null) {
            this.persistent(persistent);
        }
        return keyMetric;
    }

    @Override
    protected void initMetrics() {
        KeyMetricsPersistent metricsPersistent = new KeyMetricsPersistent();
        metricsPersistent.setPersistent(this);
        metricsPersistent.init();
        this.setMetricsPersistent(metricsPersistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceFlush(boolean clearMetricsKey, boolean waitComplete) {
        long s = System.currentTimeMillis();
        Future future = null;
        this.lock.lock();
        try {
            if (!this.keyMetricsContainerS0.isEmpty()) {
                future = this.persistent(this.keyMetricsContainerS0);
                this.keyMetricsContainerS0 = this.buildKeyMetricsContainer();
            }
            if (!this.keyMetricsContainerS1.isEmpty()) {
                future = this.persistent(this.keyMetricsContainerS1);
                this.keyMetricsContainerS1 = this.buildKeyMetricsContainer();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (waitComplete && future != null) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                logger.error("", (Throwable)e);
            }
        }
        logger.info("Force Flush keymetrics complete elapse:{} ms.", (Object)(System.currentTimeMillis() - s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMetrics() {
        if (this.stoped) {
            return;
        }
        Object object = this.stopLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        this.forceFlush(true, true);
        if (this.metricsPersistent != null) {
            this.metricsPersistent.stop();
        }
    }
}

