/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.job.PersistentScanCallback;

public class KeyMetricsContainer {
    private int segmentBoundSize = 100000;
    private Map<String, KeyMetric> keyMetric = new LinkedHashMap<String, KeyMetric>();

    public void setSegmentBoundSize(int segmentBoundSize) {
        this.segmentBoundSize = segmentBoundSize;
    }

    public void scanPersistentMetrics(PersistentScanCallback persistentScanCallback) {
        ArrayList<String> removed = new ArrayList<String>();
        for (Map.Entry<String, KeyMetric> entry : this.keyMetric.entrySet()) {
            if (!persistentScanCallback.scanTimeMetric2Persistent(entry.getValue())) break;
            removed.add(entry.getValue().getMetric());
        }
        if (removed.size() > 0) {
            removed.forEach(metricKey -> this.keyMetric.remove(metricKey));
        }
    }

    public KeyMetric getKeyMetric(String metricKey) {
        return this.keyMetric.get(metricKey);
    }

    public boolean reachSegmentBoundSize(int size) {
        return size >= this.segmentBoundSize;
    }

    public boolean putKeyMetric(String metricKey, KeyMetric keyMetric) {
        this.keyMetric.put(metricKey, keyMetric);
        return !this.reachSegmentBoundSize(this.keyMetric.size());
    }

    public boolean isEmpty() {
        return this.keyMetric.isEmpty();
    }

    public Map<String, KeyMetric> getKeyMetric() {
        return this.keyMetric;
    }

    public void clean() {
        this.keyMetric = new LinkedHashMap<String, KeyMetric>();
    }
}

