/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import java.util.Collection;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.job.KeyMetricsPersistent;
import org.frameworkset.tran.metrics.job.KeyTimeMetrics;
import org.frameworkset.tran.metrics.job.MetricsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTimeScanTask
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(KeyTimeScanTask.class);
    private MetricsConfig metricsConfig;
    private KeyMetricsPersistent metricsPersistent;
    private KeyTimeMetrics metrics;
    private boolean stoped;
    private Object stopScanLock = new Object();

    public KeyTimeScanTask(String tname) {
        super(tname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan() {
        if (this.stoped) {
            return;
        }
        Object object = this.stopScanLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        try {
            this.interrupt();
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.stoped) {
            try {
                KeyTimeScanTask.sleep(this.metricsConfig.getScanInterval());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.stoped) break;
            Collection<KeyMetric> persistentMetrics = this.metrics.scanPersistentMetrics();
            if (persistentMetrics.size() <= 0) continue;
            this.metricsPersistent.persistent(persistentMetrics);
        }
    }

    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    public void setMetricsPersistent(KeyMetricsPersistent metricsPersistent) {
        this.metricsPersistent = metricsPersistent;
    }

    public void setMetrics(KeyTimeMetrics metrics) {
        this.metrics = metrics;
    }
}

