/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.MetricKey;
import org.frameworkset.tran.metrics.job.BaseMetrics;
import org.frameworkset.tran.metrics.job.KeyMetricBuilder;
import org.frameworkset.tran.metrics.job.KeyMetrics;
import org.frameworkset.tran.metrics.job.KeyTimeMetrics;
import org.frameworkset.tran.metrics.job.MetricsException;
import org.frameworkset.tran.metrics.job.MetricsLogAPI;
import org.frameworkset.tran.metrics.job.TimeKeyMetrics;
import org.frameworkset.tran.metrics.job.TimeMetrics;
import org.frameworkset.tran.metrics.job.builder.MetricBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Metrics
implements BaseMetrics {
    protected MetricsLogAPI metricsLogAPI;
    private BaseMetrics baseMetrics;
    private List<MetricBuilder> metricBuilders;
    private boolean inited;
    private String metricsName;
    public static int MetricsType_KeyTimeMetircs = 0;
    public static int MetricsType_TimeKeyMetircs = 1;
    public static int MetricsType_TimeMetircs = 2;
    public static int MetricsType_KeyMetircs = 3;
    public static int MetricsType_DEFAULT = -1;
    private int metricsType = MetricsType_DEFAULT;
    private static Logger logger = LoggerFactory.getLogger(Metrics.class);
    private int segmentBoundSize = 10000000;
    protected int timeWindowType = 2;
    private long scanInterval = 5000L;
    private int timeWindows = 60;
    private int persistentDataHolderSize = 5000;
    private Object initLock = new Object();

    public Metrics() {
        this.metricsType = MetricsType_DEFAULT;
    }

    public Metrics(int metricsType) {
        this.metricsType = metricsType;
    }

    protected MetricsLogAPI buildMetricsLogAPI() {
        return null;
    }

    @Override
    public void setMetricsLogAPI(MetricsLogAPI metricsLogAPI) {
        this.metricsLogAPI = metricsLogAPI;
    }

    @Override
    public MetricsLogAPI getMetricsLogAPI() {
        return this.metricsLogAPI;
    }

    public void setTimeWindows(int timeWindows) {
        this.timeWindows = timeWindows;
    }

    public int getTimeWindowType() {
        return this.timeWindowType;
    }

    public void setTimeWindowType(int timeWindowType) {
        this.timeWindowType = timeWindowType;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval;
    }

    public void setSegmentBoundSize(int segmentBoundSize) {
        this.segmentBoundSize = segmentBoundSize;
    }

    public int getSegmentBoundSize() {
        return this.segmentBoundSize;
    }

    public void setMetricsType(int metricsType) {
        if (metricsType != MetricsType_KeyTimeMetircs && metricsType != MetricsType_TimeKeyMetircs && metricsType != MetricsType_TimeMetircs && metricsType != MetricsType_KeyMetircs) {
            throw new MetricsException("\u9519\u8bef\u7684\u6307\u6807\u8ba1\u7b97\u5668\u7c7b\u578b\uff1a" + metricsType + ",\u652f\u6301\u4ee5\u4e0b\u7c7b\u578b\uff1aMetricsType_KeyTimeMetircs = 0\n\tMetricsType_TimeKeyMetircs = 1\n\tMetricsType_TimeMetircs = 2\n\tMetricsType_KeyMetircs = 3");
        }
        this.metricsType = metricsType;
    }

    @Override
    public void forceFlush(boolean cleanMetricsKey, boolean waitComplete) {
        this.baseMetrics.forceFlush(cleanMetricsKey, waitComplete);
    }

    public void forceFlush() {
        this.forceFlush(false, false);
    }

    public void setPersistentDataHolderSize(int persistentDataHolderSize) {
        this.persistentDataHolderSize = persistentDataHolderSize;
    }

    @Override
    public void stopMetrics() {
        logger.info("Stop metrics begin......");
        this.baseMetrics.stopMetrics();
        logger.info("Stop metrics completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.inited) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.inited) {
                return;
            }
            this.builderMetrics();
            this.metricsLogAPI = this.buildMetricsLogAPI();
            if (this.metricsType == MetricsType_KeyTimeMetircs || this.metricsType == MetricsType_DEFAULT) {
                KeyTimeMetrics baseMetrics = new KeyTimeMetrics(){

                    @Override
                    public void map(MapData data) {
                        Metrics.this.map(data);
                    }

                    @Override
                    public void persistent(Collection<KeyMetric> metrics) {
                        Metrics.this.persistent(metrics);
                    }
                };
                baseMetrics.setTimeWindows(this.timeWindows);
                baseMetrics.setScanInterval(this.scanInterval);
                baseMetrics.setSegmentBoundSize(this.segmentBoundSize);
                baseMetrics.setPersistentDataHolderSize(this.persistentDataHolderSize);
                baseMetrics.setTimeWindowType(this.timeWindowType);
                baseMetrics.setMetricsLogAPI(this.metricsLogAPI);
                this.baseMetrics = baseMetrics;
            } else if (this.metricsType == MetricsType_TimeKeyMetircs) {
                TimeKeyMetrics baseMetrics = new TimeKeyMetrics(){

                    @Override
                    public void map(MapData data) {
                        Metrics.this.map(data);
                    }

                    @Override
                    public void persistent(Collection<KeyMetric> metrics) {
                        Metrics.this.persistent(metrics);
                    }
                };
                baseMetrics.setTimeWindows(this.timeWindows);
                baseMetrics.setScanInterval(this.scanInterval);
                baseMetrics.setSegmentBoundSize(this.segmentBoundSize);
                baseMetrics.setTimeWindowType(this.timeWindowType);
                baseMetrics.setMetricsLogAPI(this.metricsLogAPI);
                this.baseMetrics = baseMetrics;
            } else if (this.metricsType == MetricsType_TimeMetircs) {
                TimeMetrics baseMetrics = new TimeMetrics(){

                    @Override
                    public void map(MapData data) {
                        Metrics.this.map(data);
                    }

                    @Override
                    public void persistent(Collection<KeyMetric> metrics) {
                        Metrics.this.persistent(metrics);
                    }
                };
                baseMetrics.setTimeWindows(this.timeWindows);
                baseMetrics.setScanInterval(this.scanInterval);
                baseMetrics.setTimeWindowType(this.timeWindowType);
                baseMetrics.setMetricsLogAPI(this.metricsLogAPI);
                this.baseMetrics = baseMetrics;
            } else if (this.metricsType == MetricsType_KeyMetircs) {
                KeyMetrics baseMetrics = new KeyMetrics(){

                    @Override
                    public void map(MapData data) {
                        Metrics.this.map(data);
                    }

                    @Override
                    public void persistent(Collection<KeyMetric> metrics) {
                        Metrics.this.persistent(metrics);
                    }
                };
                baseMetrics.setSegmentBoundSize(this.segmentBoundSize);
                baseMetrics.setMetricsLogAPI(this.metricsLogAPI);
                this.baseMetrics = baseMetrics;
            }
            if (this.metricsName != null && !this.metricsName.equals("")) {
                this.baseMetrics.setMetricsName(this.metricsName);
            }
            this.baseMetrics.init();
            this.inited = true;
        }
    }

    @Override
    public KeyMetric metric(String metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        return this.baseMetrics.metric(new MetricKey(metricsKey), data, metricBuilder);
    }

    @Override
    public KeyMetric metric(MetricKey metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        return this.baseMetrics.metric(metricsKey, data, metricBuilder);
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    @Override
    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    @Override
    public BaseMetrics addMetricBuilder(MetricBuilder metricBuilder) {
        if (this.metricBuilders == null) {
            this.metricBuilders = new ArrayList<MetricBuilder>();
        }
        this.metricBuilders.add(metricBuilder);
        return this;
    }

    @Override
    public List<MetricBuilder> getMetricBuilders() {
        return this.metricBuilders;
    }

    @Override
    public void map(MapData mapData) {
        List<MetricBuilder> metricBuilders = this.getMetricBuilders();
        if (metricBuilders != null && metricBuilders.size() > 0) {
            for (MetricBuilder metricBuilder : metricBuilders) {
                this.metric(metricBuilder.buildMetricKey(mapData), mapData, metricBuilder.innerMetricBuilder());
            }
        } else {
            throw new MetricsException("metricBuilders\u4e3a\u7a7a\uff08\u6ca1\u6709\u6b63\u786e\u8bbe\u7f6e\u548c\u521d\u59cb\u5316Metrics\uff09\uff0c\u6216\u8005\u6ca1\u6709\u81ea\u5b9a\u4e49\u5b9e\u73b0map\u65b9\u6cd5\uff01");
        }
    }
}

