/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import com.frameworkset.util.SimpleStringUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.MetricKey;
import org.frameworkset.tran.metrics.entity.TimeMetric;
import org.frameworkset.tran.metrics.job.BaseKeyMetrics;
import org.frameworkset.tran.metrics.job.KeyMetricBuilder;
import org.frameworkset.tran.metrics.job.KeyMetricsContainer;
import org.frameworkset.tran.metrics.job.MetricUtil;
import org.frameworkset.tran.metrics.job.PersistentScanCallback;
import org.frameworkset.tran.metrics.job.TimeKeyMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeMetricHolder
extends BaseKeyMetrics {
    private static Logger logger = LoggerFactory.getLogger(TimeKeyMetrics.class);
    private String metricsSlotTimeKey;
    private Date slotTime;
    private Date lastMetricSlotTime;
    private TimeKeyMetrics timeMetrics;
    private String metricTimeKey;

    public void setMetricsSlotTimeKey(String metricsSlotTimeKey) {
        this.metricsSlotTimeKey = metricsSlotTimeKey;
    }

    public String getMetricsSlotTimeKey() {
        return this.metricsSlotTimeKey;
    }

    @Override
    protected void initMetrics() {
    }

    protected void initKeyMetric(KeyMetric metric, MapData data, MetricKey metricsKey) {
        Date slotTime;
        Date time = data.metricsDataTime(metricsKey);
        DateFormat metricsTimeKeyFormat = this.timeMetrics.getMetricsTimeKeyFormat(data);
        String timeMetricKey = metricsTimeKeyFormat.format(time);
        TimeMetric timeMetric = (TimeMetric)metric;
        MetricUtil.buildMetricTimeField(timeMetric, data, time);
        this.lastMetricSlotTime = slotTime = new Date();
        timeMetric.setSlotTime(slotTime);
        timeMetric.setMetricTimeKey(timeMetricKey);
        metric.setMetric(metricsKey.getMetricKey());
        try {
            metric.setDataTime(metricsTimeKeyFormat.parse(timeMetricKey));
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u6307\u6807\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        metric.init(data);
    }

    public KeyMetric metric(String metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        return this.metric(new MetricKey(metricsKey), data, metricBuilder);
    }

    public KeyMetric metric(MetricKey metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        if (!metricBuilder.validateData(data)) {
            if (logger.isDebugEnabled()) {
                logger.debug("data validate failed:{}", (Object)SimpleStringUtil.object2json(data.getData()));
            }
            return null;
        }
        boolean isFull = false;
        KeyMetric keyMetric = null;
        KeyMetricsContainer keyMetricsContainerTemp = this.keyMetricsContainerS0;
        KeyMetricsContainer persistent = null;
        keyMetric = keyMetricsContainerTemp.getKeyMetric(metricsKey.getMetricKey());
        if (keyMetric == null) {
            keyMetric = this.keyMetricsContainerS1.getKeyMetric(metricsKey.getMetricKey());
        }
        if (keyMetric == null) {
            keyMetric = metricBuilder.build();
            keyMetric.setMetricsLogAPI(this.timeMetrics.getMetricsLogAPI());
            this.initKeyMetric(keyMetric, data, metricsKey);
            boolean bl = isFull = !keyMetricsContainerTemp.putKeyMetric(metricsKey.getMetricKey(), keyMetric);
            if (isFull) {
                if (this.keyMetricsContainerS1.isEmpty()) {
                    this.keyMetricsContainerS0 = this.keyMetricsContainerS1;
                    this.keyMetricsContainerS1 = keyMetricsContainerTemp;
                } else {
                    persistent = this.keyMetricsContainerS1;
                    this.keyMetricsContainerS1 = keyMetricsContainerTemp;
                    this.keyMetricsContainerS0 = this.buildKeyMetricsContainer();
                }
            }
        }
        keyMetric.increment(data);
        if (persistent != null) {
            this.persistent(persistent);
        }
        return keyMetric;
    }

    public String getMetricTimeKey() {
        return this.metricTimeKey;
    }

    public boolean needPersistent(Date slot) {
        return this.getSlotTime().before(slot);
    }

    public void persisteMetrics() {
        if (!this.keyMetricsContainerS0.isEmpty()) {
            this.persistent(this.keyMetricsContainerS0);
            this.keyMetricsContainerS0 = null;
        }
        if (!this.keyMetricsContainerS1.isEmpty()) {
            this.persistent(this.keyMetricsContainerS1);
            this.keyMetricsContainerS1 = null;
        }
    }

    public void stopMetrics() {
        this.persisteMetrics();
    }

    public List<Future> forceFlush(boolean waitComplete) {
        Future future = null;
        ArrayList<Future> futures = new ArrayList<Future>();
        if (!this.keyMetricsContainerS0.isEmpty()) {
            future = this.persistent(this.keyMetricsContainerS0);
            if (waitComplete) {
                futures.add(future);
            }
            this.keyMetricsContainerS0 = this.buildKeyMetricsContainer();
        }
        if (!this.keyMetricsContainerS1.isEmpty()) {
            future = this.persistent(this.keyMetricsContainerS1);
            if (waitComplete) {
                futures.add(future);
            }
            this.keyMetricsContainerS1 = this.buildKeyMetricsContainer();
        }
        return futures;
    }

    public boolean isTimeWindowOlder(Date slotOldTime) {
        return this.lastMetricSlotTime.before(slotOldTime);
    }

    public void scanPersistentMetrics(PersistentScanCallback persistentScanCallback) {
        if (!this.keyMetricsContainerS1.isEmpty()) {
            this.keyMetricsContainerS1.scanPersistentMetrics(persistentScanCallback);
        }
        if (!this.keyMetricsContainerS0.isEmpty()) {
            this.keyMetricsContainerS0.scanPersistentMetrics(persistentScanCallback);
        }
    }

    public boolean isEmpty() {
        return this.keyMetricsContainerS0.isEmpty() && this.keyMetricsContainerS1.isEmpty();
    }

    public void setMetricTimeKey(String metricTimeKey) {
        this.metricTimeKey = metricTimeKey;
    }

    public void setSlotTime(Date slotTime) {
        this.slotTime = slotTime;
    }

    public Date getSlotTime() {
        return this.slotTime;
    }

    public void setTimeMetrics(TimeKeyMetrics timeMetrics) {
        this.timeMetrics = timeMetrics;
    }
}

