/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule.quartz;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.jobflow.schedule.ExternalJobFlowScheduler;
import org.frameworkset.tran.jobflow.schedule.JobFlowBuilderFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzJobFlowHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExternalJobFlowScheduler externalJobFlowScheduler;
    private Lock lock = new ReentrantLock();

    public void init() {
        this.externalJobFlowScheduler = new ExternalJobFlowScheduler();
        this.externalJobFlowScheduler.setJobFlowBuilderFunction(this.buildJobFlowBuilderFunction());
    }

    protected abstract JobFlowBuilderFunction buildJobFlowBuilderFunction();

    public void execute() {
        this.lock.lock();
        try {
            this.externalJobFlowScheduler.execute(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        if (this.externalJobFlowScheduler != null) {
            this.externalJobFlowScheduler.destroy();
        }
    }
}

