/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ClientUtil;
import org.frameworkset.elasticsearch.client.ConfigRestClientUtil;
import org.frameworkset.elasticsearch.client.DefaultSlowDslCallback;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.LogDslCallback;
import org.frameworkset.elasticsearch.client.NoServerElasticSearchException;
import org.frameworkset.elasticsearch.client.RestClientUtil;
import org.frameworkset.elasticsearch.client.RestSearchExecutor;
import org.frameworkset.elasticsearch.handler.BaseExceptionResponseHandler;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.frameworkset.spi.remote.http.callback.ExecuteIntercepter;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestClient
implements ElasticSearchClient {
    public static final String INDEX_OPERATION_NAME = "index";
    public static final String INDEX_PARAM = "_index";
    public static final String TYPE_PARAM = "_type";
    public static final String TTL_PARAM = "_ttl";
    public static final String BULK_ENDPOINT = "_bulk";
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestClient.class);
    protected Properties extendElasticsearchPropes;
    protected String httpPool;
    protected String elasticUser;
    protected String elasticPassword;
    protected long healthCheckInterval = -1L;
    protected boolean failAllContinue = true;
    protected RestSearchExecutor restSeachExecutor;
    protected boolean showTemplate = false;
    protected FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy.MM.dd", (TimeZone)TimeZone.getTimeZone("Etc/UTC"));
    protected Integer slowDslThreshold;
    protected String dateFormat = "yyyy.MM.dd";
    protected String dayDateFormat = "yyyy.MM.dd";
    protected String monthDateFormat = "yyyy.MM";
    protected String yearDateFormat = "yyyy";
    protected TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
    protected LogDslCallback slowDslCallback;
    protected LogDslCallback logDslCallback;
    protected ElasticSearch elasticSearch;
    private Map clusterInfo;
    private String esVersion;
    private String distribution;
    private boolean v1;
    private boolean lower5;
    private boolean upper7;
    private int version;
    private boolean upper8;
    private String clusterVersionInfo;
    private String clusterVarcharInfo;
    private final Map<String, ESAddress> addressMap = new HashMap<String, ESAddress>();
    public static final String _xpack6_sql_restapi = "/_xpack/sql";
    public static final String _xpack8_sql_restapi = "/_sql";
    private String sqlRestapi = "/_sql";
    private String healthPool;
    private String discoverPool;
    private boolean closed = false;

    public boolean isFailAllContinue() {
        return this.failAllContinue;
    }

    public String getDayDateFormat() {
        return this.dayDateFormat;
    }

    public String getMonthDateFormat() {
        return this.monthDateFormat;
    }

    public String getYearDateFormat() {
        return this.yearDateFormat;
    }

    public String getElasticsearchName() {
        return this.elasticSearch.getElasticSearchName();
    }

    @Override
    public ElasticSearch getElasticSearch() {
        return this.elasticSearch;
    }

    public boolean isIncludeTypeName() {
        return this.elasticSearch.isIncludeTypeName();
    }

    @Override
    public Integer slowDslThreshold() {
        return this.slowDslThreshold;
    }

    @Override
    public LogDslCallback getSlowDslCallback() {
        return this.slowDslCallback;
    }

    @Override
    public LogDslCallback getLogDslCallback() {
        return this.logDslCallback;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLower5() {
        return this.lower5;
    }

    public void setLower5(boolean lower5) {
        this.lower5 = lower5;
    }

    public boolean isUpper7() {
        return this.upper7;
    }

    public void setUpper7(boolean upper7) {
        this.upper7 = upper7;
    }

    public Map<String, ESAddress> getAddressMap() {
        return this.addressMap;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isUpper8() {
        return this.upper8;
    }

    public ElasticSearchRestClient(ElasticSearch elasticSearch, String[] hostNames, String elasticUser, String elasticPassword, Properties extendElasticsearchPropes) {
        this.extendElasticsearchPropes = extendElasticsearchPropes;
        this.elasticSearch = elasticSearch;
        this.elasticUser = elasticUser;
        this.elasticPassword = elasticPassword;
    }

    private void initVersionInfo() {
        try {
            this.getElasticSearch().getRestClientUtil().discover("/", "get", new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (ResponseUtil.isHttpStatusOK((int)status)) {
                        HttpEntity entity = response.getEntity();
                        ElasticSearchRestClient.this.clusterVarcharInfo = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                        if (logger.isInfoEnabled()) {
                            logger.info("Elasticsearch Server Info:\n" + ElasticSearchRestClient.this.clusterVarcharInfo);
                        }
                        ElasticSearchRestClient.this.clusterInfo = (Map)SimpleStringUtil.json2Object((String)ElasticSearchRestClient.this.clusterVarcharInfo, Map.class);
                        Object version = ElasticSearchRestClient.this.clusterInfo.get("version");
                        if (version instanceof Map) {
                            Map vinfo = (Map)version;
                            String _esVersion = String.valueOf(vinfo.get("number"));
                            if (vinfo.get("distribution") != null) {
                                String _distribution = String.valueOf(vinfo.get("distribution"));
                                ElasticSearchRestClient.this.distribution = _distribution;
                            }
                            if (_esVersion != null && !_esVersion.equals("")) {
                                ElasticSearchRestClient.this.esVersion = _esVersion;
                            }
                            ElasticSearchRestClient.this.clusterVersionInfo = "clusterName:" + ElasticSearchRestClient.this.clusterInfo.get("cluster_name") + ",version:" + ElasticSearchRestClient.this.esVersion;
                        } else {
                            ElasticSearchRestClient.this.clusterVersionInfo = "clusterName:" + ElasticSearchRestClient.this.clusterInfo.get("cluster_name") + ",version:" + version;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.warn("Init Elasticsearch Cluster Version Information failed:", (Throwable)e);
        }
        if (this.esVersion != null) {
            if (this.distribution != null && this.distribution.toLowerCase().indexOf("opensearch") >= 0) {
                this.version = 7;
                this.upper7 = true;
            } else {
                int idx = this.esVersion.indexOf(".");
                if (idx > 0) {
                    String max = this.esVersion.substring(0, idx);
                    try {
                        int v;
                        this.version = v = Integer.parseInt(max);
                        if (v == 1) {
                            this.v1 = true;
                        }
                        if (v >= 8) {
                            this.upper8 = true;
                        }
                        if (v >= 7) {
                            this.upper7 = true;
                        }
                        if (v < 5) {
                            this.lower5 = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public String getHealthPool() {
        return this.healthPool;
    }

    public String getSqlRestapi() {
        return this.sqlRestapi;
    }

    public boolean healthCheckEnabled() {
        return this.healthCheckInterval > 0L;
    }

    @Override
    public void init() {
        this.healthPool = this.discoverPool = ClientConfiguration.getHealthPoolName((String)this.httpPool);
        this.restSeachExecutor = new RestSearchExecutor(this.httpPool, this.discoverPool, this);
        this.initVersionInfo();
    }

    @Override
    public void configure(Properties elasticsearchPropes) {
        String version_;
        String _logDslCallback;
        String _sqlRestapi;
        String _slowDslThreshold;
        String dateFormatString = elasticsearchPropes.getProperty("elasticsearch.dateFormat");
        String timeZoneString = elasticsearchPropes.getProperty("elasticsearch.timeZone");
        String showTemplate_ = elasticsearchPropes.getProperty("elasticsearch.showTemplate");
        String httpPool = elasticsearchPropes.getProperty("elasticsearch.httpPool");
        if (httpPool == null || httpPool.equals("")) {
            httpPool = "default";
        }
        this.httpPool = httpPool;
        if (showTemplate_ != null && showTemplate_.equals("true")) {
            this.showTemplate = true;
        }
        if (SimpleStringUtil.isEmpty((String)dateFormatString)) {
            dateFormatString = "yyyy.MM.dd";
        }
        if (SimpleStringUtil.isEmpty((String)timeZoneString)) {
            timeZoneString = "";
        }
        this.dateFormat = dateFormatString;
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.fastDateFormat = FastDateFormat.getInstance((String)dateFormatString, (TimeZone)TimeZone.getTimeZone(timeZoneString));
        String healthCheckInterval_ = elasticsearchPropes.getProperty("elasticsearch.healthCheckInterval");
        if (healthCheckInterval_ == null) {
            this.healthCheckInterval = 3000L;
        } else {
            try {
                this.healthCheckInterval = Long.parseLong(healthCheckInterval_);
            }
            catch (Exception e) {
                logger.error("Parse Long healthCheckInterval parameter failed:" + healthCheckInterval_, (Throwable)e);
            }
        }
        String failAllContinue_ = elasticsearchPropes.getProperty("elasticsearch.failAllContinue");
        if (failAllContinue_ != null && failAllContinue_.equals("false")) {
            this.failAllContinue = false;
        }
        if ((_slowDslThreshold = elasticsearchPropes.getProperty("elasticsearch.slowDslThreshold")) != null) {
            try {
                this.slowDslThreshold = Integer.parseInt(_slowDslThreshold);
            }
            catch (Exception e) {
                logger.error("Parse Long slowDslThreshold parameter failed:" + _slowDslThreshold, (Throwable)e);
            }
        }
        if ((_sqlRestapi = elasticsearchPropes.getProperty("elasticsearch.sqlRestapi")) != null && !_sqlRestapi.equals("")) {
            this.sqlRestapi = _sqlRestapi;
        }
        if ((_logDslCallback = elasticsearchPropes.getProperty("elasticsearch.logDslCallback")) != null) {
            try {
                this.logDslCallback = (LogDslCallback)Class.forName(_logDslCallback).newInstance();
            }
            catch (Exception e) {
                logger.error("Parse logDslCallback parameter failed:" + _logDslCallback, (Throwable)e);
            }
            catch (Throwable e) {
                logger.error("Parse logDslCallback parameter failed:" + _logDslCallback, e);
            }
        }
        if (this.slowDslThreshold != null && this.slowDslThreshold > 0) {
            String _slowDslCallback = elasticsearchPropes.getProperty("elasticsearch.slowDslCallback");
            if (_slowDslCallback != null) {
                try {
                    this.slowDslCallback = (LogDslCallback)Class.forName(_slowDslCallback).newInstance();
                }
                catch (Exception e) {
                    logger.error("Parse slowDslCallback parameter failed:" + _slowDslCallback, (Throwable)e);
                }
                catch (Throwable e) {
                    logger.error("Parse slowDslCallback parameter failed:" + _slowDslCallback, e);
                }
            } else {
                this.slowDslCallback = new DefaultSlowDslCallback();
            }
        }
        this.esVersion = (version_ = elasticsearchPropes.getProperty("elasticsearch.version")) != null && !version_.equals("") ? version_ : "7.0.0";
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ClientConfiguration.stopHttpClient((String)this.httpPool);
    }

    private ElasticSearchException handleConnectionPoolTimeOutException(String url, ConnectionPoolTimeoutException ex) {
        ClientConfiguration configuration = ClientConfiguration.getClientConfiguration((String)this.httpPool);
        if (configuration == null) {
            return new ElasticSearchException((Throwable)ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(url).append(" Wait Connection timeout for ").append(configuration.getConnectionRequestTimeout()).append("ms for idle http connection from http connection pool.");
        return new ElasticSearchException(builder.toString(), (Throwable)ex);
    }

    private NoServerElasticSearchException handleConnectionTimeOutException(String url, ConnectTimeoutException ex) {
        ClientConfiguration configuration = ClientConfiguration.getClientConfiguration((String)this.httpPool);
        if (configuration == null) {
            return new NoServerElasticSearchException(url, (Throwable)ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(url).append(" http connection timeout for ").append(configuration.getTimeoutConnection()).append("ms.");
        return new NoServerElasticSearchException(builder.toString(), (Throwable)ex);
    }

    private ElasticSearchException handleSocketTimeoutException(String url, SocketTimeoutException ex) {
        ClientConfiguration configuration = ClientConfiguration.getClientConfiguration((String)this.httpPool);
        if (configuration == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(url).append(" handle Socket Timeout ");
            return new ElasticSearchException(builder.toString(), ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(url).append(" handle Socket Timeout for ").append(configuration.getTimeoutSocket()).append("ms.");
        return new ElasticSearchException(builder.toString(), ex);
    }

    public String execute(final String entity, String options) throws ElasticSearchException {
        String endpoint = BULK_ENDPOINT;
        if (options != null) {
            endpoint = endpoint + "?" + options;
        }
        final ESStringResponseHandler responseHandler = new ESStringResponseHandler();
        if (this.showTemplate && logger.isInfoEnabled()) {
            responseHandler.setExecuteIntercepter(new ExecuteIntercepter(){

                public void before(String url, URLResponseHandler urlResponseHandler, int triesCount) {
                    logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                }

                public void after(String url, URLResponseHandler urlResponseHandler, int triesCount, Object response, Throwable e) {
                }
            });
        }
        return (String)this._executeHttp(endpoint, (ResponseHandler)responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(String url) throws Exception {
                String response = null;
                response = ElasticSearchRestClient.this.restSeachExecutor.execute(url, entity, responseHandler);
                return response;
            }
        });
    }

    @Override
    public ClientUtil getClientUtil(IndexNameBuilder indexNameBuilder) {
        return new RestClientUtil(this, indexNameBuilder);
    }

    @Override
    public ClientUtil getConfigClientUtil(IndexNameBuilder indexNameBuilder, String configFile) {
        return new ConfigRestClientUtil(this, indexNameBuilder, configFile);
    }

    @Override
    public ClientUtil getConfigClientUtil(IndexNameBuilder indexNameBuilder, BaseTemplateContainerImpl templateContainer) {
        return new ConfigRestClientUtil(templateContainer, this, indexNameBuilder);
    }

    public String executeHttp(String path, String action) throws ElasticSearchException {
        return this.executeHttp(path, null, action);
    }

    public <T> T executeHttp(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeHttp(path, null, action, responseHandler);
    }

    public <T> T discover(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.discover(path, null, action, responseHandler);
    }

    private String getPath(String host, String path) {
        String url = path.equals("") || path.startsWith("/") ? host + path : host + "/" + path;
        return url;
    }

    public <T> T executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this._executeHttp(path, entity, action, responseHandler, false);
    }

    private <T> T _executeHttp(String path, final String entity, final String action, final ResponseHandler<T> responseHandler, final boolean discoverHost) throws ElasticSearchException {
        if (this.showTemplate && !discoverHost && logger.isInfoEnabled()) {
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setExecuteIntercepter(new ExecuteIntercepter(){

                    public void before(String url, URLResponseHandler urlResponseHandler, int triesCount) {
                        if (entity != null) {
                            logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                        } else {
                            logger.info("ElasticSearch http request endpoint:{},retry:{}", (Object)url, (Object)triesCount);
                        }
                    }

                    public void after(String url, URLResponseHandler urlResponseHandler, int triesCount, Object response, Throwable e) {
                    }
                });
            } else if (entity != null) {
                logger.info("ElasticSearch http request endpoint:{},request body:\n{}", (Object)path, (Object)entity);
            } else {
                logger.info("ElasticSearch http request endpoint:{}", (Object)path);
            }
        }
        return this._executeHttp(path, responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(String url) throws Exception {
                Object response = null;
                response = !discoverHost ? ElasticSearchRestClient.this.restSeachExecutor.executeHttp(url, entity, action, responseHandler) : ElasticSearchRestClient.this.restSeachExecutor.discoverHost(url, entity, action, responseHandler);
                return response;
            }
        });
    }

    private <T> T _executeHttp(String path, ResponseHandler<T> responseHandler, ExecuteRequest executeRequest) throws ElasticSearchException {
        Object response = null;
        Throwable e = null;
        try {
            response = executeRequest.execute(path);
        }
        catch (Exception ex) {
            e = ex;
        }
        catch (Throwable ex) {
            e = ex;
        }
        if (e != null) {
            if (e instanceof HttpProxyRequestException) {
                HttpProxyRequestException httpProxyRequestException = (HttpProxyRequestException)e;
                Throwable httpResponseStatusException = httpProxyRequestException.getHttpResponseStatusException();
                if (httpResponseStatusException != null && httpResponseStatusException instanceof ElasticSearchException) {
                    throw (ElasticSearchException)httpResponseStatusException;
                }
                Throwable throwable = httpProxyRequestException.getCause();
                if (throwable != null && throwable instanceof ElasticSearchException) {
                    throw (ElasticSearchException)throwable;
                }
            } else if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e);
        }
        return (T)response;
    }

    public <T> T discover(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this._executeHttp(path, entity, action, responseHandler, true);
    }

    public String executeHttp(String path, String entity, String action) throws ElasticSearchException {
        return (String)this.executeHttp(path, entity, action, (ResponseHandler)new ESStringResponseHandler());
    }

    public String executeRequest(String path, final String entity) throws ElasticSearchException {
        final ESStringResponseHandler responseHandler = new ESStringResponseHandler();
        if (this.showTemplate && logger.isInfoEnabled()) {
            responseHandler.setExecuteIntercepter(new ExecuteIntercepter(){

                public void before(String url, URLResponseHandler urlResponseHandler, int triesCount) {
                    if (entity != null) {
                        logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                    } else {
                        logger.info("ElasticSearch http request endpoint:{},retry:{}", (Object)url, (Object)triesCount);
                    }
                }

                public void after(String url, URLResponseHandler urlResponseHandler, int triesCount, Object response, Throwable e) {
                }
            });
        }
        return (String)this._executeHttp(path, (ResponseHandler)responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(String url) throws Exception {
                String response = null;
                response = ElasticSearchRestClient.this.restSeachExecutor.executeSimpleRequest(url, entity, responseHandler);
                return response;
            }
        });
    }

    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.executeRequest(path, entity, responseHandler, "post");
    }

    public static Exception getException(ResponseHandler responseHandler) {
        if (responseHandler instanceof BaseExceptionResponseHandler) {
            return ((BaseExceptionResponseHandler)responseHandler).getElasticSearchException();
        }
        return null;
    }

    public <T> T executeRequest(String path, final String entity, final ResponseHandler<T> responseHandler, final String action) throws ElasticSearchException {
        if (this.showTemplate && logger.isInfoEnabled()) {
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                ((URLResponseHandler)responseHandler).setExecuteIntercepter(new ExecuteIntercepter(){

                    public void before(String url, URLResponseHandler urlResponseHandler, int triesCount) {
                        if (entity != null) {
                            logger.info("ElasticSearch http request endpoint:{},retry:{},request body:\n{}", new Object[]{url, triesCount, entity});
                        } else {
                            logger.info("ElasticSearch http request endpoint:{},retry:{}", (Object)url, (Object)triesCount);
                        }
                    }

                    public void after(String url, URLResponseHandler urlResponseHandler, int triesCount, Object response, Throwable e) {
                    }
                });
            } else if (entity != null) {
                logger.info("ElasticSearch http request endpoint:{},request body:\n{}", (Object)path, (Object)entity);
            } else {
                logger.info("ElasticSearch http request endpoint:{}", (Object)path);
            }
        }
        return this._executeHttp(path, responseHandler, new ExecuteRequest(){

            @Override
            public Object execute(String url) throws Exception {
                Object response = null;
                response = ElasticSearchRestClient.this.restSeachExecutor.executeRequest(url, entity, action, responseHandler);
                return response;
            }
        });
    }

    public String getDistribution() {
        return this.distribution;
    }

    public FastDateFormat getFastDateFormat() {
        return this.fastDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isShowTemplate() {
        return this.showTemplate;
    }

    @Override
    public void setShowTemplate(boolean showTemplate) {
        this.showTemplate = showTemplate;
    }

    @Override
    public Map getClusterInfo() {
        return this.clusterInfo;
    }

    @Override
    public String getClusterVarcharInfo() {
        return this.clusterVarcharInfo;
    }

    @Override
    public String getClusterVersionInfo() {
        return this.clusterVersionInfo;
    }

    public ExecutorService getSliceScrollQueryExecutorService() {
        return this.elasticSearch.getSliceScrollQueryExecutorService();
    }

    public ExecutorService getScrollQueryExecutorService() {
        return this.elasticSearch.getScrollQueryExecutorService();
    }

    @Override
    public boolean isV1() {
        return this.v1;
    }

    public String getEsVersion() {
        return this.esVersion;
    }

    public void setEsVersion(String esVersion) {
        this.esVersion = esVersion;
    }

    public String getDiscoverPool() {
        return this.discoverPool;
    }

    private static interface ExecuteRequest {
        public Object execute(String var1) throws Exception;
    }
}

