/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.ArrayList;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.spi.remote.http.HttpHost;
import org.frameworkset.spi.remote.http.proxy.HttpProxyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDiscoverUtil {
    private static Logger logger = LoggerFactory.getLogger(HostDiscoverUtil.class);

    public static synchronized void handleDiscoverHosts(String[] hosts) {
        HostDiscoverUtil.handleDiscoverHosts(hosts, "default");
    }

    public static synchronized void handleDiscoverHosts(String[] hosts, String elasticsearch) {
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>();
        HttpHost httpHost = null;
        if (hosts != null && hosts.length > 0) {
            for (String host : hosts) {
                httpHost = new HttpHost(host);
                httpHosts.add(httpHost);
            }
        }
        HttpProxyUtil.handleDiscoverHosts((String)elasticsearch, httpHosts);
    }

    public static synchronized void swithShowdsl(boolean showdsl) {
        HostDiscoverUtil.swithShowdsl(showdsl, "default");
    }

    public static synchronized void swithShowdsl(boolean showdsl, String elasticsearch) {
        ElasticSearch elasticSearch = ElasticSearchHelper.getElasticSearchSink(elasticsearch);
        if (elasticSearch == null) {
            throw new IllegalArgumentException("elasticSearch[" + elasticsearch + "] is null.");
        }
        ElasticSearchClient elasticSearchRestClient = elasticSearch.getRestClient();
        elasticSearchRestClient.setShowTemplate(showdsl);
    }
}

