/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.handler.ESExceptionWrapper;
import org.frameworkset.spi.remote.http.BaseResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExceptionResponseHandler<T>
extends BaseResponseHandler<T>
implements ESExceptionWrapper {
    protected ElasticSearchException elasticSearchException;
    protected static Logger _logger = LoggerFactory.getLogger(BaseExceptionResponseHandler.class);

    @Override
    public ElasticSearchException getElasticSearchException() {
        return this.elasticSearchException;
    }

    public void clean() {
        this.elasticSearchException = null;
    }

    protected Object handleException(String url, HttpEntity entity, int status) throws IOException {
        return this.handleException(url, entity, status, null);
    }

    private void trucateData(StringBuilder builder) {
        if (this.isTruncateLogBody() && this.requestBody != null && this.requestBody.length() > 4096) {
            builder.append(this.requestBody.substring(0, 4095)).append("......");
        } else {
            builder.append(this.requestBody);
        }
    }

    protected Object handleException(String url, HttpEntity entity, int status, String charSet) throws IOException {
        if (status == 404) {
            if (entity != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Request url:" + url + ",status:" + status);
                }
                StringBuilder msg = new StringBuilder();
                if (charSet == null) {
                    msg.append("Request url:").append(url);
                    msg.append("\r\nResponseBody:").append(EntityUtils.toString((HttpEntity)entity));
                    this.elasticSearchException = new ElasticSearchException(msg.toString(), status);
                } else {
                    msg.append("Request url:").append(url);
                    msg.append("\r\nResponseBody:").append(EntityUtils.toString((HttpEntity)entity, (String)charSet));
                    this.elasticSearchException = new ElasticSearchException(msg.toString(), status);
                }
            } else {
                this.elasticSearchException = new ElasticSearchException("Request url:" + url + ",Unexpected response status: " + status, status);
            }
            return null;
        }
        if (!this.isEnableSetRequestBody()) {
            if (entity != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Request url:" + url + ",status:" + status);
                }
                StringBuilder msg = new StringBuilder();
                if (charSet == null) {
                    msg.append("Request url:").append(url);
                    msg.append("\r\nResponseBody:").append(EntityUtils.toString((HttpEntity)entity));
                    throw new ElasticSearchException(msg.toString(), status);
                }
                msg.append("Request url:").append(url);
                msg.append("\r\nResponseBody:").append(EntityUtils.toString((HttpEntity)entity, (String)charSet));
                throw new ElasticSearchException(msg.toString(), status);
            }
            throw new ElasticSearchException("Request url:" + url + ",Unexpected response status: " + status, status);
        }
        StringBuilder msg = new StringBuilder();
        if (entity != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Request url:" + url + ",status:" + status);
            }
            if (charSet == null) {
                msg.append("Request url:").append(url);
                msg.append("\r\nRequestBody:");
                this.trucateData(msg);
                msg.append("\r\nResponseBody:").append(EntityUtils.toString((HttpEntity)entity));
            } else {
                msg.append("Request url:").append(url);
                msg.append("\r\nRequestBody:");
                this.trucateData(msg);
                msg.append("\r\nResponseBody:").append(EntityUtils.toString((HttpEntity)entity, (String)charSet));
            }
        } else {
            msg.append("Request url:").append(url).append(",Unexpected response status: ").append(status);
            msg.append("\r\nRequestBody:");
            this.trucateData(msg);
        }
        throw new ElasticSearchException(msg.toString(), status);
    }
}

