/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.handler.BaseExceptionResponseHandler;
import org.frameworkset.elasticsearch.handler.ESExceptionWrapper;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.URLResponseHandler;

public class ESStringResponseHandler
extends BaseExceptionResponseHandler<String>
implements URLResponseHandler<String>,
ESExceptionWrapper {
    private String charSet;

    public ESStringResponseHandler() {
    }

    public ESStringResponseHandler(String charSet) {
        this.charSet = charSet;
    }

    public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = this.initStatus(response);
        if (ResponseUtil.isHttpStatusOK((int)status)) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (this.charSet == null) {
                    return EntityUtils.toString((HttpEntity)entity);
                }
                return EntityUtils.toString((HttpEntity)entity, (String)this.charSet);
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        return (String)this.handleException(this.url, entity, status, this.charSet);
    }
}

