/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.navigation.drawer;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.customview.widget.ViewDragHelper;
import androidx.drawerlayout.widget.DrawerLayout;
import com.bihe0832.android.common.navigation.drawer.R;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.framework.ui.BaseFragment;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.DisplayUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public abstract class NavigationDrawerFragment
extends BaseFragment {
    private static final String PREF_USER_LEARNED_DRAWER = "navigation_drawer_learned";
    protected DrawerLayout mDrawerLayout;
    protected View mFragmentContainerView;
    protected boolean mFromSavedInstanceState;
    protected boolean mUserLearnedDrawer;

    protected void parseBundle(@NotNull Bundle bundle, boolean isOnCreate) {
        super.parseBundle(bundle, isOnCreate);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this.getActivity());
        this.mUserLearnedDrawer = sp.getBoolean(PREF_USER_LEARNED_DRAWER, false);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public boolean isDrawerOpen() {
        return this.mDrawerLayout != null && this.mDrawerLayout.isDrawerOpen(this.mFragmentContainerView);
    }

    public void setUp(View fragmentContainerView, DrawerLayout drawerLayout) {
        this.mDrawerLayout = drawerLayout;
        this.mFragmentContainerView = fragmentContainerView;
        this.mDrawerLayout.setDrawerShadow(R.drawable.com_bihe0832_drawer_shadow, 0x800003);
        this.mDrawerLayout.setStatusBarBackgroundColor(0);
        this.mDrawerLayout.addDrawerListener(new DrawerLayout.DrawerListener(){

            public void onDrawerSlide(@NonNull View drawerView, float slideOffset) {
            }

            public void onDrawerOpened(@NonNull View drawerView) {
                NavigationDrawerFragment.this.setUserVisibleHint(true);
                NavigationDrawerFragment.this.setChildUserVisibleHint(true);
            }

            public void onDrawerClosed(@NonNull View drawerView) {
                NavigationDrawerFragment.this.setUserVisibleHint(false);
                NavigationDrawerFragment.this.setChildUserVisibleHint(false);
            }

            public void onDrawerStateChanged(int newState) {
            }
        });
        this.setDrawerLeftEdgeSize();
    }

    public void openDrawer() {
        if (!this.mUserLearnedDrawer && !this.mFromSavedInstanceState) {
            this.mDrawerLayout.openDrawer(this.mFragmentContainerView);
        }
    }

    public void closeDrawer() {
        if (this.mDrawerLayout != null && this.mFragmentContainerView != null) {
            this.mDrawerLayout.closeDrawer(this.mFragmentContainerView);
        }
    }

    public void enableDrawerGesture() {
        if (this.mDrawerLayout != null && this.mFragmentContainerView != null) {
            this.mDrawerLayout.setDrawerLockMode(0);
        }
    }

    public void disableDrawerGesture() {
        if (this.mDrawerLayout != null && this.mFragmentContainerView != null) {
            this.mDrawerLayout.setDrawerLockMode(1);
        }
    }

    private void setDrawerLeftEdgeSize() {
        try {
            Field viewDragHelper = this.mDrawerLayout.getClass().getDeclaredField("mLeftDragger");
            viewDragHelper.setAccessible(true);
            ViewDragHelper leftDragger = (ViewDragHelper)viewDragHelper.get(this.mDrawerLayout);
            Field edgeSizeField = leftDragger.getClass().getDeclaredField("mEdgeSize");
            edgeSizeField.setAccessible(true);
            int edgeSize = edgeSizeField.getInt(leftDragger);
            int screenWidth = DisplayUtil.getRealScreenSizeX((Context)ZixieContext.INSTANCE.getApplicationContext());
            edgeSizeField.setInt(leftDragger, Math.max(edgeSize, screenWidth));
            Field leftCallbackField = this.mDrawerLayout.getClass().getDeclaredField("mLeftCallback");
            leftCallbackField.setAccessible(true);
            ViewDragHelper.Callback leftCallback = (ViewDragHelper.Callback)leftCallbackField.get(this.mDrawerLayout);
            Field peekRunnableField = leftCallback.getClass().getDeclaredField("mPeekRunnable");
            peekRunnableField.setAccessible(true);
            Runnable nullRb = new Runnable(){

                @Override
                public void run() {
                }
            };
            peekRunnableField.set(leftCallback, nullRb);
        }
        catch (Exception e) {
            ZLog.e((String)("setDrawerLeftEdgeSize failed:" + e.getMessage()));
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
    }

    public void onDetach() {
        super.onDetach();
    }
}

