/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassArray;
import com.caucho.bytecode.JClassLoaderWrapper;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class JClassLoader {
    protected static final Logger log = Logger.getLogger(JClassLoader.class.getName());
    private static JClassLoaderWrapper _staticClassLoader;
    private static final HashMap<String, JClass> _staticClassMap;
    private final HashMap<String, SoftReference<JClass>> _classMap = new HashMap();

    public JClass forName(String name) {
        JClass jClass;
        SoftReference<JClass> jClassRef = this._classMap.get(name);
        JClass jClass2 = jClass = jClassRef != null ? jClassRef.get() : null;
        if (jClass == null) {
            jClass = _staticClassMap.get(name);
            if (jClass == null) {
                if (name.startsWith("[")) {
                    JClass subClass = this.descriptorToClass(name, 1);
                    jClass = new JClassArray(subClass);
                } else {
                    jClass = this.loadClass(name);
                }
            }
            this._classMap.put(name, new SoftReference<JClass>(jClass));
        }
        return jClass;
    }

    public void close() {
        this._classMap.clear();
    }

    public static JClass systemForName(String name) {
        return JClassLoader.getSystemClassLoader().forName(name);
    }

    static JClassLoader getSystemClassLoader() {
        if (_staticClassLoader == null) {
            _staticClassLoader = JClassLoaderWrapper.create(ClassLoader.getSystemClassLoader());
        }
        return _staticClassLoader;
    }

    public static JClass localForName(String name) {
        JClassLoaderWrapper jLoader = JClassLoaderWrapper.create();
        return jLoader.forName(name);
    }

    protected abstract JClass loadClass(String var1);

    public static JClassLoader getStaticClassLoader() {
        return JClassLoader.getSystemClassLoader();
    }

    public JClass descriptorToClass(String name, int i) {
        switch (name.charAt(i)) {
            case 'V': {
                return this.forName("void");
            }
            case 'Z': {
                return this.forName("boolean");
            }
            case 'C': {
                return this.forName("char");
            }
            case 'B': {
                return this.forName("byte");
            }
            case 'S': {
                return this.forName("short");
            }
            case 'I': {
                return this.forName("int");
            }
            case 'J': {
                return this.forName("long");
            }
            case 'F': {
                return this.forName("float");
            }
            case 'D': {
                return this.forName("double");
            }
            case '[': {
                return this.forName(name.substring(i));
            }
            case 'L': {
                int tail = name.indexOf(59, i);
                if (tail < 0) {
                    throw new IllegalStateException(name);
                }
                String className = name.substring(i + 1, tail).replace('/', '.');
                return this.forName(className);
            }
        }
        throw new UnsupportedOperationException(name.substring(i));
    }

    public String toString() {
        return "JClassLoader[]";
    }

    static {
        _staticClassMap = new HashMap();
        _staticClassMap.put("void", JClass.VOID);
        _staticClassMap.put("boolean", JClass.BOOLEAN);
        _staticClassMap.put("byte", JClass.BYTE);
        _staticClassMap.put("short", JClass.SHORT);
        _staticClassMap.put("int", JClass.INT);
        _staticClassMap.put("long", JClass.LONG);
        _staticClassMap.put("float", JClass.FLOAT);
        _staticClassMap.put("double", JClass.DOUBLE);
        _staticClassMap.put("char", JClass.CHAR);
        _staticClassMap.put("java.lang.String", JClass.STRING);
        _staticClassMap.put("java.lang.Object", JClass.OBJECT);
    }
}

