/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.SerializeHandle;
import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.gen.CandiAspectBeanFactory;
import com.caucho.config.gen.CandiEnhancedBean;
import com.caucho.config.gen.LifecycleAspectBeanFactory;
import com.caucho.config.inject.HandleAware;
import com.caucho.config.inject.InjectManager;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class CandiBeanGenerator<X>
extends BeanGenerator<X> {
    private static final L10N L = new L10N(CandiBeanGenerator.class);
    private AnnotatedType<X> _beanClass;
    private AspectBeanFactory<X> _aspectFactory;
    private AspectBeanFactory<X> _lifecycleAspectFactory;
    private ArrayList<AspectGenerator<X>> _businessMethods = new ArrayList();
    private boolean _isEnhanced;
    private boolean _hasReadResolve;
    private boolean _isSingleton;
    private boolean _isSerializeHandle;

    public CandiBeanGenerator(InjectManager manager, AnnotatedType<X> beanClass) {
        super(beanClass.getJavaClass().getName() + "__ResinWebBean", beanClass);
        this.setSuperClassName(beanClass.getJavaClass().getName());
        if (beanClass.isAnnotationPresent(SerializeHandle.class)) {
            this._isSerializeHandle = true;
            this.addInterfaceName(Serializable.class.getName());
            this.addInterfaceName(HandleAware.class.getName());
        }
        this.addInterfaceName(CandiEnhancedBean.class.getName());
        this.addImport("javax.transaction.*");
        this._beanClass = beanClass;
        this._aspectFactory = new CandiAspectBeanFactory<X>(manager, beanClass);
        this._lifecycleAspectFactory = new LifecycleAspectBeanFactory<X>(this._aspectFactory, manager, beanClass);
    }

    public void setSingleton(boolean isSingleton) {
        this._isSingleton = isSingleton;
    }

    public ArrayList<AspectGenerator<X>> getBusinessMethods() {
        return this._businessMethods;
    }

    @Override
    public AspectBeanFactory<X> getLifecycleAspectFactory() {
        return this._lifecycleAspectFactory;
    }

    @Override
    public void introspect() {
        super.introspect();
        this.introspectClass(this._beanClass);
        AspectFactory<X> aspectHeadFactory = this._aspectFactory.getHeadAspectFactory();
        ArrayList<AnnotatedMethod> unenhancedMethods = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod method : this._beanClass.getMethods()) {
            Method javaMethod = method.getJavaMember();
            if (Object.class.equals((Object)method.getBaseType())) continue;
            if (javaMethod.getName().equals("readResolve") && javaMethod.getParameterTypes().length == 0) {
                this._hasReadResolve = true;
            }
            int modifiers = method.getJavaMember().getModifiers();
            if (method.isStatic()) continue;
            if (method.isAnnotationPresent(PostConstruct.class) || method.isAnnotationPresent(PreDestroy.class)) {
                AspectGenerator<X> bizMethod = this._lifecycleAspectFactory.create(method);
                this._businessMethods.add(bizMethod);
                continue;
            }
            if (Modifier.isPrivate(modifiers)) continue;
            boolean isEnhance = false;
            AspectGenerator<X> bizMethod = aspectHeadFactory.create(method, isEnhance);
            if (bizMethod == null) {
                unenhancedMethods.add(method);
                continue;
            }
            if (this._businessMethods.contains(bizMethod)) continue;
            if (method.isStatic()) {
                throw new ConfigException(L.l("{0}: Java Injection annotations are not allowed on static methods.", (Object)bizMethod));
            }
            if (Modifier.isFinal(modifiers)) {
                throw new ConfigException(L.l("{0}: Java Injection annotations are not allowed on final methods.", (Object)bizMethod));
            }
            this._isEnhanced = true;
            this._businessMethods.add(bizMethod);
        }
        if (Serializable.class.isAssignableFrom(this._beanClass.getJavaClass()) && !this._hasReadResolve && this.hasTransientInject(this._beanClass.getJavaClass())) {
            this._isEnhanced = true;
        }
        if (this._aspectFactory.isEnhanced()) {
            this._isEnhanced = true;
        }
        if (this._isEnhanced) {
            for (AnnotatedMethod method : unenhancedMethods) {
                AspectGenerator<X> bizMethod = aspectHeadFactory.create(method, true);
                if (this._businessMethods.contains(bizMethod)) continue;
                this._businessMethods.add(bizMethod);
            }
        }
    }

    protected void introspectClass(AnnotatedType<X> cl) {
    }

    private boolean hasTransientInject(Class<?> cl) {
        if (cl == null || Object.class.equals(cl)) {
            return false;
        }
        for (Field field : cl.getDeclaredFields()) {
            Annotation[] annList;
            if (!Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || (annList = field.getDeclaredAnnotations()) == null) continue;
            for (Annotation ann : annList) {
                if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                return true;
            }
        }
        return this.hasTransientInject(cl.getSuperclass());
    }

    @Override
    public String getViewClassName() {
        return this.getFullClassName();
    }

    @Override
    public ArrayList<AspectGenerator<X>> getMethods() {
        return this.getBusinessMethods();
    }

    public Class<?> generateClass() {
        boolean isPackageLoader;
        if (!this.isEnhanced()) {
            return this._beanClass.getJavaClass();
        }
        Class baseClass = this._beanClass.getJavaClass();
        int modifiers = baseClass.getModifiers();
        ClassLoader baseClassLoader = baseClass.getClassLoader();
        boolean bl = isPackageLoader = baseClassLoader != null && baseClassLoader instanceof DynamicClassLoader;
        if (Modifier.isFinal(modifiers)) {
            throw new IllegalStateException(L.l("'{0}' is an invalid enhanced class because it is final.", (Object)baseClass.getName()));
        }
        try {
            Method getException;
            RuntimeException exn;
            JavaClassGenerator gen = new JavaClassGenerator();
            Class<?> cl = isPackageLoader ? gen.preloadClassParentLoader(this.getFullClassName(), baseClass) : gen.preload(this.getFullClassName());
            if (cl == null) {
                gen.generate(this);
                gen.compilePendingJava();
                cl = isPackageLoader ? gen.loadClassParentLoader(this.getFullClassName(), baseClass) : gen.loadClass(this.getFullClassName());
            }
            if ((exn = (RuntimeException)(getException = cl.getMethod("__caucho_getException", new Class[0])).invoke(null, new Object[0])) != null) {
                throw exn;
            }
            return cl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isEnhanced() {
        return this._isEnhanced;
    }

    @Override
    protected void generateClassContent(JavaWriter out) throws IOException {
        this.generateHeader(out);
        boolean isCtor = false;
        for (Constructor<?> ctor : this._beanClass.getJavaClass().getDeclaredConstructors()) {
            if (!Modifier.isPublic(ctor.getModifiers()) && !Modifier.isProtected(ctor.getModifiers())) continue;
            this.generateConstructor(out, ctor);
            isCtor = true;
        }
        if (!isCtor) {
            for (Constructor<?> ctor : this._beanClass.getJavaClass().getDeclaredConstructors()) {
                if (Modifier.isPrivate(ctor.getModifiers())) continue;
                this.generateConstructor(out, ctor);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.generateBeanPrologue(out, map);
        this.generateBusinessMethods(out, map);
        this.generateEpilogue(out, map);
        this.generateInject(out, map);
        this.generateDelegate(out, map);
        this.generatePostConstruct(out, map);
        this.generateWriteReplace(out);
        this.generateDestroy(out, map);
    }

    protected void generateHeader(JavaWriter out) throws IOException {
        this.generateClassStaticFields(out);
        out.println("private static final boolean __caucho_isFiner");
        out.println("  = __caucho_log.isLoggable(java.util.logging.Level.FINER);");
        out.println("private " + this.getBeanClassName() + " _bean;");
        if (this._isSerializeHandle) {
            this.generateSerializeHandle(out);
        } else {
            this.generateSerialize(out);
        }
    }

    protected void generateSerializeHandle(JavaWriter out) throws IOException {
        out.println();
        out.println("private transient Object _serializationHandle;");
        out.println();
        out.println("public void setSerializationHandle(Object handle)");
        out.println("{");
        out.println("  _serializationHandle = handle;");
        out.println("}");
        this.generateSerialize(out, "_serializationHandle");
    }

    protected void generateSerialize(JavaWriter out) throws IOException {
        this.generateSerialize(out, "_bean");
    }

    protected void generateSerialize(JavaWriter out, String var) throws IOException {
        if (!this.findWriteReplace(this._beanClass.getJavaClass())) {
            out.println();
            out.println("private Object writeReplace()");
            out.println("{");
            out.println("  return " + var + ";");
            out.println("}");
        }
    }

    protected void generateReadResolve(JavaWriter out) throws IOException {
        out.println();
        out.println("private Object readResolve()");
        out.println("{");
        out.println("  return this;");
        out.println("}");
    }

    protected void generateWriteReplace(JavaWriter out) throws IOException {
        if (this._isSingleton && !this.findWriteReplace(this._beanClass.getJavaClass())) {
            out.println("private transient Object __caucho_handle;");
            out.println();
            out.println("private Object writeReplace()");
            out.println("{");
            out.println("  return __caucho_handle;");
            out.println("}");
        }
    }

    protected boolean findWriteReplace(Class<?> cl) {
        if (cl == null || Object.class.equals(cl)) {
            return false;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.getName().equals("writeReplace") || method.getParameterTypes().length != 0) continue;
            return true;
        }
        return this.findWriteReplace(cl.getSuperclass());
    }

    protected void generateConstructor(JavaWriter out, Constructor<?> ctor) throws IOException {
        int i;
        Class<?>[] paramTypes = ctor.getParameterTypes();
        out.print("public " + this.getClassName() + "(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(paramTypes[i]);
            out.print(" a" + i);
        }
        out.println(")");
        this.generateThrows(out, ctor.getExceptionTypes());
        out.println("{");
        out.pushDepth();
        out.print("super(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("a" + i);
        }
        out.println(");");
        out.print("_bean = new " + this.getBeanClassName() + "(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("a" + i);
        }
        out.println(");");
        out.println();
        out.println("if (__caucho_exception != null)");
        out.println("  throw __caucho_exception;");
        this.generateBeanConstructor(out);
        this.generateProxyConstructor(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateThrows(JavaWriter out, Class<?>[] exnCls) throws IOException {
        if (exnCls.length == 0) {
            return;
        }
        out.print(" throws ");
        for (int i = 0; i < exnCls.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(exnCls[i]);
        }
    }

    @Override
    protected AspectBeanFactory<X> getAspectBeanFactory() {
        return this._aspectFactory;
    }
}

