/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.ResourceGroupConfig;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.enterprise.context.spi.CreationalContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInjectionTargetProgram
extends ConfigProgram
implements ObjectProxy {
    private static final L10N L = new L10N(ResourceInjectionTargetProgram.class);
    private ResourceGroupConfig _resourceConfig;
    private Class<?> _targetClass;
    private String _targetName;
    private Field _field;
    private Method _method;

    public ResourceInjectionTargetProgram(ResourceGroupConfig resourceConfig, Class<?> targetClass, String targetName) {
        this._resourceConfig = resourceConfig;
        this._targetClass = targetClass;
        this._targetName = targetName;
        this._field = this.findField(targetClass, targetName);
        this._method = this.findMethod(targetClass, targetName);
        if (this._method == null && this._field == null) {
            throw new ConfigException(L.l("{0}.{1} is an unknown target for {2}", (Object)targetClass.getName(), (Object)targetName, (Object)resourceConfig));
        }
    }

    public Class<?> getTargetClass() {
        return this._targetClass;
    }

    public String getTargetName() {
        return this._targetName;
    }

    private Method findMethod(Class<?> targetClass, String targetMethod) {
        for (Method method : targetClass.getMethods()) {
            if (!method.getName().equals(targetMethod) || method.getParameterTypes().length != 1) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private Field findField(Class<?> targetClass, String targetField) {
        for (Field field : targetClass.getDeclaredFields()) {
            if (!field.getName().equals(targetField)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) {
        Object value = this._resourceConfig.getValue();
        if (value == null) {
            return;
        }
        if (this._field != null) {
            try {
                this._field.set(bean, value);
            }
            catch (Exception e) {
                throw new ConfigException(L.l("{0}.{1} cannot be assigned the value {2}", (Object)this._field.getDeclaringClass(), (Object)this._field.getName(), value), e);
            }
        }
        try {
            this._method.invoke(bean, value);
        }
        catch (Exception e) {
            throw new ConfigException(L.l("{0}.{1} cannot be assigned the value {2}", (Object)this._method.getDeclaringClass(), (Object)this._method.getName(), value), e);
        }
    }

    @Override
    public Object createObject(Hashtable<?, ?> env) throws NamingException {
        Object value = this._resourceConfig.getValue();
        if (value == null) {
            throw new ConfigException(L.l("Null value returned from {0}", (Object)this._resourceConfig));
        }
        return value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._targetClass.getSimpleName() + ", " + this._targetName + ", " + this._resourceConfig + "]";
    }
}

