/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.scope;

import com.caucho.config.inject.HandleAware;
import com.caucho.config.inject.SingletonHandle;
import com.caucho.config.scope.AbstractScopeContext;
import com.caucho.config.scope.ContextContainer;
import com.caucho.config.scope.DestructionListener;
import com.caucho.inject.Module;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class SingletonScope
extends AbstractScopeContext {
    private WeakReference<ClassLoader> _loader;
    private ContextContainer _context = new ContextContainer();

    public SingletonScope() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this._loader = new WeakReference<ClassLoader>(loader);
        Environment.addCloseListener(this._context);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    @Override
    protected ContextContainer getContextContainer() {
        return this._context;
    }

    @Override
    protected ContextContainer createContextContainer() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T create(Contextual<T> bean, CreationalContext<T> env) {
        T instance;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        ClassLoader loader = (ClassLoader)this._loader.get();
        try {
            if (loader != null) {
                thread.setContextClassLoader(loader);
            }
            instance = super.create(bean, env);
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        if (instance instanceof HandleAware && bean instanceof PassivationCapable) {
            HandleAware handleAware = (HandleAware)instance;
            PassivationCapable passiveBean = (PassivationCapable)bean;
            handleAware.setSerializationHandle(new SingletonHandle(passiveBean.getId()));
        }
        return instance;
    }

    public <T> void addDestructor(Contextual<T> comp, T value) {
        EnvironmentClassLoader loader = Environment.getEnvironmentClassLoader();
        if (loader != null) {
            DestructionListener listener = (DestructionListener)loader.getAttribute("caucho.destroy");
            if (listener == null) {
                listener = new DestructionListener();
                loader.setAttribute("caucho.destroy", listener);
                loader.addListener(listener);
            }
            listener.addValue(comp, value);
        }
    }
}

