/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;

public final class BytePrimitiveType
extends ConfigType {
    private static final L10N L = new L10N(BytePrimitiveType.class);
    public static final BytePrimitiveType TYPE = new BytePrimitiveType();
    private static final Byte ZERO = new Byte(0);

    private BytePrimitiveType() {
    }

    public Class getType() {
        return Byte.TYPE;
    }

    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return ZERO;
        }
        return Byte.valueOf(text);
    }

    public Object valueOf(Object value) {
        if (value instanceof Byte) {
            return value;
        }
        if (value == null) {
            return ZERO;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to a byte", value));
    }
}

