/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;

public class AnnotationBuilder {
    private static L10N L = new L10N(AnnotationBuilder.class);
    private String _signature;
    private String _className;
    private String[] _parameterTypes;
    private Annotation _annotation;

    public String getSignature() {
        return this._signature;
    }

    public void addText(String value) {
        this._signature = value;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._signature == null) {
            throw new ConfigException(L.l("Annotation requires a constructor syntax"));
        }
        this.parseSignature();
    }

    private void parseSignature() throws ConfigException {
        int p = this._signature.indexOf(40);
        String className = p > 0 ? this._signature.substring(0, p) : this._signature;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            this._annotation = (Annotation)cl.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Object replaceObject() {
        return this._annotation;
    }

    public String toString() {
        return "AnnotationBuilder[" + this._signature + "]";
    }
}

