/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.type.AnnotationInterfaceType;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfig
implements InvocationHandler {
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private static final Method TO_STRING;
    private static final Method ANNOTATION_TYPE;
    private AnnotationInterfaceType _configType;
    private Class<?> _annotationType;
    private HashMap<String, Object> _valueMap = new HashMap(8);

    public AnnotationConfig(Class<?> annotationType) {
        this((AnnotationInterfaceType)TypeFactory.getType(annotationType), annotationType);
    }

    public AnnotationConfig(AnnotationInterfaceType configType, Class<?> annotationType) {
        this._configType = configType;
        this._annotationType = annotationType;
    }

    public ConfigType<?> getConfigType() {
        return this._configType;
    }

    public void setAttribute(String name, Object value) {
        Object oldValue;
        if ("#text".equals(name)) {
            name = "value";
        }
        if ((oldValue = this._valueMap.get(name)) != null && oldValue.getClass().isArray() && value != null && oldValue.getClass() == value.getClass()) {
            Object[] oldArray = (Object[])oldValue;
            Object[] valueArray = (Object[])value;
            Class<?> componentType = oldValue.getClass().getComponentType();
            value = Array.newInstance(componentType, oldArray.length + valueArray.length);
            System.arraycopy(oldArray, 0, value, 0, oldArray.length);
            System.arraycopy(valueArray, 0, value, oldArray.length, valueArray.length);
        }
        this._valueMap.put(name, value);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (ANNOTATION_TYPE.equals(method)) {
            return this._annotationType;
        }
        if (TO_STRING.equals(method)) {
            return this._configType.toString(this._valueMap);
        }
        if (EQUALS.equals(method)) {
            return this.equalsImpl(args[0]);
        }
        if (HASH_CODE.equals(method)) {
            return this._annotationType.hashCode();
        }
        if (args == null || args.length == 0) {
            Object value = this._valueMap.get(method.getName());
            if (value != null) {
                return value;
            }
            if (Annotation.class.isAssignableFrom(method.getDeclaringClass())) {
                return method.getDefaultValue();
            }
        }
        throw new IllegalArgumentException("AnnotationProxy: " + method.toString());
    }

    private boolean equalsImpl(Object o) {
        if (o == null) {
            return false;
        }
        return this._annotationType.equals(o.getClass());
    }

    public Annotation replace() {
        ClassLoader loader = this._annotationType.getClassLoader();
        return (Annotation)Proxy.newProxyInstance(loader, new Class[]{this._annotationType}, (InvocationHandler)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._annotationType + "]";
    }

    static {
        Method equals = null;
        Method hashCode = null;
        Method toString = null;
        Method annotationType = null;
        try {
            equals = Object.class.getMethod("equals", Object.class);
            hashCode = Object.class.getMethod("hashCode", new Class[0]);
            toString = Object.class.getMethod("toString", new Class[0]);
            annotationType = Annotation.class.getMethod("annotationType", new Class[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        EQUALS = equals;
        HASH_CODE = hashCode;
        TO_STRING = toString;
        ANNOTATION_TYPE = annotationType;
    }
}

