/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;

public class PathPatternType {
    static final L10N L = new L10N(PathPatternType.class);
    static final Logger log = Logger.getLogger(PathPatternType.class.getName());
    private String _prefix;
    private Pattern _pattern;

    public PathPatternType() {
    }

    public PathPatternType(String pattern) throws ConfigException, PatternSyntaxException {
        this.setName(pattern);
    }

    public PathPatternType(String prefix, String pattern) throws ConfigException, PatternSyntaxException {
        this.setPrefix(prefix);
        this.setName(pattern);
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setName(String pattern) throws ConfigException, PatternSyntaxException {
        int i;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        int length = pattern.length();
        for (i = 0; i < length && pattern.charAt(i) == '/'; ++i) {
        }
        while (i < length) {
            char ch = pattern.charAt(i);
            if (ch == '/') {
                cb.append('/');
            } else if (ch == '.') {
                cb.append("\\.");
            } else if (ch != '*') {
                cb.append(ch);
            } else if (length <= i + 1 || pattern.charAt(i + 1) != '*') {
                cb.append("[^/]*");
            } else {
                if (i > 0 && pattern.charAt(i - 1) != '/') {
                    throw new ConfigException(L.l("'{0}' is an invalid pattern at '**'", (Object)pattern));
                }
                if (i + 2 < length && pattern.charAt(i + 2) == '/') {
                    cb.append("([^/]*/)*");
                    i += 2;
                } else {
                    if (i + 2 < length) {
                        throw new ConfigException(L.l("'{0}' is an invalid pattern at '**'", (Object)pattern));
                    }
                    cb.append(".*");
                    ++i;
                }
            }
            ++i;
        }
        cb.append("$");
        this._pattern = Pattern.compile(cb.toString());
    }

    public void addText(String text) throws ConfigException, PatternSyntaxException {
        if (!(text = text.trim()).equals("")) {
            this.setName(text);
        }
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._pattern == null) {
            throw new ConfigException(L.l("pattern requires 'name' attribute."));
        }
    }

    public boolean isValidPrefix(String path) {
        if (this._prefix == null) {
            return true;
        }
        return path.startsWith(this._prefix);
    }

    public boolean isMatch(String path) {
        return this._pattern.matcher(path).matches();
    }

    public String toString() {
        return "PathPatternType[" + this._pattern.pattern() + "]";
    }
}

