/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.config.inject.InjectManager;
import com.caucho.el.EL;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentLevelELResolver
extends ELResolver {
    private static final EnvironmentLocal<EnvironmentLevelELResolver> _local = new EnvironmentLocal();
    private final ClassLoader _loader;
    private final ELResolver _beanResolver;

    private EnvironmentLevelELResolver(ClassLoader loader) {
        this._loader = loader;
        if (Environment.getEnvironmentClassLoader(loader) != null) {
            InjectManager beanManager = InjectManager.create(loader);
            this._beanResolver = beanManager.getELResolver();
        } else {
            this._beanResolver = null;
        }
    }

    public static EnvironmentLevelELResolver create() {
        return EnvironmentLevelELResolver.create(Thread.currentThread().getContextClassLoader());
    }

    public static EnvironmentLevelELResolver create(ClassLoader loader) {
        EnvironmentLevelELResolver elResolver = _local.getLevel(loader);
        if (elResolver == null) {
            while (loader != null) {
                if (loader instanceof EnvironmentClassLoader) {
                    elResolver = new EnvironmentLevelELResolver(loader);
                    _local.set(elResolver, loader);
                    return elResolver;
                }
                loader = loader.getParent();
            }
            loader = ClassLoader.getSystemClassLoader();
            elResolver = new EnvironmentLevelELResolver(loader);
            _local.set(elResolver, loader);
        }
        return elResolver;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (property != null || !(base instanceof String)) {
            return true;
        }
        context.setPropertyResolved(true);
        return false;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        Object value = this.getValue(context, base, property);
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Object getValue(ELContext env, Object base, Object property) {
        Object value;
        if (base != null) {
            return null;
        }
        if (!(property instanceof String)) {
            return null;
        }
        String var = (String)property;
        if (this._beanResolver != null && (value = this._beanResolver.getValue(env, base, property)) != null) {
            env.setPropertyResolved(true);
            return value;
        }
        value = EL.getLevelVar(var, this._loader);
        if (value == null) {
            return null;
        }
        env.setPropertyResolved(true);
        if (value == EL.NULL) {
            return null;
        }
        return value;
    }

    public void setValue(ELContext env, Object base, Object property, Object value) {
        if (base != null || !(property instanceof String)) {
            return;
        }
        env.setPropertyResolved(true);
        String name = (String)property;
        EL.putVar(name, value, this._loader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnvironmentLevelELResolver)) {
            return false;
        }
        EnvironmentLevelELResolver resolver = (EnvironmentLevelELResolver)((Object)o);
        return this._loader == resolver._loader;
    }

    public String toString() {
        return "EnvironmentLevelELResolver[" + this._loader + "]";
    }
}

