/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.health;

import com.caucho.env.health.HealthStatus;
import com.caucho.env.health.HealthStatusListener;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.util.L10N;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HealthStatusService
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 1;
    private static final Logger log = Logger.getLogger(HealthStatusService.class.getName());
    private static final L10N L = new L10N(HealthStatusService.class);
    private List<HealthStatusListener> _listeners = new CopyOnWriteArrayList<HealthStatusListener>();

    private HealthStatusService() {
    }

    public static HealthStatusService createAndAddService() {
        ResinSystem system = HealthStatusService.preCreate(HealthStatusService.class);
        HealthStatusService service = new HealthStatusService();
        system.addService(HealthStatusService.class, service);
        return service;
    }

    public static HealthStatusService getCurrent() {
        return ResinSystem.getCurrentService(HealthStatusService.class);
    }

    public void updateHealthStatus(Object source, HealthStatus status, String message) {
        for (HealthStatusListener listener : this._listeners) {
            listener.updateHealthStatus(source, status, message);
        }
        if (log.isLoggable(Level.FINE)) {
            String msg = L.l("Health status {0} from {1}: {2}", (Object)status, (Object)source.getClass().getSimpleName(), (Object)message);
            log.log(Level.FINE, msg);
        }
    }

    public static void updateCurrentHealthStatus(Object source, HealthStatus status, String message) {
        HealthStatusService service = HealthStatusService.getCurrent();
        if (service != null) {
            service.updateHealthStatus(source, status, message);
        } else {
            String msg = L.l("Health status {0} from {1}: {2}", (Object)status, (Object)source.getClass().getSimpleName(), (Object)message);
            log.warning(msg);
        }
    }

    public void addHealthStatusListener(HealthStatusListener listener) {
        this._listeners.add(listener);
    }

    public int getStartPriority() {
        return 1;
    }
}

