/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.jdbc;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseFactory {
    private static final Logger log = Logger.getLogger(DatabaseFactory.class.getName());
    private static final Class<?> _databaseFactoryClass;
    private String _name;
    private Class<?> _driverClass;
    private String _url;
    private String _user;
    private String _password;
    public String _databaseName;

    public static DatabaseFactory createBuilder() {
        try {
            return (DatabaseFactory)_databaseFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setDriverClass(Class<?> driverClass) {
        this._driverClass = driverClass;
    }

    public Class<?> getDriverClass() {
        return this._driverClass;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getUser() {
        return this._user;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setDatabaseName(String databaseName) {
        this._databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public abstract DataSource create();

    static {
        Class<?> factoryClass = null;
        try {
            String className = DatabaseFactory.class.getName() + "Impl";
            factoryClass = Class.forName(className);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        _databaseFactoryClass = factoryClass;
    }
}

