/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.AverageSensor;
import com.caucho.env.meter.TotalMeter;
import java.util.concurrent.atomic.AtomicLong;

public final class AverageMeter
extends TotalMeter
implements AverageSensor {
    private final double _scale;
    private final Object _lock = new Object();
    private final AtomicLong _count = new AtomicLong();
    private final AtomicLong _sum = new AtomicLong();
    private final AtomicLong _max = new AtomicLong();
    private double _sumSquare;
    private long _lastCount;
    private long _lastAvgCount;
    private long _lastAvgSum;
    private long _lastStdCount;
    private double _lastStdSum;
    private double _value;

    public AverageMeter(String name) {
        super(name);
        this._scale = 1.0;
    }

    public TotalMeter createCount(String name) {
        return new AverageCountProbe(name);
    }

    public AbstractMeter createMax(String name) {
        return new MaxProbe(name);
    }

    public AbstractMeter createSigma(String name, int n) {
        return new SigmaProbe(name, n);
    }

    public final void add(long value) {
        long max;
        double sqValue = value * value;
        this._count.incrementAndGet();
        this._sum.addAndGet(value);
        this._sumSquare += sqValue;
        while ((max = this._max.get()) < value && !this._max.compareAndSet(max, value)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sample() {
        Object object = this._lock;
        synchronized (object) {
            long count = this._count.get();
            long lastCount = this._lastAvgCount;
            this._lastAvgCount = count;
            long sum = this._sum.get();
            double lastSum = this._lastAvgSum;
            this._lastAvgSum = sum;
            this._value = count == lastCount ? 0.0 : this._scale * ((double)sum - lastSum) / (double)(count - lastCount);
        }
    }

    public final double calculate() {
        return this._value;
    }

    public double getTotal() {
        return this._sum.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double sampleCount() {
        Object object = this._lock;
        synchronized (object) {
            long count = this._count.get();
            long lastCount = this._lastCount;
            this._lastCount = count;
            return count - lastCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double sampleSigma(int n) {
        Object object = this._lock;
        synchronized (object) {
            long count = this._count.get();
            long lastCount = this._lastStdCount;
            this._lastStdCount = count;
            double sum = this._sum.get();
            double lastSum = this._lastStdSum;
            this._lastStdSum = sum;
            double sumSquare = this._sumSquare;
            this._sumSquare = 0.0;
            if (count == lastCount) {
                return 0.0;
            }
            double avg = (sum - lastSum) / (double)(count - lastCount);
            double part = (double)(count - lastCount) * sumSquare - sum * sum;
            if (part < 0.0) {
                part = 0.0;
            }
            double std = Math.sqrt(part) / (double)(count - lastCount);
            return this._scale * (avg + (double)n * std);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double sampleMax() {
        Object object = this._lock;
        synchronized (object) {
            long max = this._max.getAndSet(0L);
            return this._scale * (double)max;
        }
    }

    class SigmaProbe
    extends AbstractMeter {
        private final int _n;
        private double _value;

        SigmaProbe(String name, int n) {
            super(name);
            this._n = n;
        }

        public void sample() {
            this._value = AverageMeter.this.sampleSigma(this._n);
        }

        public double calculate() {
            return this._value;
        }
    }

    class MaxProbe
    extends AbstractMeter {
        private double _value;

        MaxProbe(String name) {
            super(name);
        }

        public void sample() {
            this._value = AverageMeter.this.sampleMax();
        }

        public double calculate() {
            return this._value;
        }
    }

    class AverageCountProbe
    extends TotalMeter {
        private double _value;

        AverageCountProbe(String name) {
            super(name);
        }

        public void sample() {
            this._value = AverageMeter.this.sampleCount();
        }

        public double calculate() {
            return this._value;
        }

        public double getTotal() {
            return AverageMeter.this._count.get();
        }
    }
}

