/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.i18n;

import com.caucho.config.ConfigException;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import javax.annotation.PostConstruct;

public class CharacterEncoding {
    private static final L10N L = new L10N(CharacterEncoding.class);
    private static final EnvironmentLocal<String> _localEncoding = new EnvironmentLocal();
    private static final String _systemEncoding;
    private String _encoding;

    public void setValue(String name) {
        this._encoding = Encoding.getMimeName(name);
    }

    public static String getLocalEncoding() {
        String encoding = _localEncoding.get();
        if (encoding != null) {
            return encoding;
        }
        return _systemEncoding;
    }

    @PostConstruct
    public void init() throws Exception {
        if (this._encoding == null) {
            throw new ConfigException(L.l("character-encoding requires a 'value' attribute with the character encoding."));
        }
        _localEncoding.set(this._encoding);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._encoding + "]";
    }

    static {
        String encoding = System.getProperty("file.encoding");
        encoding = encoding != null ? Encoding.getMimeName(encoding) : "utf-8";
        _systemEncoding = encoding;
    }
}

