/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

class JobThread
implements Runnable {
    private static final L10N L = new L10N(JobThread.class);
    private static final Logger log = Logger.getLogger(JobThread.class.getName());
    private static JobThread _job = new JobThread();
    private ArrayList<Job> _jobs = new ArrayList();
    private ArrayList<Job> _runJobs = new ArrayList();

    private JobThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(TimerTask task, long time) {
        ArrayList<Job> arrayList = JobThread._job._jobs;
        synchronized (arrayList) {
            ArrayList<Job> jobs = JobThread._job._jobs;
            for (int i = jobs.size() - 1; i >= 0; --i) {
                Job oldJob = jobs.get(i);
                if (oldJob.getTask() != task) continue;
                if (time < oldJob.getTime()) {
                    oldJob.setTime(time);
                }
                return;
            }
            Job job = new Job(task);
            job.setTime(time);
            JobThread._job._jobs.add(job);
        }
    }

    public static void dequeue(TimerTask job) {
        _job.remove(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TimerTask task) {
        ArrayList<Job> arrayList = this._jobs;
        synchronized (arrayList) {
            for (int i = this._jobs.size() - 1; i >= 0; --i) {
                Job job = this._jobs.get(i);
                if (job.getTask() != task) continue;
                this._jobs.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (true) {
            long now = CurrentTime.getCurrentTime();
            this._runJobs.clear();
            ArrayList<Job> arrayList = this._jobs;
            synchronized (arrayList) {
                for (int i = this._jobs.size() - 1; i >= 0; --i) {
                    Job job = this._jobs.get(i);
                    if (job.getTime() > now) continue;
                    this._runJobs.add(job);
                    this._jobs.remove(i);
                }
            }
            for (int i = this._runJobs.size() - 1; i >= 0; --i) {
                Job job = this._runJobs.get(i);
                try {
                    job.run();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
            }
        }
    }

    static {
        try {
            Thread thread = new Thread((Runnable)_job, "jmx-job-thread");
            thread.setDaemon(true);
            thread.start();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    static class Job
    implements ClassLoaderListener {
        private TimerTask _task;
        private ClassLoader _loader;
        private long _time;
        private boolean _isDead;

        Job(TimerTask task) {
            this._task = task;
            this._loader = Thread.currentThread().getContextClassLoader();
            Environment.addClassLoaderListener(this);
        }

        public TimerTask getTask() {
            return this._task;
        }

        public void setTime(long time) {
            this._time = time;
        }

        public long getTime() {
            return this._time;
        }

        public void classLoaderInit(DynamicClassLoader loader) {
        }

        public void classLoaderDestroy(DynamicClassLoader loader) {
            this._isDead = true;
            JobThread.dequeue(this._task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this._isDead) {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(this._loader);
                    this._task.run();
                    Object var4_3 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
        }
    }
}

