/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class MBeanHandle
implements Serializable {
    private static final Logger log = Logger.getLogger(MBeanHandle.class.getName());
    private static SoftReference<MBeanServer> _globalMBeanServer;
    private final ObjectName _name;

    public MBeanHandle(ObjectName name) {
        this._name = name;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            MBeanServer server = MBeanHandle.getMBeanServer();
            ObjectInstance instance = server.getObjectInstance(this._name);
            String className = instance.getClassName();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            return MBeanServerInvocationHandler.newProxyInstance(server, this._name, cl, false);
        }
        catch (ObjectStreamException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
            throw new InvalidObjectException(e.toString());
        }
    }

    private static MBeanServer getMBeanServer() throws ObjectStreamException {
        MBeanServer server = null;
        if (_globalMBeanServer != null) {
            server = _globalMBeanServer.get();
        }
        if (server != null) {
            return server;
        }
        try {
            InitialContext ic = new InitialContext();
            server = (MBeanServer)ic.lookup("java:comp/env/jmx/GlobalMBeanServer");
            if (server != null) {
                _globalMBeanServer = new SoftReference<MBeanServer>(server);
                return server;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            Class<?> cl = Class.forName("java.lang.Management.ManagementFactory");
            Method method = cl.getMethod("getPlatformMBeanServer", new Class[0]);
            server = (MBeanServer)method.invoke(null, new Object[0]);
            if (server != null) {
                _globalMBeanServer = new SoftReference<MBeanServer>(server);
                return server;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        log.warning("Can't load global mbean server for proxy deserialization.");
        throw new NotActiveException("Can't load global mbean server for proxy deserialization.");
    }
}

