/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.MBeanContext;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerDelegateMBean;

class MBeanServerImpl
extends AbstractMBeanServer {
    private static final L10N L = new L10N(MBeanServerImpl.class);
    private static final Logger log = Logger.getLogger(MBeanServerImpl.class.getName());
    private MBeanContext _context;

    public MBeanServerImpl(String domain, MBeanServerDelegate delegate) {
        super(domain);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        MBeanContext globalContext = null;
        MBeanContext context = new MBeanContext(this, loader, delegate, globalContext);
        if (context != this._context) {
            throw new IllegalStateException();
        }
        try {
            IntrospectionMBean mbean = new IntrospectionMBean(delegate, MBeanServerDelegateMBean.class);
            this.registerMBean(mbean, SERVER_DELEGATE_NAME);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected MBeanContext createContext(ClassLoader loader) {
        return this._context;
    }

    protected MBeanContext getCurrentContext(ClassLoader loader) {
        return this._context;
    }

    protected void setCurrentContext(MBeanContext context, ClassLoader loader) {
        if (this._context != null) {
            throw new IllegalStateException(L.l("MBeanServerImpl cannot reassign the server"));
        }
        this._context = context;
    }

    protected MBeanContext getContext(ClassLoader loader) {
        return this._context;
    }
}

