/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.Units;
import com.caucho.management.server.ManagedObjectMXBean;
import java.util.Date;

@Description(value="A pool of reusable connections to a database")
public interface ConnectionPoolMXBean
extends ManagedObjectMXBean {
    @Description(value="The configured maximum number of connections")
    public int getMaxConnections();

    @Description(value="The configured maximum number of overflow connections")
    public int getMaxOverflowConnections();

    @Description(value="The configured maximum number of simultaneous connection creation")
    public int getMaxCreateConnections();

    @Units(value="milliseconds")
    @Description(value="The configured maximum time in milliseconds that a connection remains in the idle pool before it is closed")
    public long getMaxIdleTime();

    @Description(value="The configured maximum number of idle connections")
    public int getMaxIdleCount();

    @Description(value="The configured minimum number of idle connections")
    public int getMinIdleCount();

    @Description(value="The configured maximum time in milliseconds that a connection is allowed to be active")
    @Units(value="milliseconds")
    public long getMaxActiveTime();

    @Description(value="The configured maximum age in milliseconds of a connection before it is closed regardless of it's usage pattern")
    @Units(value="milliseconds")
    public long getMaxPoolTime();

    @Units(value="milliseconds")
    @Description(value="The configured maximum time in milliseconds to wait for a connection before a failure is returned to the client")
    public long getConnectionWaitTime();

    public boolean isShareable();

    public boolean isLocalTransactionOptimization();

    @Description(value="The current number of idle and active connections")
    public int getConnectionCount();

    @Description(value="The current number of active connections")
    public int getConnectionActiveCount();

    @Description(value="The current number of idle connections")
    public int getConnectionIdleCount();

    @Description(value="The number of creatingconnections")
    public int getConnectionCreateCount();

    @Description(value="The current number of connections")
    public long getConnectionCountTotal();

    @Description(value="The current number of created connections")
    public long getConnectionCreateCountTotal();

    @Description(value="The current number of failed connections")
    public long getConnectionFailCountTotal();

    @Description(value="The last time of connection failure")
    public Date getLastFailTime();

    @Description(value="Clear idle connections in the pool")
    public void clear();
}

