/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.naming.AbstractModel;
import com.caucho.naming.EnvironmentModelRoot;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class EnvironmentModel
extends AbstractModel {
    private static final L10N L = new L10N(EnvironmentModel.class);
    private final EnvironmentModelRoot _root;
    private String _name;
    private ConcurrentHashMap<String, Object> _children = new ConcurrentHashMap(8);

    EnvironmentModel(EnvironmentModelRoot root, String name) {
        this._root = root;
        this._name = name;
    }

    protected AbstractModel create() {
        return new EnvironmentModel(this._root, this._name);
    }

    public Object lookup(String name) throws NamingException {
        EnvironmentModel parentModel;
        Object value = this._children.get(name);
        if (value != null) {
            return value;
        }
        ClassLoader loader = this._root.getClassLoader();
        if (loader == null) {
            return null;
        }
        EnvironmentModelRoot parentRoot = EnvironmentModelRoot.getCurrent(loader.getParent());
        if (parentRoot != null && (parentModel = parentRoot.get(this._name)) != null && (value = parentModel.lookup(name)) instanceof EnvironmentModel) {
            value = this.createSubcontextImpl(name);
        }
        return value;
    }

    public void bind(String name, Object obj) throws NamingException {
        this._children.put(name, obj);
    }

    public void unbind(String name) throws NamingException {
        Object oldValue = this._children.remove(name);
        if (oldValue == null) {
            throw new NameNotFoundException(name);
        }
        if (oldValue instanceof EnvironmentModel) {
            this._root.remove(this._name + "/" + name);
        }
    }

    public AbstractModel createSubcontext(String name) throws NamingException {
        if (this._children.get(name) != null) {
            throw new NamingException(L.l("can't create subcontext: {0} {1}", (Object)name, this._children.get(name)));
        }
        return this.createSubcontextImpl(name);
    }

    private AbstractModel createSubcontextImpl(String name) {
        String childName = this._name.equals("") ? name : this._name + "/" + name;
        EnvironmentModel model = new EnvironmentModel(this._root, childName);
        this._children.putIfAbsent(name, model);
        model = (EnvironmentModel)this._children.get(name);
        this._root.put(childName, model);
        return model;
    }

    public void rename(String newName) throws NamingException {
        this._name = newName;
        ConcurrentHashMap<String, Object> newChildren = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this._children.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            String name = newName + "/" + key;
            if (obj instanceof EnvironmentModel) {
                ((EnvironmentModel)obj).rename(name);
            }
            newChildren.put(name, obj);
        }
        this._children = newChildren;
    }

    public List list() {
        ArrayList values = new ArrayList();
        this.fillList(values);
        return values;
    }

    protected void fillList(ArrayList values) {
        EnvironmentModel parentModel;
        for (String key : this._children.keySet()) {
            if (values.contains(key)) continue;
            values.add(key);
        }
        ClassLoader loader = this._root.getClassLoader();
        if (loader == null) {
            return;
        }
        EnvironmentModelRoot parentRoot = EnvironmentModelRoot.getCurrent(loader.getParent());
        if (parentRoot != null && (parentModel = parentRoot.get(this._name)) != null) {
            parentModel.fillList(values);
        }
    }

    public String toString() {
        return "EnvironmentModel[" + this._name + "]";
    }
}

