/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.UnsetFunction;
import com.caucho.util.Crc64;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;

public final class DefinitionState {
    private static final L10N L = new L10N(DefinitionState.class);
    private final QuercusContext _quercus;
    private boolean _isStrict;
    private HashMap<StringValue, AbstractFunction> _funMap;
    private HashMap<StringValue, AbstractFunction> _lowerFunMap;
    private HashMap<String, ClassDef> _classDefMap;
    private HashMap<String, ClassDef> _lowerClassDefMap;
    private boolean _isLazy;
    private long _crc;

    public DefinitionState(QuercusContext quercus) {
        this._quercus = quercus;
        this._isStrict = quercus.isStrict();
        this._funMap = new HashMap(256, 0.25f);
        this._classDefMap = new HashMap(256, 0.25f);
        if (!this._isStrict) {
            this._lowerFunMap = new HashMap(256, 0.25f);
            this._lowerClassDefMap = new HashMap(256, 0.25f);
        }
    }

    private DefinitionState(DefinitionState oldState) {
        this(oldState._quercus);
        this._funMap.putAll(oldState._funMap);
        if (this._lowerFunMap != null) {
            this._lowerFunMap.putAll(oldState._lowerFunMap);
        }
        this._classDefMap.putAll(oldState._classDefMap);
        if (this._lowerClassDefMap != null) {
            this._lowerClassDefMap.putAll(oldState._lowerClassDefMap);
        }
        this._crc = oldState._crc;
    }

    private DefinitionState(DefinitionState oldState, boolean isLazy) {
        this._isLazy = true;
        this._quercus = oldState._quercus;
        this._isStrict = oldState._isStrict;
        this._funMap = oldState._funMap;
        this._lowerFunMap = oldState._lowerFunMap;
        this._classDefMap = oldState._classDefMap;
        this._lowerClassDefMap = oldState._lowerClassDefMap;
        this._crc = oldState._crc;
    }

    public final boolean isStrict() {
        return this._isStrict;
    }

    public QuercusContext getQuercus() {
        return this._quercus;
    }

    public long getCrc() {
        return this._crc;
    }

    public ArrayValue getDefinedFunctions() {
        ArrayValueImpl result = new ArrayValueImpl();
        ArrayValue internal = this._quercus.getDefinedFunctions();
        ArrayValueImpl user = new ArrayValueImpl();
        result.put(new StringBuilderValue("internal"), internal);
        result.put(new StringBuilderValue("user"), user);
        for (StringValue name : this._funMap.keySet()) {
            if (internal.contains(name).isset()) continue;
            ((ArrayValue)user).put(name);
        }
        return result;
    }

    public AbstractFunction findFunction(StringValue name) {
        AbstractFunction fun = this._funMap.get(name);
        if (fun != null) {
            if (fun instanceof UnsetFunction) {
                UnsetFunction unsetFun = (UnsetFunction)fun;
                if (this._crc == unsetFun.getCrc()) {
                    return null;
                }
            } else {
                return fun;
            }
        }
        if (this._lowerFunMap != null && (fun = this._lowerFunMap.get(name.toLowerCase(Locale.ENGLISH))) != null) {
            this._funMap.put(name, fun);
            return fun;
        }
        fun = this.findModuleFunction(name);
        if (fun != null) {
            this._funMap.put(name, fun);
            return fun;
        }
        this._funMap.put(name, new UnsetFunction(this._crc));
        return null;
    }

    private AbstractFunction findModuleFunction(StringValue name) {
        AbstractFunction fun = null;
        fun = this._quercus.findFunction(name);
        if (fun != null) {
            return fun;
        }
        return fun;
    }

    public Value addFunction(StringValue name, AbstractFunction fun) {
        AbstractFunction oldFun = this.findFunction(name);
        if (oldFun != null) {
            throw new QuercusException(L.l("can't redefine function {0}", (Object)name));
        }
        this.copyOnWrite();
        this._funMap.put(name, fun);
        this._crc = Crc64.generate(this._crc, name.toString());
        if (this._lowerFunMap != null) {
            this._lowerFunMap.put(name.toLowerCase(Locale.ENGLISH), fun);
        }
        return BooleanValue.TRUE;
    }

    public Value addFunction(StringValue name, StringValue lowerName, AbstractFunction fun) {
        this.copyOnWrite();
        this._funMap.put(name, fun);
        this._crc = Crc64.generate(this._crc, name.toString());
        if (this._lowerFunMap != null) {
            this._lowerFunMap.put(lowerName, fun);
        }
        return BooleanValue.TRUE;
    }

    public void addClassDef(String name, ClassDef cl) {
        this.copyOnWrite();
        this._classDefMap.put(name, cl);
        this._crc = Crc64.generate(this._crc, name);
        if (this._lowerClassDefMap != null) {
            this._lowerClassDefMap.put(name.toLowerCase(Locale.ENGLISH), cl);
        }
    }

    public ClassDef findClassDef(String name) {
        ClassDef def = this._classDefMap.get(name);
        if (def != null) {
            return def;
        }
        if (this._lowerClassDefMap != null) {
            def = this._lowerClassDefMap.get(name.toLowerCase(Locale.ENGLISH));
        }
        return def;
    }

    public Value getDeclaredClasses(Env env) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this._classDefMap.keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        for (String name : this._quercus.getClassMap().keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        Collections.sort(names);
        ArrayValueImpl array = new ArrayValueImpl();
        for (String name : names) {
            ((ArrayValue)array).put(env.createString(name));
        }
        return array;
    }

    public DefinitionState copy() {
        return new DefinitionState(this);
    }

    public DefinitionState copyLazy() {
        return new DefinitionState(this, true);
    }

    private void copyOnWrite() {
        if (!this._isLazy) {
            return;
        }
        this._isLazy = false;
        this._funMap = new HashMap<StringValue, AbstractFunction>(this._funMap);
        if (this._lowerFunMap != null) {
            this._lowerFunMap = new HashMap<StringValue, AbstractFunction>(this._lowerFunMap);
        }
        this._classDefMap = new HashMap<String, ClassDef>(this._classDefMap);
        if (this._lowerClassDefMap != null) {
            this._lowerClassDefMap = new HashMap<String, ClassDef>(this._lowerClassDefMap);
        }
    }

    static class ClassKey {
        private final WeakReference<ClassDef> _defRef;
        private final WeakReference<QuercusClass> _parentRef;

        ClassKey(ClassDef def, QuercusClass parent) {
            this._defRef = new WeakReference<ClassDef>(def);
            this._parentRef = parent != null ? new WeakReference<QuercusClass>(parent) : null;
        }

        public int hashCode() {
            int hash = 37;
            ClassDef def = (ClassDef)this._defRef.get();
            QuercusClass parent = null;
            if (this._parentRef != null) {
                parent = (QuercusClass)this._parentRef.get();
            }
            if (def != null) {
                hash = 65521 * hash + def.hashCode();
            }
            if (parent != null) {
                hash = 65521 * hash + parent.hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            ClassDef bDef;
            ClassKey key = (ClassKey)o;
            ClassDef aDef = (ClassDef)this._defRef.get();
            if (aDef != (bDef = (ClassDef)key._defRef.get())) {
                return false;
            }
            if (this._parentRef == key._parentRef) {
                return true;
            }
            if (this._parentRef != null && key._parentRef != null) {
                return this._parentRef.get() == key._parentRef.get();
            }
            return false;
        }
    }
}

