/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.inject.Module;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvVar;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class GlobalArrayValue
extends ArrayValueImpl {
    private final Env _env;

    public GlobalArrayValue(Env env) {
        this._env = env;
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public ArrayValue append(Value key, Value value) {
        this._env.setGlobalValue(key.toStringValue(), value);
        return this;
    }

    @Override
    public Value get(Value key) {
        return this._env.getGlobalValue(key.toStringValue());
    }

    @Override
    public Var getVar(Value key) {
        return this._env.getGlobalVar(key.toStringValue());
    }

    @Override
    public Value getArg(Value index, boolean isTop) {
        return this.getVar(index);
    }

    @Override
    public Value getArray(Value index) {
        Value array = this.getVar(index).toAutoArray();
        return array;
    }

    @Override
    public Value remove(Value key) {
        return this._env.unsetGlobalVar(key.toStringValue());
    }

    @Override
    public void clear() {
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public int getSize() {
        return this._env.getGlobalEnv().size();
    }

    @Override
    public Value containsKey(Value key) {
        EnvVar var = this._env.getGlobalEnv().get(key.toStringValue());
        if (var != null) {
            return var.get();
        }
        return null;
    }

    @Override
    public boolean isset(Value key) {
        return this.get(key).isset();
    }

    @Override
    public boolean keyExists(Value key) {
        EnvVar var = this._env.getGlobalEnv().get(key.toStringValue());
        return var != null;
    }

    @Override
    public void print(Env env) {
        env.print("Array");
    }

    @Override
    public Value getKeys() {
        return this.createAndFillArray().getKeys();
    }

    @Override
    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.createAndFillArray().entrySet();
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        return this.createAndFillArray().getIterator(env);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        return this.createAndFillArray().getKeyIterator(env);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        return this.createAndFillArray().getValueIterator(env);
    }

    private ArrayValue createAndFillArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<StringValue, EnvVar> entry : this._env.getGlobalEnv().entrySet()) {
            Value key = entry.getKey();
            Value val = entry.getValue().get();
            array.put(key, val);
        }
        return array;
    }
}

