/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgGetFieldValue;
import com.caucho.quercus.env.ArgRef;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.CopyObjectExtValue;
import com.caucho.quercus.env.CopyRoot;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.SerializeMap;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassField;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectExtValue
extends ObjectValue
implements Serializable {
    private MethodMap<AbstractFunction> _methodMap;
    private LinkedHashMap<StringValue, Entry> _fieldMap = new LinkedHashMap();
    private HashMap<StringValue, Entry> _protectedFieldMap;
    private boolean _isFieldInit;

    public ObjectExtValue(Env env, QuercusClass cl) {
        super(env, cl);
        this._methodMap = cl.getMethodMap();
    }

    public ObjectExtValue(Env env, ObjectExtValue copy, CopyRoot root) {
        super(env, copy.getQuercusClass());
        root.putCopy(copy, this);
        this._methodMap = copy._methodMap;
        this._isFieldInit = copy._isFieldInit;
        for (Map.Entry<StringValue, Entry> entry : copy._fieldMap.entrySet()) {
            Entry entryCopy = entry.getValue().copyTree(env, root);
            this._fieldMap.put(entry.getKey(), entryCopy);
        }
        this._incompleteObjectName = copy._incompleteObjectName;
    }

    public ObjectExtValue(Env env, IdentityHashMap<Value, Value> copyMap, ObjectExtValue copy) {
        super(env, copy.getQuercusClass());
        this._methodMap = copy._methodMap;
        this._isFieldInit = copy._isFieldInit;
        for (Map.Entry<StringValue, Entry> entry : copy._fieldMap.entrySet()) {
            Entry entryCopy = new Entry(env, copyMap, entry.getValue());
            this._fieldMap.put(entry.getKey(), entryCopy);
        }
        this._incompleteObjectName = copy._incompleteObjectName;
    }

    private void init() {
        this._fieldMap = new LinkedHashMap();
    }

    @Override
    public void setQuercusClass(QuercusClass cl) {
        super.setQuercusClass(cl);
        this._methodMap = cl.getMethodMap();
    }

    @Override
    public void initObject(Env env, QuercusClass cls) {
        this.setQuercusClass(cls);
        this._incompleteObjectName = null;
        LinkedHashMap<StringValue, Entry> existingFields = this._fieldMap;
        this._fieldMap = new LinkedHashMap();
        cls.initObject(env, this);
        for (Entry newField : existingFields.values()) {
            Entry entry = this.createEntryFromInit(newField.getKey());
            entry._value = newField._value;
        }
    }

    @Override
    public int getSize() {
        return this._fieldMap.size();
    }

    @Override
    public final Value getField(Env env, StringValue name) {
        Entry entry;
        Value returnValue = this.getFieldExt(env, name);
        if (returnValue == UnsetValue.UNSET && (entry = this._fieldMap.get(name)) != null) {
            return entry._value.toValue();
        }
        return returnValue;
    }

    @Override
    public Value getThisField(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            return entry._value.toValue();
        }
        return this.getFieldExt(env, name);
    }

    protected Value getFieldExt(Env env, StringValue name) {
        Entry e = this.getEntry(env, name);
        if (e != null && e._value != NullValue.NULL && e._value != UnsetValue.UNSET) {
            return e._value;
        }
        return this._quercusClass.getField(env, this, name);
    }

    @Override
    public Var getFieldVar(Env env, StringValue name) {
        Entry entry = this.getEntry(env, name);
        if (entry != null) {
            Value value = entry._value;
            if (value instanceof Var) {
                return (Var)value;
            }
            Var var = new Var(value);
            entry._value = var;
            return var;
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            if (value instanceof Var) {
                return (Var)value;
            }
            return new Var(value);
        }
        entry = this.createEntry(name);
        value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    @Override
    public Var getThisFieldVar(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            Value value = entry._value;
            if (value instanceof Var) {
                return (Var)value;
            }
            Var var = new Var(value);
            entry._value = var;
            return var;
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            if (value instanceof Var) {
                return (Var)value;
            }
            return new Var(value);
        }
        entry = this.createEntry(name);
        value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    @Override
    public Value getFieldArg(Env env, StringValue name, boolean isTop) {
        Entry entry = this.getEntry(env, name);
        if (entry != null) {
            Value value = entry.getValue();
            if (isTop || !value.isset()) {
                return entry.toArg();
            }
            return value;
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getThisFieldArg(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getFieldArgRef(Env env, StringValue name) {
        Entry entry = this.getEntry(env, name);
        if (entry != null) {
            return entry.toArg();
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getThisFieldArgRef(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        Value value = this.getFieldExt(env, name);
        if (value != UnsetValue.UNSET) {
            return value;
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value putField(Env env, StringValue name, Value value) {
        Value oldValue;
        Entry entry = this.getEntry(env, name);
        if (entry == null) {
            AbstractFunction fieldSet;
            oldValue = this.putFieldExt(env, name, value);
            if (oldValue != null) {
                return oldValue;
            }
            if (!this._isFieldInit && (fieldSet = this._quercusClass.getFieldSet()) != null) {
                this._isFieldInit = true;
                Value retVal = this._quercusClass.setField(env, this, name, value);
                this._isFieldInit = false;
                if (retVal != UnsetValue.UNSET) {
                    return retVal;
                }
            }
            entry = this.createEntry(name);
        }
        oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value putThisField(Env env, StringValue name, Value value) {
        Value oldValue;
        Entry entry = this.getThisEntry(name);
        if (entry == null) {
            AbstractFunction fieldSet;
            oldValue = this.putFieldExt(env, name, value);
            if (oldValue != null) {
                return oldValue;
            }
            if (!this._isFieldInit && (fieldSet = this._quercusClass.getFieldSet()) != null) {
                this._isFieldInit = true;
                Value retValue = NullValue.NULL;
                try {
                    retValue = fieldSet.callMethod(env, this._quercusClass, (Value)this, (Value)name, value);
                }
                finally {
                    this._isFieldInit = false;
                }
                return retValue;
            }
            entry = this.createEntry(name);
        }
        oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    protected Value putFieldExt(Env env, StringValue name, Value value) {
        return null;
    }

    @Override
    public void setFieldInit(boolean isInit) {
        this._isFieldInit = isInit;
    }

    @Override
    public boolean isFieldInit() {
        return this._isFieldInit;
    }

    @Override
    public void initField(Env env, StringValue name, StringValue canonicalName, Value value) {
        Entry entry = this.createEntryFromInit(name, canonicalName);
        entry._value = value;
    }

    @Override
    public void unsetField(StringValue name) {
        Value returnValue = this._quercusClass.unsetField(Env.getCurrent(), this, name);
        if (returnValue == UnsetValue.UNSET || returnValue == NullValue.NULL) {
            this._fieldMap.remove(name);
        }
    }

    @Override
    public void unsetArray(Env env, StringValue name, Value index) {
        if (this._quercusClass.getFieldGet() != null) {
            return;
        }
        Entry entry = this.createEntry(name);
        entry.toValue().remove(index);
    }

    @Override
    public void unsetThisArray(Env env, StringValue name, Value index) {
        if (this._quercusClass.getFieldGet() != null) {
            return;
        }
        Entry entry = this.createEntry(name);
        entry.toValue().remove(index);
    }

    private Entry getEntry(Env env, StringValue name) {
        QuercusClass cls;
        Entry entry = this._fieldMap.get(name);
        if (entry == null) {
            entry = this.getThisProtectedEntry(name);
        }
        if (entry == null) {
            return null;
        }
        if (entry.isPrivate() && (cls = env.getCallingClass()) != this._quercusClass) {
            return null;
        }
        return entry;
    }

    private Entry getThisEntry(StringValue name) {
        Entry entry = this._fieldMap.get(name);
        if (entry == null) {
            entry = this.getThisProtectedEntry(name);
        }
        return entry;
    }

    private Entry getThisProtectedEntry(StringValue name) {
        if (this._protectedFieldMap == null) {
            return null;
        }
        return this._protectedFieldMap.get(name);
    }

    private Entry createEntryFromInit(StringValue canonicalName) {
        StringValue name = ClassField.getOrdinaryName(canonicalName);
        return this.createEntryFromInit(name, canonicalName);
    }

    private Entry createEntryFromInit(StringValue name, StringValue canonicalName) {
        Entry entry = this._fieldMap.get(canonicalName);
        if (entry == null) {
            entry = new Entry(canonicalName);
            this._fieldMap.put(canonicalName, entry);
            if (ClassField.isProtected(canonicalName)) {
                if (this._protectedFieldMap == null) {
                    this._protectedFieldMap = new HashMap();
                }
                this._protectedFieldMap.put(name, entry);
            }
        }
        return entry;
    }

    private Entry createEntry(StringValue canonicalName) {
        Entry entry = this._fieldMap.get(canonicalName);
        if (entry == null) {
            entry = new Entry(canonicalName);
            this._fieldMap.put(canonicalName, entry);
        }
        return entry;
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getIterator(env, this);
        }
        return this.getBaseIterator(env);
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getBaseIterator(Env env) {
        return new KeyValueIterator(this._fieldMap.values().iterator());
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getKeyIterator(env, this);
        }
        return new KeyIterator(this._fieldMap.keySet().iterator());
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getValueIterator(env, this);
        }
        return new ValueIterator(this._fieldMap.values().iterator());
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, args);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1, a2);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1, a2, a3);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, (Value)this, a1, a2, a3, a4);
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethod(env, this._quercusClass, this, a1, a2, a3, a4, a5);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value[] args) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, args);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1, a2);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1, a2, a3);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, (Value)this, a1, a2, a3, a4);
    }

    @Override
    public Value callMethodRef(Env env, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._methodMap.get(methodName, hash);
        return fun.callMethodRef(env, this._quercusClass, this, a1, a2, a3, a4, a5);
    }

    @Override
    public Value getObject(Env env) {
        return this;
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return new ObjectExtValue(env, map, this);
    }

    @Override
    public Value copyTree(Env env, CopyRoot root) {
        Value copy = root.getCopy(this);
        if (copy != null) {
            return copy;
        }
        return new CopyObjectExtValue(env, this, root);
    }

    @Override
    public Value clone(Env env) {
        ObjectExtValue newObject = new ObjectExtValue(env, this._quercusClass);
        this.clone(env, newObject);
        return newObject;
    }

    protected void clone(Env env, ObjectExtValue obj) {
        this._quercusClass.initObject(env, obj);
        for (Entry entry : this._fieldMap.values()) {
            StringValue canonicalName = entry.getKey();
            Value value = entry.getValue().copy();
            obj.initField(env, canonicalName, value);
        }
    }

    @Override
    public void serialize(Env env, StringBuilder sb, SerializeMap serializeMap) {
        Integer index = serializeMap.get(this);
        if (index != null) {
            sb.append("r:");
            sb.append(index);
            sb.append(";");
            return;
        }
        serializeMap.put(this);
        serializeMap.incrementIndex();
        QuercusClass qClass = this.getQuercusClass();
        AbstractFunction fun = qClass.getSerialize();
        if (fun != null) {
            sb.append("C:");
            sb.append(this._className.length());
            sb.append(":");
            sb.append('\"');
            sb.append(this._className);
            sb.append('\"');
            sb.append(':');
            StringValue value = fun.callMethod(env, qClass, (Value)this).toStringValue(env);
            sb.append(value.length());
            sb.append(':');
            sb.append("{");
            sb.append(value);
            sb.append("}");
            return;
        }
        sb.append("O:");
        sb.append(this._className.length());
        sb.append(":\"");
        sb.append(this._className);
        sb.append("\":");
        sb.append(this.getSize());
        sb.append(":{");
        for (Entry entry : this._fieldMap.values()) {
            sb.append("s:");
            StringValue key = entry.getKey();
            int len = ((Value)key).length();
            sb.append(len);
            sb.append(':');
            sb.append('\"');
            sb.append((Object)key);
            sb.append('\"');
            sb.append(';');
            Value value = entry.getRawValue();
            value.serialize(env, sb, serializeMap);
        }
        sb.append("}");
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        if (level != 0) {
            sb.append('\n');
        }
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(this.getName());
        sb.append("::__set_state(array(\n");
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getValue();
            for (int i = 0; i < level; ++i) {
                sb.append("  ");
            }
            sb.append("   ");
            key.varExportImpl(sb, level + 1);
            sb.append(" => ");
            value.varExportImpl(sb, level + 1);
            sb.append(",\n");
        }
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append("))");
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return this.toString(env).toStringBuilder(env);
    }

    @Override
    public String toJavaString() {
        return this.toString(Env.getInstance()).toString();
    }

    @Override
    public StringValue toString(Env env) {
        AbstractFunction toString = this._quercusClass.getToString();
        if (toString != null) {
            return toString.callMethod(env, this._quercusClass, (Value)this).toStringValue();
        }
        return env.createString(this._className + "[]");
    }

    @Override
    public void print(Env env) {
        env.print(this.toString(env));
    }

    @Override
    public ArrayValue toArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            array.put(entry.getKey(), entry.getValue());
        }
        return array;
    }

    @Override
    public Value toObject(Env env) {
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public Set<? extends Map.Entry<Value, Value>> entrySet() {
        return new EntrySet();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int size = this.getSize();
        if (this.isIncompleteObject()) {
            ++size;
        }
        out.println("object(" + this.getName() + ") (" + size + ") {");
        if (this.isIncompleteObject()) {
            this.printDepth(out, 2 * (depth + 1));
            out.println("[\"__Quercus_Incomplete_Class_name\"]=>");
            this.printDepth(out, 2 * (depth + 1));
            StringValue value = env.createString(this.getIncompleteObjectName());
            value.varDump(env, out, depth + 1, valueSet);
            out.println();
        }
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Entry entry2 = (Entry)entry;
            entry2.varDumpImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.getName());
        out.print(' ');
        out.println("Object");
        this.printDepth(out, 4 * depth);
        out.println("(");
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Entry entry2 = (Entry)entry;
            entry2.printRImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 4 * depth);
        out.println(")");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._className);
        out.writeInt(this._fieldMap.size());
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        super.jsonEncode(env, context, sb);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Env env = Env.getInstance();
        String name = (String)in.readObject();
        QuercusClass cl = env.findClass(name);
        this.init();
        if (cl != null) {
            this.setQuercusClass(cl);
        } else {
            cl = env.getQuercus().getStdClass();
            this.setQuercusClass(cl);
            this.setIncompleteObjectName(name);
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.putThisField(env, (StringValue)in.readObject(), (Value)in.readObject());
        }
    }

    @Override
    public boolean issetField(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        if (entry != null && entry.isPublic()) {
            return entry._value.isset();
        }
        boolean result = this.getQuercusClass().issetField(env, this, name);
        return result;
    }

    @Override
    public boolean isFieldExists(Env env, StringValue name) {
        Entry entry = this.getThisEntry(name);
        return entry != null;
    }

    @Override
    public String toString() {
        if (CurrentTime.isTest()) {
            return this.getClass().getSimpleName() + "[" + this._className + "]";
        }
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._className + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry
    implements Map.Entry<Value, Value>,
    Comparable<Map.Entry<Value, Value>> {
        private final StringValue _key;
        private Value _value;

        public Entry(StringValue key) {
            this._key = key;
            this._value = UnsetValue.UNSET;
        }

        public Entry(StringValue key, Value value) {
            this._key = key;
            this._value = value;
        }

        public Entry(Env env, IdentityHashMap<Value, Value> map, Entry entry) {
            this._key = entry._key;
            this._value = entry._value.copy(env, map);
        }

        @Override
        public Value getValue() {
            return this._value.toValue();
        }

        public Value getRawValue() {
            return this._value;
        }

        @Override
        public StringValue getKey() {
            return this._key;
        }

        public boolean isPublic() {
            return !this.isPrivate() && !this.isProtected();
        }

        public boolean isProtected() {
            return ClassField.isProtected(this._key);
        }

        public boolean isPrivate() {
            return ClassField.isPrivate(this._key);
        }

        public Value toValue() {
            return this._value.toValue();
        }

        public Var toRefVar() {
            Var var = this._value.toLocalVarDeclAsRef();
            this._value = var;
            return var;
        }

        public Value toArgValue() {
            return this._value.toValue();
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this.toValue();
            this._value = value;
            return oldValue;
        }

        public Value toRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new ArgRef((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new ArgRef(var);
        }

        public Value toArgRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new ArgRef((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new ArgRef(var);
        }

        public Value toArg() {
            Value value = this._value;
            if (value instanceof Var) {
                return value;
            }
            Var var = new Var(this._value);
            this._value = var;
            return var;
        }

        Entry copyTree(Env env, CopyRoot root) {
            Value copy = root.getCopy(this._value);
            if (copy == null) {
                copy = this._value.copyTree(env, root);
            }
            return new Entry(this._key, copy);
        }

        @Override
        public int compareTo(Map.Entry<Value, Value> other) {
            if (other == null) {
                return 1;
            }
            StringValue thisKey = this.getKey();
            Value otherKey = other.getKey();
            if (thisKey == null) {
                return otherKey == null ? 0 : -1;
            }
            if (otherKey == null) {
                return 1;
            }
            return ((Value)thisKey).cmp(otherKey);
        }

        public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            StringValue name = ClassField.getOrdinaryName(this.getKey());
            String suffix = "";
            if (this.isProtected()) {
                suffix = ":protected";
            } else if (this.isPrivate()) {
                suffix = ":private";
            }
            this.printDepth(out, 2 * depth);
            out.println("[\"" + name + suffix + "\"]=>");
            this.printDepth(out, 2 * depth);
            this._value.varDump(env, out, depth, valueSet);
            out.println();
        }

        protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            StringValue name = ClassField.getOrdinaryName(this.getKey());
            String suffix = "";
            if (this.isProtected()) {
                suffix = ":protected";
            } else if (this.isPrivate()) {
                suffix = ":private";
            }
            this.printDepth(out, 4 * depth);
            out.print("[" + name + suffix + "] => ");
            this._value.printR(env, out, depth + 1, valueSet);
            out.println();
        }

        private void printDepth(WriteStream out, int depth) throws IOException {
            for (int i = 0; i < depth; ++i) {
                out.print(' ');
            }
        }

        public String toString() {
            return "ObjectExtValue.Entry[" + this.getKey() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyIterator
    implements Iterator<Value> {
        private final Iterator<StringValue> _iter;

        KeyIterator(Iterator<StringValue> iter) {
            this._iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        public Value next() {
            return this._iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIterator
    implements Iterator<Value> {
        private final Iterator<Entry> _iter;

        ValueIterator(Iterator<Entry> iter) {
            this._iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        public Value next() {
            return this._iter.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyValueIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private final Iterator<Entry> _iter;

        KeyValueIterator(Iterator<Entry> iter) {
            this._iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        public Map.Entry<Value, Value> next() {
            return this._iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntrySet
    extends AbstractSet<Map.Entry<Value, Value>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return ObjectExtValue.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new KeyValueIterator(ObjectExtValue.this._fieldMap.values().iterator());
        }
    }
}

