/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractMethodExpr;
import com.caucho.quercus.expr.Expr;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitParentClassMethodExpr
extends AbstractMethodExpr {
    protected final String _traitName;
    protected final StringValue _methodName;
    protected final int _hash;
    protected final Expr[] _args;
    protected boolean _isMethod;

    public TraitParentClassMethodExpr(Location location, String traitName, StringValue methodName, ArrayList<Expr> args) {
        super(location);
        this._traitName = traitName;
        this._methodName = methodName;
        this._hash = this._methodName.hashCodeCaseInsensitive();
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public TraitParentClassMethodExpr(Location location, String traitName, StringValue methodName, Expr[] args) {
        super(location);
        this._traitName = traitName;
        this._methodName = methodName;
        this._hash = this._methodName.hashCodeCaseInsensitive();
        this._args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        Value oldThis;
        QuercusClass cls = env.getThis().getQuercusClass();
        QuercusClass parent = cls.getTraitParent(env, this._traitName);
        Value[] values = TraitParentClassMethodExpr.evalArgs(env, this._args);
        Value qThis = oldThis = env.getThis();
        env.pushCall(this, parent, values);
        try {
            env.checkTimeout();
            Value value = parent.callStaticMethod(env, qThis, this._methodName, this._hash, values);
            return value;
        }
        finally {
            env.popCall();
            env.setThis(oldThis);
        }
    }

    @Override
    public String toString() {
        return "parent::" + this._methodName + "()";
    }
}

